/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.crypto;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum AlgorithmType {
    MD5("MD5", "1.2.840.113549.2.5", "http://www.w3.org/2001/04/xmldsig-more#md5", "MD5"),
    SHA1("SHA-1", "1.3.14.3.2.26", "http://www.w3.org/2000/09/xmldsig#sha1", "SHA-1", "SHA1"),
    SHA224("SHA-224", "2.16.840.1.101.3.4.2.4", "http://www.w3.org/2001/04/xmldsig-more#sha224", "SHA-224", "SHA224"),
    SHA256("SHA-256", "2.16.840.1.101.3.4.2.1", "http://www.w3.org/2001/04/xmlenc#sha256", "SHA-256", "SHA256"),
    SHA384("SHA-384", "2.16.840.1.101.3.4.2.2", "http://www.w3.org/2001/04/xmldsig-more#sha384", "SHA-384", "SHA384"),
    SHA512("SHA-512", "2.16.840.1.101.3.4.2.3", "http://www.w3.org/2001/04/xmlenc#sha512", "SHA-512", "SHA512"),
    RIPEMD160("RIPEMD160", "1.3.36.3.2.1", "http://www.w3.org/2001/04/xmlenc#ripemd160", "RIPEMD160"),
    WHIRLPOOL("WHIRLPOOL", "1.0.10118.3.0.55", "http://www.w3.org/2007/05/xmldsig-more#whirlpool", "WHIRLPOOL"),
    MGF1PSS("MGF-1", "1.2.840.113549.1.1.8", "http://www.w3.org/2007/05/xmldsig-more#MGF1", Context.SIGNING, "MGF-1", "MGF1"),
    MGF1OAEP("MGF-1", "1.2.840.113549.1.1.8", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", Context.CIPHERING, "MGF-1", "MGF1"),
    RSASSA_PSS("RSASSA-PSS", "1.2.840.113549.1.1.10", "http://www.w3.org/2007/05/xmldsign-more#rsa-pss", Context.SIGNING, "RSASSA-PSS"),
    RSAES_OAEP("RSAES-OAEP", "1.2.840.113549.1.1.7", "http://www.w3.org/2009/xmlenc#rsa-oaep", Context.CIPHERING, "RSA/OAEP");

    private final Context context;
    private final String name;
    private final String oid;
    private final String uri;
    private final List<String> listJCENames;

    private AlgorithmType(String name, String oid, String uri, String ... jceNames) {
        this(name, oid, uri, Arrays.asList(jceNames));
    }

    private AlgorithmType(String name, String oid, String uri, List<String> listJCENames) {
        this(name, oid, uri, Context.ALL, listJCENames);
    }

    private AlgorithmType(String name, String oid, String uri, Context context, String ... jceNames) {
        this(name, oid, uri, context, Arrays.asList(jceNames));
    }

    private AlgorithmType(String name, String oid, String uri, Context context, List<String> listJCENames) {
        this.name = name;
        this.oid = oid;
        this.uri = uri;
        this.context = context;
        this.listJCENames = Collections.unmodifiableList(listJCENames);
    }

    public static AlgorithmType getType(String algorithmName) {
        return AlgorithmType.getType(algorithmName, Context.ALL);
    }

    public Context getContext() {
        return this.context;
    }

    public static AlgorithmType getType(String algorithmName, Context context) {
        AlgorithmType result = null;
        for (AlgorithmType algorithm : AlgorithmType.values()) {
            if (context != null && Context.ALL != context && algorithm.context != context) continue;
            if (algorithm.getOID().equals(algorithmName)) {
                result = algorithm;
                break;
            }
            if (algorithm.getURI().equals(algorithmName)) {
                result = algorithm;
                break;
            }
            if (algorithm.getName().equals(algorithmName)) {
                result = algorithm;
                break;
            }
            if (!algorithm.getListJCENames().contains(algorithmName)) continue;
            result = algorithm;
            break;
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getOID() {
        return this.oid;
    }

    public String getURI() {
        return this.uri;
    }

    public List<String> getListJCENames() {
        return this.listJCENames;
    }

    public static enum Context {
        ALL,
        SIGNING,
        CIPHERING;

    }
}

