/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.crypto;

import de.bos_bremen.basecard.common.crypto.XMGF1ParameterSpec;
import de.bos_bremen.basecard.common.crypto.XOAEPParameterSpec;
import de.bos_bremen.basecard.common.crypto.XPSSParameterSpec;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.asn1.HashAlgorithm;
import de.bos_bremen.common.crypto.AlgorithmType;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PSource;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public final class AlgorithmIdentifierHelper {
    private AlgorithmIdentifierHelper() {
    }

    public static AlgorithmIdentifier createRSAPSSByHashAlgorithm(String hashAlgorithmName) throws IllegalArgumentException, NullPointerException, NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, IOException {
        HashAlgorithm.Algorithm hashAlgorithm = AlgorithmIdentifierHelper.getHashAlgorithm(hashAlgorithmName);
        return new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS, (ASN1Encodable)new XPSSParameterSpec(hashAlgorithmName, AlgorithmType.MGF1OAEP.getName(), new XMGF1ParameterSpec(hashAlgorithmName), hashAlgorithm.getHashLength(), 1).getBouncyCastleParams());
    }

    public static AlgorithmIdentifier createRSAOAEPByHashAlgorithm(String hashAlgorithmName) throws IllegalArgumentException, NullPointerException, NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, IOException {
        return new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSAES_OAEP, (ASN1Encodable)new XOAEPParameterSpec(hashAlgorithmName, AlgorithmType.MGF1PSS.getName(), new XMGF1ParameterSpec(hashAlgorithmName), PSource.PSpecified.DEFAULT).getBouncyCastleParams());
    }

    private static HashAlgorithm.Algorithm getHashAlgorithm(String hashAlgorithmName) {
        AssertUtil.notNullOrEmpty(hashAlgorithmName, "name of hash algorithm");
        return HashAlgorithm.Algorithm.getAlgorithmByName(hashAlgorithmName);
    }

    public static RSAESOAEPparams getOAEPParams(AlgorithmIdentifier algorithmIdentifier) throws NoSuchAlgorithmException, InvalidParameterSpecException, NoSuchProviderException, IOException {
        AlgorithmIdentifierHelper.checkOAEPPSSAlgorithmIdentifier(algorithmIdentifier, PKCSObjectIdentifiers.id_RSAES_OAEP);
        return new XOAEPParameterSpec(algorithmIdentifier).getBouncyCastleParams();
    }

    public static boolean isOAEPAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        return AlgorithmIdentifierHelper.isAlgorithmIdentifier(algorithmIdentifier, PKCSObjectIdentifiers.id_RSAES_OAEP);
    }

    public static boolean isPSSAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        return AlgorithmIdentifierHelper.isAlgorithmIdentifier(algorithmIdentifier, PKCSObjectIdentifiers.id_RSASSA_PSS);
    }

    public static ASN1Sequence getASN1SequenceParameters(AlgorithmIdentifier algorithmIdentifier) throws IOException {
        return ASN1Sequence.getInstance((Object)algorithmIdentifier.getParameters().toASN1Primitive().getEncoded("DER"));
    }

    public static RSASSAPSSparams getPSSParams(AlgorithmIdentifier algorithmIdentifier) throws IllegalArgumentException, NoSuchAlgorithmException, InvalidParameterSpecException, NoSuchProviderException, IOException {
        AlgorithmIdentifierHelper.checkOAEPPSSAlgorithmIdentifier(algorithmIdentifier, PKCSObjectIdentifiers.id_RSASSA_PSS);
        return new XPSSParameterSpec(algorithmIdentifier).getBouncyCastleParams();
    }

    public static XOAEPParameterSpec getSpec(RSAESOAEPparams params) throws NoSuchAlgorithmException, IOException, InvalidParameterSpecException, NoSuchProviderException {
        return new XOAEPParameterSpec(params);
    }

    public static XPSSParameterSpec getSpec(RSASSAPSSparams params) throws NoSuchAlgorithmException, IOException, InvalidParameterSpecException, NoSuchProviderException {
        return new XPSSParameterSpec(params);
    }

    private static void checkOAEPPSSAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier, ASN1ObjectIdentifier expectedAlgorithmObjectIdentifier) {
        AssertUtil.notNull(algorithmIdentifier, "algorithm identifier");
        ASN1ObjectIdentifier algorithmObjectIdentifier = algorithmIdentifier.getAlgorithm();
        AssertUtil.notNull(algorithmObjectIdentifier, "algorithm identifier OID");
        AssertUtil.equals(expectedAlgorithmObjectIdentifier, algorithmObjectIdentifier, "algorithm identifier OID");
        AssertUtil.notNull(algorithmIdentifier.getParameters(), "OAEP/PSS require parameters, null is invalid");
        AssertUtil.notEquals(DERNull.INSTANCE, algorithmIdentifier.getParameters(), "OAEP/PSS require parameters, DERNull is invalid");
    }

    private static boolean isAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier, ASN1ObjectIdentifier expectedAlgorithmObjectIdentifier) {
        if (algorithmIdentifier == null) {
            return false;
        }
        ASN1ObjectIdentifier algorithmObjectIdentifier = null;
        try {
            algorithmObjectIdentifier = algorithmIdentifier.getAlgorithm();
        }
        catch (NullPointerException e) {
            return false;
        }
        return expectedAlgorithmObjectIdentifier.equals((ASN1Primitive)algorithmObjectIdentifier);
    }
}

