/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1.cvc;

import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.asn1.cvc.AccessRoleAndRights;
import de.bos_bremen.common.asn1.cvc.BitIdentifier;
import de.bos_bremen.common.asn1.cvc.BitIdentifierImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SignatureTerminals
extends AccessRoleAndRights {
    public static final String OID_SUFFIX_SIGNATURE_TERMINAL = ".3";
    public static final String OID_ACCESS_ROLE_AND_RIGHTS_SIGNATURE_TERMINAL = "0.4.0.127.0.7.3.1.2.3";
    public static final OID OID_SIGNATURE_TERMINAL = new OID("0.4.0.127.0.7.3.1.2.3");
    public static final int VALUE_BYTE_COUNT = 1;
    public static final byte ACCESS_ROLE_MASK_DV_ACCREDITATION_BODY = -128;
    public static final String ACCESS_ROLE_NAME_DV_ACCREDITATION_BODY = "DV (Accreditation Body)";
    public static final byte ACCESS_ROLE_MASK_DV_CERTIFICATION_SERVICE_PROVIDER = 64;
    public static final String ACCESS_ROLE_NAME_DV_CERTIFICATION_SERVICE_PROVIDER = "DV (Certification Service Provider)";
    public static final byte ACCESS_ROLE_MASK_SIGNATURE_TERMINAL = 0;
    public static final String ACCESS_ROLE_NAME_SIGNATURE_TERMINAL = "Signature Terminal";
    public static final byte ACCESS_RIGHT_MASK_ESIGN_GENERATE_QUALIFIED_ELECTRONIC_SIGNATURE = 2;
    public static final String ACCESS_RIGHT_NAME_ESIGN_GENERATE_QUALIFIED_ELECTRONIC_SIGNATURE = "eSign Generate Qualified Electronic Signature";
    public static final byte ACCESS_RIGHT_MASK_ESIGN_GENERATE_ELECTRONIC_SIGNATURE = 1;
    public static final String ACCESS_RIGHT_NAME_ESIGN_GENERATE_ELECTRONIC_SIGNATURE = "eSign Generate Electronic Signature";
    public static final List<BitIdentifier> ACCESS_ROLES_LIST = Collections.unmodifiableList(Arrays.asList((BitIdentifier[])AccessRoleEnum.values()));
    public static final List<BitIdentifier> ACCESS_RIGHTS_LIST = Collections.unmodifiableList(Arrays.asList((BitIdentifier[])AccessRightEnum.values()));

    public static String getOIDString() {
        return OID_ACCESS_ROLE_AND_RIGHTS_SIGNATURE_TERMINAL;
    }

    public SignatureTerminals(byte[] bytes) throws IOException {
        super(bytes, 1, ACCESS_ROLES_LIST, ACCESS_RIGHTS_LIST);
    }

    public boolean isCVCA() {
        return super.getAccessRolesList().contains(AccessRoleEnum.CVCA);
    }

    public boolean isDVAccreditationBody() {
        return super.getAccessRolesList().contains(AccessRoleEnum.DV_ACCREDITATION_BODY);
    }

    public boolean isDVCertificationServiceProvider() {
        return super.getAccessRolesList().contains(AccessRoleEnum.DV_CERTIFICATION_SERVICE_PROVIDER);
    }

    public boolean isSignatureTerminal() {
        return super.getAccessRolesList().contains(AccessRoleEnum.SIGNATURE_TERMINAL);
    }

    public boolean existsRightGenerateQualifiedElectronicSignature() {
        return super.getAccessRightsList().contains(AccessRightEnum.ESIGN_GENERATE_QUALIFIED_ELECTRONIC_SIGNATURE);
    }

    public boolean existsRightGenerateElectronicSignature() {
        return super.getAccessRightsList().contains(AccessRightEnum.ESIGN_GENERATE_ELECTRONIC_SIGNATURE);
    }

    @Override
    public OID getOID() {
        return OID_SIGNATURE_TERMINAL;
    }

    public static enum AccessRightEnum implements BitIdentifier
    {
        ESIGN_GENERATE_QUALIFIED_ELECTRONIC_SIGNATURE(new BitIdentifierImpl("eSign Generate Qualified Electronic Signature", 0, 2)),
        ESIGN_GENERATE_ELECTRONIC_SIGNATURE(new BitIdentifierImpl("eSign Generate Electronic Signature", 0, 1));

        private BitIdentifier bitIdentifier = null;

        private AccessRightEnum(BitIdentifier bitIdentifier) throws IllegalArgumentException {
            if (bitIdentifier == null) {
                throw new IllegalArgumentException("BitIdentifier expected");
            }
            this.bitIdentifier = bitIdentifier;
        }

        @Override
        public boolean accept(ASN1 asn1) {
            return this.bitIdentifier.accept(asn1);
        }

        @Override
        public boolean accept(byte[] asn1ValueBytes) {
            return this.bitIdentifier.accept(asn1ValueBytes);
        }

        @Override
        public byte getBitMask() {
            return this.bitIdentifier.getBitMask();
        }

        @Override
        public int getByteIndex() {
            return this.bitIdentifier.getByteIndex();
        }

        @Override
        public Integer getBitIndex() {
            return this.bitIdentifier.getBitIndex();
        }

        @Override
        public String getName() {
            return this.bitIdentifier.getName();
        }

        @Override
        public byte getByteMask() {
            return this.bitIdentifier.getByteMask();
        }

        public String toString() {
            return this.getName();
        }
    }

    public static enum AccessRoleEnum implements BitIdentifier
    {
        CVCA(AccessRoleAndRights.IDENTIFIER_CVCA),
        DV_ACCREDITATION_BODY(new BitIdentifierImpl("DV (Accreditation Body)", 0, -64, -128)),
        DV_CERTIFICATION_SERVICE_PROVIDER(new BitIdentifierImpl("DV (Certification Service Provider)", 0, -64, 64)),
        SIGNATURE_TERMINAL(new BitIdentifierImpl("Signature Terminal", 0, -64, 0));

        private BitIdentifier bitIdentifier = null;

        private AccessRoleEnum(BitIdentifier bitIdentifier) throws IllegalArgumentException {
            if (bitIdentifier == null) {
                throw new IllegalArgumentException("BitIdentifier expected");
            }
            this.bitIdentifier = bitIdentifier;
        }

        @Override
        public boolean accept(ASN1 asn1) {
            return this.bitIdentifier.accept(asn1);
        }

        @Override
        public boolean accept(byte[] asn1ValueBytes) {
            return this.bitIdentifier.accept(asn1ValueBytes);
        }

        @Override
        public byte getBitMask() {
            return this.bitIdentifier.getBitMask();
        }

        @Override
        public int getByteIndex() {
            return this.bitIdentifier.getByteIndex();
        }

        @Override
        public String getName() {
            return this.bitIdentifier.getName();
        }

        @Override
        public byte getByteMask() {
            return this.bitIdentifier.getByteMask();
        }

        @Override
        public Integer getBitIndex() {
            return this.bitIdentifier.getBitIndex();
        }

        public String toString() {
            return this.getName();
        }
    }
}

