/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1.cvc;

import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.asn1.cvc.AccessRoleAndRights;
import de.bos_bremen.common.asn1.cvc.BaseAccessRoleAndRights;
import de.bos_bremen.common.asn1.cvc.BitIdentifier;
import de.bos_bremen.common.asn1.cvc.BitIdentifierImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class InspectionSystems
extends BaseAccessRoleAndRights {
    public static final String OID_SUFFIX_INSPECTION_SYSTEM = ".1";
    public static final String OID_ACCESS_ROLE_AND_RIGHTS_INSPECTION_SYSTEM = "0.4.0.127.0.7.3.1.2.1";
    public static final OID OID_INSPECTION_SYSTEMS = new OID("0.4.0.127.0.7.3.1.2.1");
    public static final int VALUE_BYTE_COUNT = 1;
    public static final byte ROLE_MASK_INSPECTION_SYSTEM = 0;
    public static final String ROLE_NAME_INSPECTION_SYSTEM = "Inspection System";
    public static final byte ACCESS_RIGHT_MASK_READ_EID_APPLICATION = 32;
    public static final String ACCESS_RIGHT_NAME_READ_ACCESS_EID_APPLICATION = "Read access to eID application";
    public static final byte ACCESS_RIGHT_MASK_READ_EPASSPORT_DG4 = 2;
    public static final String ACCESS_RIGHT_NAME_READ_ACCESS_EPASSPORT_DG4 = "Read access to ePassport application: DG4 (Iris)";
    public static final byte ACCESS_RIGHT_MASK_READ_EPASSPORT_DG3 = 1;
    public static final String ACCESS_RIGHT_NAME_READ_ACCESS_EPASSPORT_DG3 = "Read access to ePassport application: DG3 (Fingerprint)";
    public static final List<BitIdentifier> ACCESS_ROLES_LIST = Collections.unmodifiableList(Arrays.asList((BitIdentifier[])AccessRoleEnum.values()));
    public static final List<BitIdentifier> ACCESS_RIGHTS_LIST = Collections.unmodifiableList(Arrays.asList((BitIdentifier[])AccessRightEnum.values()));

    public static String getOIDString() {
        return OID_ACCESS_ROLE_AND_RIGHTS_INSPECTION_SYSTEM;
    }

    public InspectionSystems(byte[] bytes) throws IOException {
        super(bytes, 1, ACCESS_ROLES_LIST, ACCESS_RIGHTS_LIST);
    }

    public boolean isCVCA() {
        return super.getAccessRolesList().contains(AccessRoleEnum.CVCA);
    }

    public boolean isDVOfficialDomestic() {
        return super.isRole(AccessRoleEnum.DV_OFFICIAL_DOMESTIC);
    }

    public boolean isDVOfficialForeign() {
        return super.isRole(AccessRoleEnum.DV_OFFICIAL_FOREIGN);
    }

    public boolean isInspectionSystem() {
        return this.isCVCA() || super.isRole(AccessRoleEnum.INSPECTION_SYSTEM);
    }

    public boolean existsReadAccessToEIDApplication() {
        return super.existsRight(AccessRightEnum.READ_ACCESS_EID_APPLICATION);
    }

    public boolean existsReadAccessToEPassportApplicationDG4() {
        return super.existsRight(AccessRightEnum.READ_ACCESS_EPASSPORT_DG4);
    }

    public boolean existsReadAccessToEPassportApplicationDG3() {
        return super.existsRight(AccessRightEnum.READ_ACCESS_EPASSPORT_DG3);
    }

    @Override
    public OID getOID() {
        return OID_INSPECTION_SYSTEMS;
    }

    public static enum AccessRightEnum implements BitIdentifier
    {
        READ_ACCESS_EID_APPLICATION(new BitIdentifierImpl("Read access to eID application", 0, 32)),
        READ_ACCESS_EPASSPORT_DG4(new BitIdentifierImpl("Read access to ePassport application: DG4 (Iris)", 0, 2)),
        READ_ACCESS_EPASSPORT_DG3(new BitIdentifierImpl("Read access to ePassport application: DG3 (Fingerprint)", 0, 1));

        private BitIdentifier bitIdentifier = null;

        private AccessRightEnum(BitIdentifier bitIdentifier) throws IllegalArgumentException {
            if (bitIdentifier == null) {
                throw new IllegalArgumentException("BitIdentifier expected");
            }
            this.bitIdentifier = bitIdentifier;
        }

        @Override
        public boolean accept(ASN1 asn1) {
            return this.bitIdentifier.accept(asn1);
        }

        @Override
        public boolean accept(byte[] asn1ValueBytes) {
            return this.bitIdentifier.accept(asn1ValueBytes);
        }

        @Override
        public byte getBitMask() {
            return this.bitIdentifier.getBitMask();
        }

        @Override
        public int getByteIndex() {
            return this.bitIdentifier.getByteIndex();
        }

        @Override
        public String getName() {
            return this.bitIdentifier.getName();
        }

        @Override
        public byte getByteMask() {
            return this.bitIdentifier.getByteMask();
        }

        @Override
        public Integer getBitIndex() {
            return this.bitIdentifier.getBitIndex();
        }

        public String toString() {
            return this.getName();
        }
    }

    public static enum AccessRoleEnum implements BitIdentifier
    {
        CVCA(AccessRoleAndRights.IDENTIFIER_CVCA),
        DV_OFFICIAL_DOMESTIC(BaseAccessRoleAndRights.IDENTIFIER_DV_OFFICIAL_DOMESTIC),
        DV_OFFICIAL_FOREIGN(BaseAccessRoleAndRights.IDENTIFIER_DV_OFFICIAL_FOREIGN),
        INSPECTION_SYSTEM(new BitIdentifierImpl("Inspection System", 0, -64, 0));

        private BitIdentifier bitIdentifier = null;

        private AccessRoleEnum(BitIdentifier bitIdentifier) throws IllegalArgumentException {
            if (bitIdentifier == null) {
                throw new IllegalArgumentException("BitIdentifier expected");
            }
            this.bitIdentifier = bitIdentifier;
        }

        @Override
        public boolean accept(ASN1 asn1) {
            return this.bitIdentifier.accept(asn1);
        }

        @Override
        public boolean accept(byte[] asn1ValueBytes) {
            return this.bitIdentifier.accept(asn1ValueBytes);
        }

        @Override
        public byte getBitMask() {
            return this.bitIdentifier.getBitMask();
        }

        @Override
        public int getByteIndex() {
            return this.bitIdentifier.getByteIndex();
        }

        @Override
        public String getName() {
            return this.bitIdentifier.getName();
        }

        @Override
        public byte getByteMask() {
            return this.bitIdentifier.getByteMask();
        }

        @Override
        public Integer getBitIndex() {
            return this.bitIdentifier.getBitIndex();
        }

        public String toString() {
            return this.getName();
        }
    }
}

