/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1.cvc;

import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.ASN1Path;
import de.bos_bremen.common.asn1.cvc.ECPublicKeyPath;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class ECPublicKey
extends ASN1 {
    public ECPublicKey() throws IOException {
        super(ECPublicKeyPath.EC_PUBLIC_KEY.getTag().toByteArray(), new byte[0]);
    }

    public ECPublicKey(ECPublicKey key) throws IllegalArgumentException {
        super(key);
        this.check();
    }

    public ECPublicKey(byte[] bytes) throws IOException, IllegalArgumentException {
        super(bytes);
        this.check();
    }

    public ECPublicKey(InputStream stream, boolean close) throws IOException, IllegalArgumentException {
        super(stream, close);
        this.check();
    }

    public ECPublicKey(InputStream stream) throws IOException, IllegalArgumentException {
        super(stream);
        this.check();
    }

    private void check() throws IllegalArgumentException {
        if (!Arrays.equals(ECPublicKeyPath.EC_PUBLIC_KEY.getTag().toByteArray(), this.getDTagBytes())) {
            throw new IllegalArgumentException("ASN.1 does not represent an EC public key");
        }
        try {
            List<ASN1> childList = this.getChildElementList();
            int size = childList.size();
            if (size == 2 || size == 3) {
                if (!Arrays.equals(ECPublicKeyPath.PUBLIC_POINT_Y.getTag().toByteArray(), childList.get(1).getDTagBytes())) {
                    throw new IllegalArgumentException("ASN.1 does not represent an EC public key");
                }
                if (size == 3 && !Arrays.equals(ECPublicKeyPath.CO_FACTOR_F.getTag().toByteArray(), childList.get(2).getDTagBytes())) {
                    throw new IllegalArgumentException("ASN.1 does not represent an EC public key");
                }
            } else if (size == 7 || size == 8) {
                if (!Arrays.equals(ECPublicKeyPath.PRIME_MODULUS.getTag().toByteArray(), childList.get(1).getDTagBytes())) {
                    throw new IllegalArgumentException("ASN.1 does not represent an EC public key");
                }
                if (!Arrays.equals(ECPublicKeyPath.COEFFICIENT_A.getTag().toByteArray(), childList.get(2).getDTagBytes())) {
                    throw new IllegalArgumentException("ASN.1 does not represent an EC public key");
                }
                if (!Arrays.equals(ECPublicKeyPath.COEFFICIENT_B.getTag().toByteArray(), childList.get(3).getDTagBytes())) {
                    throw new IllegalArgumentException("ASN.1 does not represent an EC public key");
                }
                if (!Arrays.equals(ECPublicKeyPath.BASE_POINT_G.getTag().toByteArray(), childList.get(4).getDTagBytes())) {
                    throw new IllegalArgumentException("ASN.1 does not represent an EC public key");
                }
                if (!Arrays.equals(ECPublicKeyPath.ORDER_OF_BASE_POINT_R.getTag().toByteArray(), childList.get(5).getDTagBytes())) {
                    throw new IllegalArgumentException("ASN.1 does not represent an EC public key");
                }
                if (!Arrays.equals(ECPublicKeyPath.PUBLIC_POINT_Y.getTag().toByteArray(), childList.get(6).getDTagBytes())) {
                    throw new IllegalArgumentException("ASN.1 does not represent an EC public key");
                }
                if (size == 8 && !Arrays.equals(ECPublicKeyPath.CO_FACTOR_F.getTag().toByteArray(), childList.get(7).getDTagBytes())) {
                    throw new IllegalArgumentException("ASN.1 does not represent an EC public key");
                }
            } else {
                throw new IllegalArgumentException("ASN.1 does not represent an EC public key");
            }
            if (!Arrays.equals(ECPublicKeyPath.OID.getTag().toByteArray(), childList.get(0).getDTagBytes())) {
                throw new IllegalArgumentException("ASN.1 does not represent an EC public key");
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("ASN.1 does not represent an EC public key", e);
        }
    }

    @Override
    public ASN1 getChildElementByPath(ASN1Path part) throws IOException {
        if (!ECPublicKeyPath.class.isInstance(part)) {
            throw new IllegalArgumentException("only ECPublicKeyPath permitted");
        }
        return super.getChildElementByPath(part);
    }

    @Override
    public ASN1 decode(byte[] bytes) throws IllegalArgumentException, UnsupportedOperationException, IOException {
        ECPublicKey key = new ECPublicKey(bytes);
        super.decode(key);
        this.check();
        return this;
    }

    @Override
    public ASN1 decode(ASN1 asn1) throws IllegalArgumentException, IllegalStateException {
        super.decode(asn1);
        this.check();
        return this;
    }
}

