/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1.cvc;

import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.ASN1Path;
import de.bos_bremen.common.asn1.cvc.ECCVCPath;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class ECCVCertificate
extends ASN1 {
    public ECCVCertificate(ECCVCertificate certificate) throws IllegalArgumentException {
        super(certificate);
        this.check();
    }

    public ECCVCertificate(byte[] bytes) throws IOException, IllegalArgumentException {
        super(bytes);
        this.check();
    }

    public ECCVCertificate(byte[] tagBytes, byte[] valueBytes) throws IOException, IllegalArgumentException {
        super(tagBytes, valueBytes);
        this.check();
    }

    public ECCVCertificate(InputStream stream, boolean close) throws IOException, IllegalArgumentException {
        super(stream, close);
        this.check();
    }

    public ECCVCertificate(InputStream stream) throws IOException, IllegalArgumentException {
        super(stream);
        this.check();
    }

    private void check() throws IllegalArgumentException {
        if (!Arrays.equals(ECCVCPath.CV_CERTIFICATE.getTag().toByteArray(), this.getDTagBytes())) {
            throw new IllegalArgumentException("ASN.1 does not represent a CV certificate");
        }
        try {
            List<ASN1> childList = this.getChildElementList();
            if (childList.size() != 2) {
                throw new IllegalArgumentException("ASN.1 does not represent a CV certificate");
            }
            if (!Arrays.equals(ECCVCPath.CV_CERTIFICATE_BODY.getTag().toByteArray(), childList.get(0).getDTagBytes())) {
                throw new IllegalArgumentException("ASN.1 does not represent a CV certificate");
            }
            if (!Arrays.equals(ECCVCPath.SIGNATURE.getTag().toByteArray(), childList.get(1).getDTagBytes())) {
                throw new IllegalArgumentException("ASN.1 does not represent a CV certificate");
            }
            List<ASN1> bodyChildList = childList.get(0).getChildElementList();
            if (bodyChildList.size() != 7 && bodyChildList.size() != 8) {
                throw new IllegalArgumentException("ASN.1 does not represent a CV certificate");
            }
            if (!Arrays.equals(ECCVCPath.PROFILE_IDENTIFIER.getTag().toByteArray(), bodyChildList.get(0).getDTagBytes())) {
                throw new IllegalArgumentException("ASN.1 does not represent a CV certificate");
            }
            if (!Arrays.equals(ECCVCPath.CA_REFERENCE.getTag().toByteArray(), bodyChildList.get(1).getDTagBytes())) {
                throw new IllegalArgumentException("ASN.1 does not represent a CV certificate");
            }
            if (!Arrays.equals(ECCVCPath.PUBLIC_KEY.getTag().toByteArray(), bodyChildList.get(2).getDTagBytes())) {
                throw new IllegalArgumentException("ASN.1 does not represent a CV certificate");
            }
            if (!Arrays.equals(ECCVCPath.HOLDER_REFERENCE.getTag().toByteArray(), bodyChildList.get(3).getDTagBytes())) {
                throw new IllegalArgumentException("ASN.1 does not represent a CV certificate");
            }
            if (!Arrays.equals(ECCVCPath.CERTIFICATE_HOLDER_AUTHORIZATION_TEMPLATE.getTag().toByteArray(), bodyChildList.get(4).getDTagBytes())) {
                throw new IllegalArgumentException("ASN.1 does not represent a CV certificate");
            }
            if (!Arrays.equals(ECCVCPath.EFFECTIVE_DATE.getTag().toByteArray(), bodyChildList.get(5).getDTagBytes())) {
                throw new IllegalArgumentException("ASN.1 does not represent a CV certificate");
            }
            if (!Arrays.equals(ECCVCPath.EXPIRATION_DATE.getTag().toByteArray(), bodyChildList.get(6).getDTagBytes())) {
                throw new IllegalArgumentException("ASN.1 does not represent a CV certificate");
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("ASN.1 does not represent a CV certificate", e);
        }
    }

    @Override
    public ASN1 getChildElementByPath(ASN1Path path) throws IOException {
        if (!ECCVCPath.class.isInstance(path)) {
            throw new IllegalArgumentException("only CVCPart permitted");
        }
        return super.getChildElementByPath(path);
    }

    public ASN1 getCVCPart(ECCVCPath path) throws IOException, IllegalArgumentException {
        return super.getChildElementByPath(path);
    }

    @Override
    public ASN1 decode(byte[] bytes) throws IllegalArgumentException, IOException, IllegalStateException {
        ECCVCertificate cvc = new ECCVCertificate(bytes);
        super.decode(cvc);
        return this;
    }
}

