/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1.cvc;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.AbstractASN1Encoder;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.asn1.cvc.AccessRoleAndRights;
import de.bos_bremen.common.asn1.cvc.AuthenticationTerminals;
import de.bos_bremen.common.asn1.cvc.CertificateHolderAuthorizationTemplatePath;
import de.bos_bremen.common.asn1.cvc.InspectionSystems;
import de.bos_bremen.common.asn1.cvc.SignatureTerminals;
import java.io.IOException;

public class CertificateHolderAuthorizationTemplate
extends AbstractASN1Encoder {
    private AccessRoleAndRights accessRoleAndRights = null;

    public static <T extends AccessRoleAndRights> CertificateHolderAuthorizationTemplate createFromOIDAndChatMatrix(OID oidAccessRoleAndRights, byte[] chatMatrix) throws IllegalArgumentException, UnsupportedOperationException, IOException {
        AssertUtil.notNull(oidAccessRoleAndRights, "OID");
        AssertUtil.notNullOrEmpty(chatMatrix, "chat matrix bytes");
        ASN1 resultRolesAndRights = new ASN1(CertificateHolderAuthorizationTemplatePath.HAT_ACCESS_ROLE_AND_RIGHTS.getTag().toByteArray(), chatMatrix);
        byte[] value = ByteUtil.combine(oidAccessRoleAndRights.getEncoded(), resultRolesAndRights.getEncoded());
        ASN1 asn1 = new ASN1(CertificateHolderAuthorizationTemplatePath.CERTIFICATE_HOLDER_AUTHORIZATION_TEMPLATE.getTag().toByteArray(), value);
        CertificateHolderAuthorizationTemplate result = new CertificateHolderAuthorizationTemplate();
        result.decode(asn1.getEncoded());
        return result;
    }

    @Override
    public ASN1 decode(ASN1 asn1) throws IllegalArgumentException {
        if (asn1 == null) {
            return null;
        }
        super.copy(asn1);
        return this;
    }

    @Override
    protected void update() throws IllegalStateException, IllegalArgumentException {
        block6: {
            try {
                OID oidChild = (OID)this.getChildElementByPath(CertificateHolderAuthorizationTemplatePath.HAT_OID);
                ASN1 accessRoleAndRightsChild = this.getChildElementByPath(CertificateHolderAuthorizationTemplatePath.HAT_ACCESS_ROLE_AND_RIGHTS);
                if (oidChild == null || accessRoleAndRightsChild == null) {
                    throw new IllegalArgumentException("incompatible ASN.1 object");
                }
                if (oidChild.getOIDString().equals(InspectionSystems.getOIDString())) {
                    this.accessRoleAndRights = new InspectionSystems(accessRoleAndRightsChild.getEncoded());
                    break block6;
                }
                if (oidChild.getOIDString().equals(AuthenticationTerminals.getOIDString())) {
                    this.accessRoleAndRights = new AuthenticationTerminals(accessRoleAndRightsChild.getEncoded());
                    break block6;
                }
                if (oidChild.getOIDString().equals(SignatureTerminals.getOIDString())) {
                    this.accessRoleAndRights = new SignatureTerminals(accessRoleAndRightsChild.getEncoded());
                    break block6;
                }
                throw new IllegalArgumentException("not acceptable OID used, possible OIDs are " + AuthenticationTerminals.getOIDString() + " for AuthenticationTerminals, " + SignatureTerminals.getOIDString() + " for SignatureTerminals,  and " + InspectionSystems.getOIDString() + "  for InspectionSystems");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("incompatible ASN.1 object");
            }
        }
    }

    public AccessRoleAndRights getAccessRoleAndRights() {
        return this.accessRoleAndRights;
    }

    @Override
    public String toString(boolean format) {
        return super.toString(format) + "\nAccessRoleAndRights: " + (this.accessRoleAndRights != null ? this.accessRoleAndRights.getClass().getName() : null);
    }
}

