/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1.cvc;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.DigestUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.ASN1Path;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.asn1.cvc.CertificateDescriptionPath;
import de.bos_bremen.common.asn1.cvc.ECCVCPath;
import de.bos_bremen.common.asn1.cvc.ECCVCertificate;
import de.bos_bremen.common.constants.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public class CertificateDescription
extends ASN1 {
    private static final String DEFAULT_ENCODING_UTF8 = "UTF-8";
    public static final List<CertificateDescriptionPath> USAGE_TYPE_LIST = Collections.unmodifiableList(Arrays.asList(CertificateDescriptionPath.TERMS_OF_USAGE_PLAIN_TEXT, CertificateDescriptionPath.TERMS_OF_USAGE_HTML, CertificateDescriptionPath.TERMS_OF_USAGE_PDF));

    public CertificateDescription(String oid, String issuer, String issuerURL, String subject, String subjectURL, CertificateDescriptionPath usageType, byte[] usage, String redirectURL, List<byte[]> commCertificatesNotHashed, byte[] rootCertBytes) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        this(oid, issuer, issuerURL, subject, subjectURL, usageType, usage, redirectURL, null);
        if (commCertificatesNotHashed != null && !commCertificatesNotHashed.isEmpty()) {
            AssertUtil.notNullOrEmpty(rootCertBytes, "bytes of root certificate");
            ECCVCertificate rootCert = new ECCVCertificate(rootCertBytes);
            byte[] hashedCerts = CertificateDescription.hashCommCertificates(rootCert, commCertificatesNotHashed);
            this.setCommCertificates(hashedCerts);
        }
    }

    public CertificateDescription(String oid, String issuer, String issuerURL, String subject, String subjectURL, CertificateDescriptionPath usageType, byte[] usage, String redirectURL, byte[] commCertificates) throws IOException {
        this(Constants.EMPTY_PRIMITIVE_BYTE_ARRAY);
        if (oid != null) {
            this.setOID(oid);
        }
        if (issuer != null) {
            this.setIssuer(issuer);
        }
        if (issuerURL != null) {
            this.setIssuerURL(issuerURL);
        }
        if (subject != null) {
            this.setSubject(subject);
        }
        if (subjectURL != null) {
            this.setSubjectURL(subjectURL);
        }
        if (usageType != null && usage != null) {
            this.setTermsOfUsage(usageType, usage);
        }
        if (redirectURL != null) {
            this.setRedirectURL(redirectURL);
        }
        if (commCertificates != null) {
            this.setCommCertificates(commCertificates);
        }
    }

    public CertificateDescription(String oid, String issuer, String issuerURL, String subject, String subjectURL, CertificateDescriptionPath usageType, byte[] usage, String redirectURL) throws IOException {
        this(oid, issuer, issuerURL, subject, subjectURL, usageType, usage, redirectURL, null);
    }

    @Deprecated
    public byte[] getHash(String hashAlgorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest md = MessageDigest.getInstance(hashAlgorithm, "BC");
        return md.digest(this.getEncoded());
    }

    public synchronized void setTermsOfUsage(CertificateDescriptionPath usageType, byte[] usage) throws IOException {
        if (!USAGE_TYPE_LIST.contains(usageType)) {
            throw new IllegalArgumentException("illegal usage type, permitted only: " + USAGE_TYPE_LIST);
        }
        super.removeChildElement(this.getChildElementByPath(CertificateDescriptionPath.TERMS_OF_USAGE), null);
        this.addChildElement(new ASN1(CertificateDescriptionPath.TERMS_OF_USAGE.getTag().toByteArray(), new ASN1(usageType.getTag().toByteArray(), usage).getEncoded()), null);
    }

    public synchronized void setOID(String oid) throws IOException {
        AssertUtil.notNull(oid, "OID");
        super.removeChildElement(this.getChildElementByPath(CertificateDescriptionPath.DESCRIPTION_TYPE), null);
        this.addChildElement(new OID(oid), null);
    }

    public synchronized void setSubject(String subject) throws IOException {
        AssertUtil.notNull(subject, "subject");
        super.removeChildElement(this.getChildElementByPath(CertificateDescriptionPath.SUBJECT_NAME_PART), null);
        this.addChildElement(new ASN1(CertificateDescriptionPath.SUBJECT_NAME_PART.getTag().toByteArray(), new ASN1(CertificateDescriptionPath.SUBJECT_NAME.getTag().toByteArray(), subject.getBytes(DEFAULT_ENCODING_UTF8)).getEncoded()), null);
    }

    public synchronized void setSubjectURL(String subjectURL) throws IOException {
        AssertUtil.notNull(subjectURL, "subject URL");
        super.removeChildElement(this.getChildElementByPath(CertificateDescriptionPath.SUBJECT_URL_PART), null);
        this.addChildElement(new ASN1(CertificateDescriptionPath.SUBJECT_URL_PART.getTag().toByteArray(), new ASN1(CertificateDescriptionPath.SUBJECT_URL.getTag().toByteArray(), subjectURL.getBytes(DEFAULT_ENCODING_UTF8)).getEncoded()), null);
    }

    public synchronized void setIssuer(String issuer) throws IOException {
        AssertUtil.notNull(issuer, "issuer");
        super.removeChildElement(this.getChildElementByPath(CertificateDescriptionPath.ISSUER_NAME_PART), null);
        this.addChildElement(new ASN1(CertificateDescriptionPath.ISSUER_NAME_PART.getTag().toByteArray(), new ASN1(CertificateDescriptionPath.ISSUER_NAME.getTag().toByteArray(), issuer.getBytes(DEFAULT_ENCODING_UTF8)).getEncoded()), null);
    }

    public synchronized void setIssuerURL(String issuerURL) throws IOException {
        AssertUtil.notNull(issuerURL, "issuer URL");
        super.removeChildElement(this.getChildElementByPath(CertificateDescriptionPath.ISSUER_URL_PART), null);
        this.addChildElement(new ASN1(CertificateDescriptionPath.ISSUER_URL_PART.getTag().toByteArray(), new ASN1(CertificateDescriptionPath.ISSUER_URL.getTag().toByteArray(), issuerURL.getBytes(DEFAULT_ENCODING_UTF8)).getEncoded()), null);
    }

    public synchronized void setRedirectURL(String redirectURL) throws IOException {
        AssertUtil.notNull(redirectURL, "redirect URL");
        super.removeChildElement(this.getChildElementByPath(CertificateDescriptionPath.REDIRECT_URL_PART), null);
        this.addChildElement(new ASN1(CertificateDescriptionPath.REDIRECT_URL_PART.getTag().toByteArray(), new ASN1(CertificateDescriptionPath.REDIRECT_URL.getTag().toByteArray(), redirectURL.getBytes(DEFAULT_ENCODING_UTF8)).getEncoded()), null);
    }

    public synchronized void setCommCertificates(byte[] commCertificates) throws IOException {
        AssertUtil.notNullOrEmpty(commCertificates, "communication certificate hashes");
        super.removeChildElement(this.getChildElementByPath(CertificateDescriptionPath.COMM_CERTIFICATES_PART), null);
        this.addChildElement(new ASN1(CertificateDescriptionPath.COMM_CERTIFICATES_PART.getTag().toByteArray(), new ASN1(CertificateDescriptionPath.COMM_CERTIFICATES.getTag().toByteArray(), commCertificates).getEncoded()), null);
    }

    public CertificateDescription(CertificateDescription certificateDescription) {
        super(certificateDescription);
        this.check();
    }

    public CertificateDescription(byte[] valueBytes) throws IOException {
        super(CertificateDescriptionPath.CERTIFICATE_DESCRIPTION.getTag().toByteArray(), valueBytes);
        this.check();
    }

    private void check() {
        if (!Arrays.equals(CertificateDescriptionPath.CERTIFICATE_DESCRIPTION.getTag().toByteArray(), this.getDTagBytes())) {
            throw new IllegalArgumentException("ASN.1 does not represent a certificate description");
        }
    }

    public CertificateDescription(InputStream stream, boolean close) throws IOException {
        super(stream, close);
        this.check();
    }

    public CertificateDescription(InputStream stream) throws IOException {
        super(stream);
        this.check();
    }

    @Override
    public ASN1 getChildElementByPath(ASN1Path part) throws IOException {
        if (!CertificateDescriptionPath.class.isInstance(part)) {
            throw new IllegalArgumentException("only CertificateDescriptionPath permitted");
        }
        return super.getChildElementByPath(part);
    }

    public ASN1 getCertificateDescriptionPart(CertificateDescriptionPath path) throws IOException {
        return super.getChildElementByPath(path);
    }

    @Override
    public ASN1 decode(byte[] bytes) throws IOException {
        AssertUtil.notNullOrEmpty(bytes, "bytes");
        ASN1 cd = new ASN1(bytes);
        super.decode(cd);
        return this;
    }

    public static byte[] hashCommCertificates(ECCVCertificate rootCert, List<byte[]> commCerts) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        AssertUtil.notNull(rootCert, "root CVC");
        AssertUtil.notNullOrEmpty(commCerts, "list of certificates");
        OID oid = new OID(rootCert.getChildElementByPath(ECCVCPath.PUBLIC_KEY_OID).getEncoded());
        MessageDigest md = DigestUtil.getDigestByOID(oid);
        int targetLength = md.getDigestLength();
        byte[] result = null;
        TreeSet<BigInteger> sorted = new TreeSet<BigInteger>();
        for (byte[] singleCert : commCerts) {
            byte[] digested = md.digest(singleCert);
            sorted.add(new BigInteger(ByteUtil.addLeadingZero(digested)));
        }
        for (BigInteger bi : sorted) {
            byte[] biBytes = bi.toByteArray();
            if (biBytes.length > targetLength) {
                biBytes = ByteUtil.subbytes(biBytes, biBytes.length - targetLength);
            } else if (biBytes.length < targetLength) {
                biBytes = ByteUtil.combine(new byte[targetLength - biBytes.length], biBytes);
            }
            ASN1 digestASN1 = new ASN1(4, biBytes);
            result = ByteUtil.combine(result, digestASN1.getEncoded());
        }
        return result;
    }

    public static byte[] hashCertDescription(ECCVCertificate rootCert, CertificateDescription cd) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        AssertUtil.notNull(rootCert, "root CVC");
        AssertUtil.notNull(cd, "certificate description");
        OID oid = new OID(rootCert.getChildElementByPath(ECCVCPath.PUBLIC_KEY_OID).getEncoded());
        MessageDigest md = DigestUtil.getDigestByOID(oid);
        return md.digest(cd.getEncoded());
    }
}

