/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1.cvc;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.cvc.BitIdentifier;

public class BitIdentifierImpl
implements BitIdentifier {
    private Integer bitIndex = null;
    private int byteIndex = -1;
    byte byteMask = (byte)-1;
    private byte bitMask = (byte)-1;
    private String name = null;

    public BitIdentifierImpl(String name, int byteIndex, int bitIndex) throws IllegalArgumentException {
        this(name, byteIndex, (byte)Math.pow(2.0, bitIndex % 8));
        AssertUtil.zeroOrPositive(bitIndex, "bit index");
        this.bitIndex = bitIndex % 8;
    }

    public BitIdentifierImpl(String name, int byteIndex, byte bitMask) throws IllegalArgumentException {
        this(name, byteIndex, bitMask, bitMask);
    }

    public BitIdentifierImpl(String name, int byteIndex, byte byteMask, byte bitMask) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(name, "name");
        AssertUtil.zeroOrPositive(byteIndex, "index of significant byte");
        if ((byteMask & bitMask) != bitMask) {
            throw new IllegalArgumentException("illegal pair of byte mask and bit mask");
        }
        this.name = name;
        this.byteIndex = byteIndex;
        this.byteMask = byteMask;
        this.bitMask = bitMask;
    }

    @Override
    public int getByteIndex() {
        return this.byteIndex;
    }

    @Override
    public byte getBitMask() {
        return this.bitMask;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public byte getByteMask() {
        return this.byteMask;
    }

    @Override
    public boolean accept(ASN1 asn1) {
        if (asn1 == null) {
            return false;
        }
        return this.accept(asn1.getValue());
    }

    @Override
    public boolean accept(byte[] asn1ValueBytes) {
        if (asn1ValueBytes == null || asn1ValueBytes.length == 0 || asn1ValueBytes.length <= this.byteIndex) {
            return false;
        }
        return (asn1ValueBytes[this.byteIndex] & this.byteMask) == this.bitMask;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Integer getBitIndex() {
        return this.bitIndex;
    }
}

