/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1.cvc;

import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.asn1.cvc.AccessRoleAndRights;
import de.bos_bremen.common.asn1.cvc.BaseAccessRoleAndRights;
import de.bos_bremen.common.asn1.cvc.BitIdentifier;
import de.bos_bremen.common.asn1.cvc.BitIdentifierImpl;
import de.bos_bremen.common.asn1.cvc.EIDConstants;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AuthenticationTerminals
extends BaseAccessRoleAndRights
implements EIDConstants {
    public static final String OID_SUFFIX_AUTHENTICATION_TERMINAL = ".2";
    public static final String OID_ACCESS_ROLE_AND_RIGHTS_AUTHENTICATION_TERMINAL = "0.4.0.127.0.7.3.1.2.2";
    public static final OID OID_AUTHENTICATION_TERMINALS = new OID("0.4.0.127.0.7.3.1.2.2");
    public static final int VALUE_BYTE_COUNT = 5;
    public static final byte ACCESS_ROLE_MASK_AUTHENTICATION_TERMINAL = 0;
    public static final String ACCESS_ROLE_NAME_AUTHENTICATION_TERMINAL = "Authentication Terminal";
    public static final int ACCESS_RIGHT_INDEX_WRITE_DG17 = 0;
    public static final byte ACCESS_RIGHT_MASK_WRITE_DG17 = 32;
    public static final String ACCESS_RIGHT_NAME_WRITE_DG17 = "Write DG17 (eID): Place Of Residence";
    public static final int ACCESS_RIGHT_INDEX_WRITE_DG18 = 0;
    public static final byte ACCESS_RIGHT_MASK_WRITE_DG18 = 16;
    public static final String ACCESS_RIGHT_NAME_WRITE_DG18 = "Write DG18 (eID): Community ID";
    public static final int ACCESS_RIGHT_INDEX_WRITE_DG19 = 0;
    public static final byte ACCESS_RIGHT_MASK_WRITE_DG19 = 8;
    public static final String ACCESS_RIGHT_NAME_WRITE_DG19 = "Write DG19 (eID): Residence Permit I";
    public static final int ACCESS_RIGHT_INDEX_WRITE_DG20 = 0;
    public static final byte ACCESS_RIGHT_MASK_WRITE_DG20 = 4;
    public static final String ACCESS_RIGHT_NAME_WRITE_DG20 = "Write DG20 (eID): Residence Permit II";
    public static final int ACCESS_RIGHT_INDEX_WRITE_DG21 = 0;
    public static final byte ACCESS_RIGHT_MASK_WRITE_DG21 = 2;
    public static final String ACCESS_RIGHT_NAME_WRITE_DG21 = "Write DG21 (eID): Optional Data RW";
    public static final int ACCESS_RIGHT_INDEX_READ_DG21 = 1;
    public static final byte ACCESS_RIGHT_MASK_READ_DG21 = 16;
    public static final String ACCESS_RIGHT_NAME_READ_DG21 = "Read DG21 (eID): Optional Data RW";
    public static final int ACCESS_RIGHT_INDEX_READ_DG20 = 1;
    public static final byte ACCESS_RIGHT_MASK_READ_DG20 = 8;
    public static final String ACCESS_RIGHT_NAME_READ_DG20 = "Read DG20 (eID): Residence Permit II";
    public static final int ACCESS_RIGHT_INDEX_READ_DG19 = 1;
    public static final byte ACCESS_RIGHT_MASK_READ_DG19 = 4;
    public static final String ACCESS_RIGHT_NAME_READ_DG19 = "Read DG19 (eID): Residence Permit I";
    public static final int ACCESS_RIGHT_INDEX_READ_DG18 = 1;
    public static final byte ACCESS_RIGHT_MASK_READ_DG18 = 2;
    public static final String ACCESS_RIGHT_NAME_READ_DG18 = "Read DG18 (eID): Community ID";
    public static final int ACCESS_RIGHT_INDEX_READ_DG17 = 1;
    public static final byte ACCESS_RIGHT_MASK_READ_DG17 = 1;
    public static final String ACCESS_RIGHT_NAME_READ_DG17 = "Read DG17 (eID): Place Of Residence";
    public static final int ACCESS_RIGHT_INDEX_READ_DG16 = 2;
    public static final byte ACCESS_RIGHT_MASK_READ_DG16 = -128;
    public static final String ACCESS_RIGHT_NAME_READ_DG16 = "Read DG16 (eID): RFU 4";
    public static final int ACCESS_RIGHT_INDEX_READ_DG15 = 2;
    public static final byte ACCESS_RIGHT_MASK_READ_DG15 = 64;
    public static final String ACCESS_RIGHT_NAME_READ_DG15 = "Read DG15 (eID): RFU 3";
    public static final int ACCESS_RIGHT_INDEX_READ_DG14 = 2;
    public static final byte ACCESS_RIGHT_MASK_READ_DG14 = 32;
    public static final String ACCESS_RIGHT_NAME_READ_DG14 = "Read DG14 (eID): RFU 2";
    public static final int ACCESS_RIGHT_INDEX_READ_DG13 = 2;
    public static final byte ACCESS_RIGHT_MASK_READ_DG13 = 16;
    public static final String ACCESS_RIGHT_NAME_READ_DG13 = "Read DG13 (eID): RFU 1";
    public static final int ACCESS_RIGHT_INDEX_READ_DG12 = 2;
    public static final byte ACCESS_RIGHT_MASK_READ_DG12 = 8;
    public static final String ACCESS_RIGHT_NAME_READ_DG12 = "Read DG12 (eID): Optional Data R";
    public static final int ACCESS_RIGHT_INDEX_READ_DG11 = 2;
    public static final byte ACCESS_RIGHT_MASK_READ_DG11 = 4;
    public static final String ACCESS_RIGHT_NAME_READ_DG11 = "Read DG11 (eID): Sexuality";
    public static final int ACCESS_RIGHT_INDEX_READ_DG10 = 2;
    public static final byte ACCESS_RIGHT_MASK_READ_DG10 = 2;
    public static final String ACCESS_RIGHT_NAME_READ_DG10 = "Read DG10 (eID): Nationality";
    public static final int ACCESS_RIGHT_INDEX_READ_DG9 = 2;
    public static final byte ACCESS_RIGHT_MASK_READ_DG9 = 1;
    public static final String ACCESS_RIGHT_NAME_READ_DG9 = "Read DG9 (eID): Place Of Birth";
    public static final int ACCESS_RIGHT_INDEX_READ_DG8 = 3;
    public static final byte ACCESS_RIGHT_MASK_READ_DG8 = -128;
    public static final String ACCESS_RIGHT_NAME_READ_DG8 = "Read DG8 (eID): Date Of Birth";
    public static final int ACCESS_RIGHT_INDEX_READ_DG7 = 3;
    public static final byte ACCESS_RIGHT_MASK_READ_DG7 = 64;
    public static final String ACCESS_RIGHT_NAME_READ_DG7 = "Read DG7 (eID): Academic Title";
    public static final int ACCESS_RIGHT_INDEX_READ_DG6 = 3;
    public static final byte ACCESS_RIGHT_MASK_READ_DG6 = 32;
    public static final String ACCESS_RIGHT_NAME_READ_DG6 = "Read DG6 (eID): Artistic Name";
    public static final int ACCESS_RIGHT_INDEX_READ_DG5 = 3;
    public static final byte ACCESS_RIGHT_MASK_READ_DG5 = 16;
    public static final String ACCESS_RIGHT_NAME_READ_DG5 = "Read DG5 (eID): Family Names";
    public static final int ACCESS_RIGHT_INDEX_READ_DG4 = 3;
    public static final byte ACCESS_RIGHT_MASK_READ_DG4 = 8;
    public static final String ACCESS_RIGHT_NAME_READ_DG4 = "Read DG4 (eID): Given Names";
    public static final int ACCESS_RIGHT_INDEX_READ_DG3 = 3;
    public static final byte ACCESS_RIGHT_MASK_READ_DG3 = 4;
    public static final String ACCESS_RIGHT_NAME_READ_DG3 = "Read DG3 (eID): Date Expiry";
    public static final int ACCESS_RIGHT_INDEX_READ_DG2 = 3;
    public static final byte ACCESS_RIGHT_MASK_READ_DG2 = 2;
    public static final String ACCESS_RIGHT_NAME_READ_DG2 = "Read DG2 (eID): Issuing State";
    public static final int ACCESS_RIGHT_INDEX_READ_DG1 = 3;
    public static final byte ACCESS_RIGHT_MASK_READ_DG1 = 1;
    public static final String ACCESS_RIGHT_NAME_READ_DG1 = "Read DG1 (eID): 0101";
    public static final int ACCESS_RIGHT_INDEX_INSTALL_QUALIFIED_CERTIFICATE = 4;
    public static final byte ACCESS_RIGHT_MASK_INSTALL_QUALIFIED_CERTIFICATE = -128;
    public static final String ACCESS_RIGHT_NAME_INSTALL_QUALIFIED_CERTIFICATE = "Install Qualified Certificate";
    public static final int ACCESS_RIGHT_INDEX_INSTALL_CERTIFICATE = 4;
    public static final byte ACCESS_RIGHT_MASK_INSTALL_CERTIFICATE = 64;
    public static final String ACCESS_RIGHT_NAME_INSTALL_CERTIFICATE = "Install Certificate";
    public static final int ACCESS_RIGHT_INDEX_PIN_MANAGEMENT = 4;
    public static final byte ACCESS_RIGHT_MASK_PIN_MANAGEMENT = 32;
    public static final String ACCESS_RIGHT_NAME_PIN_MANAGEMENT = "PIN Management";
    public static final int ACCESS_RIGHT_INDEX_CAN_ALLOWED = 4;
    public static final byte ACCESS_RIGHT_MASK_CAN_ALLOWED = 16;
    public static final String ACCESS_RIGHT_NAME_CAN_ALLOWED = "CAN allowed";
    public static final int ACCESS_RIGHT_INDEX_RESTRICTED_IDENTIFICATION = 4;
    public static final byte ACCESS_RIGHT_MASK_RESTRICTED_IDENTIFICATION = 4;
    public static final String ACCESS_RIGHT_NAME_RESTRICTED_IDENTIFICATION = "Restricted Identification";
    public static final int ACCESS_RIGHT_INDEX_COMMUNITY_ID_VERIFICATION = 4;
    public static final byte ACCESS_RIGHT_MASK_COMMUNITY_ID_VERIFICATION = 2;
    public static final String ACCESS_RIGHT_NAME_COMMUNITY_ID_VERIFICATION = "Community ID Identification";
    public static final int ACCESS_RIGHT_INDEX_AGE_VERIFICATION = 4;
    public static final byte ACCESS_RIGHT_MASK_AGE_VERIFICATION = 1;
    public static final String ACCESS_RIGHT_NAME_AGE_VERIFICATION = "Age Verification";
    public static final List<BitIdentifier> ACCESS_ROLES_LIST = Collections.unmodifiableList(Arrays.asList((BitIdentifier[])AccessRoleEnum.values()));
    public static final List<BitIdentifier> ACCESS_RIGHTS_LIST = Collections.unmodifiableList(Arrays.asList((BitIdentifier[])AccessRightEnum.values()));

    public static String getOIDString() {
        return OID_ACCESS_ROLE_AND_RIGHTS_AUTHENTICATION_TERMINAL;
    }

    public AuthenticationTerminals(byte[] bytes) throws IOException {
        super(bytes, 5, ACCESS_ROLES_LIST, ACCESS_RIGHTS_LIST);
    }

    public boolean isCVCA() {
        return super.isRole(AccessRoleEnum.CVCA);
    }

    public boolean isDVOfficialDomestic() {
        return super.isRole(AccessRoleEnum.DV_OFFICIAL_DOMESTIC);
    }

    public boolean isDVOfficialForeign() {
        return super.isRole(AccessRoleEnum.DV_OFFICIAL_FOREIGN);
    }

    public boolean isAuthenticationTerminal() {
        return this.isCVCA() || super.isRole(AccessRoleEnum.AUTHENTICATION_TERMINAL);
    }

    @Override
    public OID getOID() {
        return OID_AUTHENTICATION_TERMINALS;
    }

    public static enum AccessRightEnum implements BitIdentifier
    {
        WRITE_DG17(new BitIdentifierImpl("Write DG17 (eID): Place Of Residence", 0, 32)),
        WRITE_DG18(new BitIdentifierImpl("Write DG18 (eID): Community ID", 0, 16)),
        WRITE_DG19(new BitIdentifierImpl("Write DG19 (eID): Residence Permit I", 0, 8)),
        WRITE_DG20(new BitIdentifierImpl("Write DG20 (eID): Residence Permit II", 0, 4)),
        WRITE_DG21(new BitIdentifierImpl("Write DG21 (eID): Optional Data RW", 0, 2)),
        READ_DG21(new BitIdentifierImpl("Read DG21 (eID): Optional Data RW", 1, 16)),
        READ_DG20(new BitIdentifierImpl("Read DG20 (eID): Residence Permit II", 1, 8)),
        READ_DG19(new BitIdentifierImpl("Read DG19 (eID): Residence Permit I", 1, 4)),
        READ_DG18(new BitIdentifierImpl("Read DG18 (eID): Community ID", 1, 2)),
        READ_DG17(new BitIdentifierImpl("Read DG17 (eID): Place Of Residence", 1, 1)),
        READ_DG16(new BitIdentifierImpl("Read DG16 (eID): RFU 4", 2, -128)),
        READ_DG15(new BitIdentifierImpl("Read DG15 (eID): RFU 3", 2, 64)),
        READ_DG14(new BitIdentifierImpl("Read DG14 (eID): RFU 2", 2, 32)),
        READ_DG13(new BitIdentifierImpl("Read DG13 (eID): RFU 1", 2, 16)),
        READ_DG12(new BitIdentifierImpl("Read DG12 (eID): Optional Data R", 2, 8)),
        READ_DG11(new BitIdentifierImpl("Read DG11 (eID): Sexuality", 2, 4)),
        READ_DG10(new BitIdentifierImpl("Read DG10 (eID): Nationality", 2, 2)),
        READ_DG9(new BitIdentifierImpl("Read DG9 (eID): Place Of Birth", 2, 1)),
        READ_DG8(new BitIdentifierImpl("Read DG8 (eID): Date Of Birth", 3, -128)),
        READ_DG7(new BitIdentifierImpl("Read DG7 (eID): Academic Title", 3, 64)),
        READ_DG6(new BitIdentifierImpl("Read DG6 (eID): Artistic Name", 3, 32)),
        READ_DG5(new BitIdentifierImpl("Read DG5 (eID): Family Names", 3, 16)),
        READ_DG4(new BitIdentifierImpl("Read DG4 (eID): Given Names", 3, 8)),
        READ_DG3(new BitIdentifierImpl("Read DG3 (eID): Date Expiry", 3, 4)),
        READ_DG2(new BitIdentifierImpl("Read DG2 (eID): Issuing State", 3, 2)),
        READ_DG1(new BitIdentifierImpl("Read DG1 (eID): 0101", 3, 1)),
        INSTALL_QUALIFIED_CERTIFICATE(new BitIdentifierImpl("Install Qualified Certificate", 4, -128)),
        INSTALL_CERTIFICATE(new BitIdentifierImpl("Install Certificate", 4, 64)),
        PIN_MANAGEMENT(new BitIdentifierImpl("PIN Management", 4, 32)),
        CAN_ALLOWED(new BitIdentifierImpl("CAN allowed", 4, 16)),
        RESTRICTED_IDENTIFICATION(new BitIdentifierImpl("Restricted Identification", 4, 4)),
        COMMUNITY_ID_VERIFICATION(new BitIdentifierImpl("Community ID Identification", 4, 2)),
        AGE_VERIFICATION(new BitIdentifierImpl("Age Verification", 4, 1));

        private BitIdentifier bitIdentifier = null;

        private AccessRightEnum(BitIdentifier bitIdentifier) throws IllegalArgumentException {
            if (bitIdentifier == null) {
                throw new IllegalArgumentException("BitIdentifier expected");
            }
            this.bitIdentifier = bitIdentifier;
        }

        @Override
        public boolean accept(ASN1 asn1) {
            return this.bitIdentifier.accept(asn1);
        }

        @Override
        public boolean accept(byte[] asn1ValueBytes) {
            return this.bitIdentifier.accept(asn1ValueBytes);
        }

        @Override
        public byte getBitMask() {
            return this.bitIdentifier.getBitMask();
        }

        @Override
        public int getByteIndex() {
            return this.bitIdentifier.getByteIndex();
        }

        @Override
        public String getName() {
            return this.bitIdentifier.getName();
        }

        @Override
        public byte getByteMask() {
            return this.bitIdentifier.getByteMask();
        }

        @Override
        public Integer getBitIndex() {
            return this.bitIdentifier.getBitIndex();
        }

        public String toString() {
            return this.getName();
        }
    }

    public static enum AccessRoleEnum implements BitIdentifier
    {
        CVCA(AccessRoleAndRights.IDENTIFIER_CVCA),
        DV_OFFICIAL_DOMESTIC(BaseAccessRoleAndRights.IDENTIFIER_DV_OFFICIAL_DOMESTIC),
        DV_OFFICIAL_FOREIGN(BaseAccessRoleAndRights.IDENTIFIER_DV_OFFICIAL_FOREIGN),
        AUTHENTICATION_TERMINAL(new BitIdentifierImpl("Authentication Terminal", 0, -64, 0));

        private BitIdentifier bitIdentifier = null;

        private AccessRoleEnum(BitIdentifier bitIdentifier) throws IllegalArgumentException {
            if (bitIdentifier == null) {
                throw new IllegalArgumentException("BitIdentifier expected");
            }
            this.bitIdentifier = bitIdentifier;
        }

        @Override
        public boolean accept(ASN1 asn1) {
            return this.bitIdentifier.accept(asn1);
        }

        @Override
        public Integer getBitIndex() {
            return this.bitIdentifier.getBitIndex();
        }

        @Override
        public boolean accept(byte[] asn1ValueBytes) {
            return this.bitIdentifier.accept(asn1ValueBytes);
        }

        @Override
        public byte getBitMask() {
            return this.bitIdentifier.getBitMask();
        }

        @Override
        public int getByteIndex() {
            return this.bitIdentifier.getByteIndex();
        }

        @Override
        public String getName() {
            return this.bitIdentifier.getName();
        }

        @Override
        public byte getByteMask() {
            return this.bitIdentifier.getByteMask();
        }

        public String toString() {
            return this.getName();
        }
    }
}

