/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1.cvc;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OIDRelated;
import de.bos_bremen.common.asn1.cvc.BitIdentifier;
import de.bos_bremen.common.asn1.cvc.BitIdentifierImpl;
import de.bos_bremen.common.asn1.cvc.ECCVCPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AccessRoleAndRights
extends ASN1
implements OIDRelated {
    public static final String OID_ACCESS_ROLE_AND_RIGHTS = "0.4.0.127.0.7.3.1.2";
    public static final int ACCESS_ROLE_BYTE_INDEX = 0;
    public static final byte ACCESS_ROLE_MASK = -64;
    public static final byte ACCESS_ROLE_CVCA_MASK = -64;
    public static final String ACCESS_ROLE_NAME_CVCA = "CVCA";
    public static final byte ACCESS_ROLE_MASK_80 = -128;
    public static final byte ACCESS_ROLE_MASK_40 = 64;
    public static final byte ACCESS_ROLE_MASK_00 = 0;
    public static final byte ACCESS_RIGHTS_MASK_FIRST_BYTE = 63;
    public static final byte DEFAULT_BIT_MASK = -1;
    public static final BitIdentifier IDENTIFIER_CVCA = new BitIdentifierImpl("CVCA", 0, -64, -64);
    private List<BitIdentifier> definedAccessRolesIdentifierList = null;
    private List<BitIdentifier> definedAccessRightsIdentifierList = null;
    private List<BitIdentifier> accessRolesIdentifierList = null;
    private List<BitIdentifier> accessRightsIdentifierList = null;

    public static String getOIDString() {
        return OID_ACCESS_ROLE_AND_RIGHTS;
    }

    public AccessRoleAndRights(byte[] bytes, int valueByteCount, List<BitIdentifier> definedAccessRolesIdentifierList, List<BitIdentifier> definedAccessRightsIdentifierList) throws IOException {
        super(bytes);
        AssertUtil.equals(ECCVCPath.HAT_ACCESS_ROLE_AND_RIGHTS.getTag(), super.getTag(), "tag");
        if (super.getValue() == null || super.getValue().length != valueByteCount) {
            throw new IllegalArgumentException("wrong count of value bytes: " + valueByteCount);
        }
        if (definedAccessRolesIdentifierList == null || definedAccessRolesIdentifierList.isEmpty()) {
            throw new IllegalArgumentException("list of access roles not permitted as null or empty list");
        }
        if (definedAccessRightsIdentifierList == null || definedAccessRightsIdentifierList.isEmpty()) {
            throw new IllegalArgumentException("list of access rights not permitted as null or empty list");
        }
        this.definedAccessRolesIdentifierList = Collections.unmodifiableList(new ArrayList<BitIdentifier>(definedAccessRolesIdentifierList));
        this.definedAccessRightsIdentifierList = Collections.unmodifiableList(new ArrayList<BitIdentifier>(definedAccessRightsIdentifierList));
        this.update();
    }

    @Override
    protected void update() {
        byte[] value = super.getValue();
        this.accessRolesIdentifierList = new ArrayList<BitIdentifier>();
        for (BitIdentifier tmp : this.definedAccessRolesIdentifierList) {
            if (!tmp.accept(value)) continue;
            this.accessRolesIdentifierList.add(tmp);
        }
        this.accessRolesIdentifierList = Collections.unmodifiableList(this.accessRolesIdentifierList);
        this.accessRightsIdentifierList = new ArrayList<BitIdentifier>();
        for (BitIdentifier tmp : this.definedAccessRightsIdentifierList) {
            if (!tmp.accept(value)) continue;
            this.accessRightsIdentifierList.add(tmp);
        }
        this.accessRightsIdentifierList = Collections.unmodifiableList(this.accessRightsIdentifierList);
    }

    @Override
    public String toString() {
        return super.toString() + "(Roles: " + this.accessRolesIdentifierList + ", Rights: " + this.accessRightsIdentifierList + ")";
    }

    public List<BitIdentifier> getDefinedAccessRightsList() {
        return this.definedAccessRightsIdentifierList;
    }

    public List<BitIdentifier> getDefinedAccessRolesList() {
        return this.definedAccessRolesIdentifierList;
    }

    public List<BitIdentifier> getAccessRightsList() {
        return this.accessRightsIdentifierList;
    }

    public List<BitIdentifier> getAccessRolesList() {
        return this.accessRolesIdentifierList;
    }

    public boolean existsRight(BitIdentifier accessRight) {
        return this.accessRightsIdentifierList.contains(accessRight);
    }

    public boolean isRole(BitIdentifier accessRole) {
        return this.accessRolesIdentifierList.contains(accessRole);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.accessRightsIdentifierList == null ? 0 : this.accessRightsIdentifierList.hashCode());
        result = 31 * result + (this.accessRolesIdentifierList == null ? 0 : this.accessRolesIdentifierList.hashCode());
        result = 31 * result + (this.definedAccessRightsIdentifierList == null ? 0 : this.definedAccessRightsIdentifierList.hashCode());
        result = 31 * result + (this.definedAccessRolesIdentifierList == null ? 0 : this.definedAccessRolesIdentifierList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessRoleAndRights other = (AccessRoleAndRights)obj;
        if (this.accessRightsIdentifierList == null ? other.accessRightsIdentifierList != null : !this.accessRightsIdentifierList.equals(other.accessRightsIdentifierList)) {
            return false;
        }
        if (this.accessRolesIdentifierList == null ? other.accessRolesIdentifierList != null : !this.accessRolesIdentifierList.equals(other.accessRolesIdentifierList)) {
            return false;
        }
        if (this.definedAccessRightsIdentifierList == null ? other.definedAccessRightsIdentifierList != null : !this.definedAccessRightsIdentifierList.equals(other.definedAccessRightsIdentifierList)) {
            return false;
        }
        return !(this.definedAccessRolesIdentifierList == null ? other.definedAccessRolesIdentifierList != null : !this.definedAccessRolesIdentifierList.equals(other.definedAccessRolesIdentifierList));
    }
}

