/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.ASN1Encoder;
import de.bos_bremen.common.asn1.AbstractASN1Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.regex.Pattern;

public class OID
extends AbstractASN1Encoder
implements ASN1Encoder {
    public static final int FIRST_ID_FACTOR = 40;
    public static final byte OTHER_ID_BIT_MASK = 127;
    public static final byte OTHER_ID_BYTE_SEQUENCE = -128;
    public static final byte OTHER_ID_LEFT_SHIFT = 7;
    private String oidString = null;
    public static final String OID_SEPARATOR = ".";

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.oidString == null ? 0 : this.oidString.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OID)) {
            return false;
        }
        OID other = (OID)obj;
        return !(this.oidString == null ? other.oidString != null : !this.oidString.equals(other.oidString));
    }

    public OID() throws IOException {
        super(new byte[]{6, 0});
    }

    public OID(String oidString) {
        super((byte)6, OID.toBytes(oidString));
        this.oidString = oidString;
    }

    public OID(byte[] bytes) throws IOException {
        super(AssertUtil.notNullOrEmpty(bytes, "bytes"));
        if (super.getTag().toByteArray().length != 1 || super.getTag().toByteArray()[0] != 6) {
            throw new IllegalArgumentException("illegal bytes, tag not OID tag byte 0x06");
        }
        this.oidString = OID.toString(super.getValue());
    }

    public String getOIDString() {
        return this.oidString;
    }

    @Override
    public String toString() {
        return "OID: " + this.oidString;
    }

    public static byte[] toBytes(String oidString) {
        if (oidString == null || oidString.length() == 0) {
            throw new IllegalArgumentException("String of OID not permitted as null");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String[] digitStrings = oidString.split(Pattern.quote(OID_SEPARATOR));
        int[] digits = OID.convertDigits(digitStrings);
        for (int i = 1; i < digits.length; ++i) {
            if (i == 1) {
                baos.write((byte)(digits[0] * 40 + digits[i]));
                continue;
            }
            BigInteger bi = BigInteger.valueOf(digits[i]);
            StringBuilder bitString = new StringBuilder(bi.toString(2));
            while (bitString.length() % 7 != 0) {
                bitString.insert(0, "0");
            }
            OID.writeBitString(baos, bitString);
        }
        return baos.toByteArray();
    }

    private static void writeBitString(ByteArrayOutputStream baos, StringBuilder bitString) {
        for (int j = 0; j < bitString.length(); j += 7) {
            String tmp = bitString.substring(j, j + 7);
            byte b = Byte.parseByte(tmp, 2);
            if (j < bitString.length() - 8) {
                b = (byte)(b | 0xFFFFFF80);
            }
            baos.write(b);
        }
    }

    private static int[] convertDigits(String[] digitStrings) {
        int[] digits = new int[digitStrings.length];
        for (int i = 0; i < digitStrings.length; ++i) {
            try {
                digits[i] = Integer.parseInt(digitStrings[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("illegal characters at OID String");
            }
        }
        return digits;
    }

    public static String toString(byte[] oidValueBytes) {
        if (oidValueBytes == null || oidValueBytes.length == 0) {
            throw new IllegalArgumentException("value bytes of OID not permitted as null");
        }
        StringBuilder result = new StringBuilder(oidValueBytes[0] / 40 + OID_SEPARATOR);
        result.append(oidValueBytes[0] % 40 + OID_SEPARATOR);
        int tmp = 0;
        for (int i = 1; i < oidValueBytes.length; ++i) {
            tmp |= oidValueBytes[i] & 0x7F;
            if ((oidValueBytes[i] & 0xFFFFFF80) == -128) {
                tmp <<= 7;
                continue;
            }
            result.append(tmp);
            if (i < oidValueBytes.length - 1) {
                result.append(OID_SEPARATOR);
            }
            tmp = 0;
        }
        return result.toString();
    }

    @Override
    public ASN1 decode(ASN1 asn1) {
        if (asn1 == null) {
            return null;
        }
        super.copy(asn1);
        this.oidString = OID.toString(super.getValue());
        return this;
    }
}

