/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.asn1.HashInfo;
import de.bos_bremen.common.asn1.OID;
import java.util.Arrays;

public class HashAlgorithm
extends OID
implements HashInfo {
    private String name = null;
    private int hashLength = -1;
    public static final HashAlgorithm MD5_ALGORITHM = new HashAlgorithm("MD5", 16, "1.2.840.113549.2.5");
    public static final HashAlgorithm SHA1_ALGORITHM = new HashAlgorithm("SHA1", 20, "1.3.14.3.2.26");
    public static final HashAlgorithm SHA224_ALGORITHM = new HashAlgorithm("SHA224", 28, "2.16.840.1.101.3.4.2.4");
    public static final HashAlgorithm SHA256_ALGORITHM = new HashAlgorithm("SHA256", 32, "2.16.840.1.101.3.4.2.1");
    public static final HashAlgorithm SHA512_ALGORITHM = new HashAlgorithm("SHA512", 64, "2.16.840.1.101.3.4.2.3");
    public static final HashAlgorithm SHA384_ALGORITHM = new HashAlgorithm("SHA384", 48, "2.16.840.1.101.3.4.2.2");
    public static final HashAlgorithm RIPEMD160_ALGORITHM = new HashAlgorithm("RIPEMD160", 20, "1.3.36.3.2.1");
    public static final HashAlgorithm WHIRLPOOL_ALGORITHM = new HashAlgorithm("WHIRLPOOL", 64, "1.0.10118.3.0.55");

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.hashLength;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashAlgorithm other = (HashAlgorithm)obj;
        if (this.hashLength != other.hashLength) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public HashAlgorithm(String name, int hashLength, String oidString) {
        super(oidString);
        AssertUtil.notNullOrEmpty(name, "name of algorithm");
        AssertUtil.positive(hashLength, "length of  hash");
        this.name = name;
        this.hashLength = hashLength;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getHashLength() {
        return this.hashLength;
    }

    @Override
    public byte[] getEncoded() {
        return ByteUtil.copy(super.getEncoded());
    }

    @Override
    public byte[] getOIDValue() {
        return ByteUtil.copy(super.getValue());
    }

    @Override
    public OID getOID() {
        return this;
    }

    public static enum Algorithm implements HashInfo
    {
        MD5(MD5_ALGORITHM),
        SHA1(SHA1_ALGORITHM),
        SHA256(SHA256_ALGORITHM),
        SHA512(SHA512_ALGORITHM),
        SHA224(SHA224_ALGORITHM),
        SHA384(SHA384_ALGORITHM),
        RIPEMD160(RIPEMD160_ALGORITHM),
        WHIRLPOOL(WHIRLPOOL_ALGORITHM);

        private HashAlgorithm hashAlgorithm = null;

        private Algorithm(HashAlgorithm hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
        }

        public HashAlgorithm getHashAlgoritm() {
            return this.hashAlgorithm;
        }

        @Override
        public String getName() {
            return this.hashAlgorithm.getName();
        }

        @Override
        public String getOIDString() {
            return this.hashAlgorithm.getOIDString();
        }

        @Override
        public OID getOID() {
            return this.hashAlgorithm;
        }

        @Override
        public int getHashLength() {
            return this.hashAlgorithm.getHashLength();
        }

        @Override
        public byte[] getOIDValue() {
            return this.hashAlgorithm.getOIDValue();
        }

        @Override
        public byte[] getEncoded() {
            return this.hashAlgorithm.getEncoded();
        }

        public static Algorithm getAlgorithmByName(String name) {
            Algorithm[] algorithms = Algorithm.values();
            Algorithm result = null;
            for (Algorithm algorithm : algorithms) {
                if (!algorithm.getName().equals(name)) continue;
                result = algorithm;
                break;
            }
            return result;
        }

        public static Algorithm getAlgorithmByOID(String oid) {
            Algorithm[] algorithms = Algorithm.values();
            Algorithm result = null;
            for (Algorithm algorithm : algorithms) {
                if (!algorithm.getOIDString().equals(oid)) continue;
                result = algorithm;
                break;
            }
            return result;
        }

        public static Algorithm getAlgorithmByOID(byte[] oid) {
            Algorithm[] algorithms = Algorithm.values();
            Algorithm result = null;
            for (Algorithm algorithm : algorithms) {
                if (!Arrays.equals(algorithm.getEncoded(), oid) && !Arrays.equals(algorithm.getOIDValue(), oid)) continue;
                result = algorithm;
                break;
            }
            return result;
        }
    }
}

