/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1;

import de.bos_bremen.common.Filter;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OID;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FindElementByOIDChildFilter
implements Filter<ASN1> {
    private static final Log LOG = LogFactory.getLog(FindElementByOIDChildFilter.class);
    private String oidString = null;

    public FindElementByOIDChildFilter(String oidString) {
        this.oidString = oidString;
    }

    @Override
    public boolean accept(ASN1 asn1) {
        boolean result;
        block4: {
            result = false;
            if (asn1 == null) {
                return result;
            }
            try {
                ASN1[] children = asn1.getChildElements();
                if (children == null) break block4;
                for (ASN1 child : children) {
                    OID oid;
                    if (child.getDTag().intValue() != 6 || !(oid = new OID(child.getEncoded())).getOIDString().equals(this.oidString)) continue;
                    result = true;
                    break;
                }
            }
            catch (IOException e) {
                LOG.debug((Object)e);
            }
        }
        return result;
    }

    @Override
    public Class<ASN1> getFilterClass() {
        return ASN1.class;
    }
}

