/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.HashAlgorithm;
import de.bos_bremen.common.constants.Constants;
import java.io.IOException;
import java.util.List;

public class DigestInfo
extends ASN1 {
    public static final ASN1 PARAMETERS_NULL = new ASN1(5, Constants.EMPTY_PRIMITIVE_BYTE_ARRAY);
    private ASN1 algorithmSequence = null;
    private HashAlgorithm.Algorithm algorithm = null;
    private ASN1 parameters = null;
    private ASN1 hash = null;

    public DigestInfo(byte[] digestInfo) throws IOException {
        super(digestInfo);
        AssertUtil.equals(48L, this.getTag().longValue(), "tag of DigestInfo (DigestInfo, SEQUENCE)");
        AssertUtil.positive(this.getLength().longValue(), "length of DigestInfo");
        AssertUtil.equals(2, this.getChildElementCount(), "children count of DigestInfo");
        List<ASN1> listDigestInfoChildren = this.getChildElementList();
        ASN1 childDigestAlgorithmIdentifier = listDigestInfoChildren.get(0);
        AssertUtil.equals(48L, childDigestAlgorithmIdentifier.getTag().longValue(), "tag of DigestInfo first child (DigestAlgorithmIdentifier, SEQUENCE)");
        AssertUtil.positive(childDigestAlgorithmIdentifier.getLength().longValue(), "length of DigestInfo DigestAlgorithmIdentifier");
        AssertUtil.equals(2, childDigestAlgorithmIdentifier.getChildElementCount(), "children count of DigestInfo DigestAlgorithmIdentifier");
        List<ASN1> listDigestAlgorithmIdentifierChildren = childDigestAlgorithmIdentifier.getChildElementList();
        ASN1 childDigestAlgorithmIdentifierOID = listDigestAlgorithmIdentifierChildren.get(0);
        AssertUtil.equals(6L, childDigestAlgorithmIdentifierOID.getTag().longValue(), "tag of DigestInfo DigestAlgorithmIdentifier first child (OBJECT IDENTIFIER, OID)");
        AssertUtil.positive(childDigestAlgorithmIdentifierOID.getLength().longValue(), "length of DigestAlgorithmIdentifier OID child");
        ASN1 childDigestAlgorithmIdentifierParameters = listDigestAlgorithmIdentifierChildren.get(1);
        AssertUtil.equals(5L, childDigestAlgorithmIdentifierParameters.getTag().longValue(), "tag of DigestInfo DigestAlgorithmIdentifier second child (parameters, NULL)");
        AssertUtil.zero(childDigestAlgorithmIdentifierParameters.getLength().longValue(), "length of DigestInfo DigestAlgorithmIdentifier parameters child");
        ASN1 childDigest = listDigestInfoChildren.get(1);
        AssertUtil.equals(4L, childDigest.getTag().longValue(), "tag of DigestInfo second child (Digest, OCTET STRING)");
        AssertUtil.positive(childDigest.getLength().longValue(), "length of DigestInfo Digest child");
    }

    public DigestInfo(HashAlgorithm.Algorithm algorithm, byte[] hashValue) {
        this(algorithm, PARAMETERS_NULL, hashValue);
    }

    public DigestInfo(HashAlgorithm.Algorithm algorithm, ASN1 parameters, byte[] hashValue) {
        super((byte)48, Constants.EMPTY_PRIMITIVE_BYTE_ARRAY);
        AssertUtil.notNull(algorithm, "algorithm");
        AssertUtil.notNull(hashValue, "hash value");
        AssertUtil.equals(algorithm.getHashLength(), hashValue.length, "hash length");
        this.algorithm = algorithm;
        this.parameters = parameters != null ? parameters : PARAMETERS_NULL;
        this.hash = new ASN1(4, hashValue);
        this.algorithmSequence = new ASN1(48, Constants.EMPTY_PRIMITIVE_BYTE_ARRAY);
        try {
            this.algorithmSequence.addChildElement(this.algorithm.getOID(), null);
            this.algorithmSequence.addChildElement(this.parameters, null);
            super.addChildElement(this.algorithmSequence, null);
            super.addChildElement(this.hash, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("parameters not correct, encoding failed");
        }
    }
}

