/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.ASN1Constants;
import de.bos_bremen.common.asn1.ASN1Path;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.constants.ByteConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ASN1Util {
    private static final String MSG_NULL_OR_EMPTY_ARRAY_NOT_PERMITTED = "null or empty array not permitted";
    private static final String MSG_UNSUITABLE_PARENT_ELEMENT = "unsuitable parent element";
    private static final String MSG_NULL_NOT_PERMITTED_AS_ARGUMENT = "null not permitted as argument";
    private static final String MSG_TAG_NOT_PERMITTED_AS_NULL = "tag not permitted as null";
    private static final String MSG_END_OF_STREAM_REACHED = "end of stream reached";
    private static final String MSG_NULL_NOT_PERMITTED = "null not permitted";
    private static final Log LOG = LogFactory.getLog(ASN1Util.class);
    public static final Map<Byte, String> MAP_BYTE_TO_TYPE;
    public static final Map<String, String> MAP_OID_TO_NAME;

    public static String getValueAsString(ASN1 asn1) {
        if (asn1 == null) {
            return null;
        }
        byte[] value = asn1.getValue();
        if (value == null || value.length == 0) {
            return null;
        }
        String s = null;
        try {
            switch (asn1.getDTag().intValue()) {
                case 1: {
                    s = asn1.getValue()[0] == 0 ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
                    break;
                }
                case 2: {
                    s = String.valueOf(new BigInteger(asn1.getValue()).intValue());
                    break;
                }
                case 3: {
                    byte notUsedBits = value[0];
                    value = ByteUtil.subbytes(value, 1);
                    Object result = new BigInteger(1, value).shiftRight(notUsedBits).toString(2);
                    int missingZeros = 8 - ((String)result).length() % 8;
                    if (missingZeros != 8) {
                        result = "00000000".substring(0, missingZeros) + (String)result;
                    }
                    s = result;
                    break;
                }
                case 4: {
                    s = HexUtil.hexify(asn1.getValue());
                    break;
                }
                case 6: {
                    Object oid = new OID(asn1.getEncoded()).getOIDString();
                    if (MAP_OID_TO_NAME.containsKey(oid)) {
                        oid = (String)oid + " (" + MAP_OID_TO_NAME.get(oid) + ")";
                    }
                    s = oid;
                    break;
                }
                case 12: {
                    s = new String(asn1.getValue(), "UTF-8");
                    break;
                }
                case 30: {
                    s = new String(asn1.getValue(), "UTF-16");
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 25: 
                case 26: 
                case 27: {
                    s = new String(asn1.getValue(), "UTF-8");
                    break;
                }
                case 23: {
                    s = new String(asn1.getValue(), "UTF-8");
                    if (!s.endsWith("Z")) break;
                    s = s.replaceAll("Z", "");
                    s = new SimpleDateFormat("yyMMddHHmmss").parse(s).toString();
                    break;
                }
            }
        }
        catch (Exception e) {
            return "value to String conversion failed: " + e.getMessage();
        }
        return s;
    }

    public static String getType(ASN1 asn1) {
        if (asn1 == null) {
            return null;
        }
        byte[] dTagBytes = asn1.getDTagBytes();
        if (dTagBytes == null || dTagBytes.length == 0) {
            return null;
        }
        if (dTagBytes.length > 1) {
            return "special";
        }
        byte dTagByte = dTagBytes[0];
        if ((0xFFFFFFA0 & dTagByte) == -96) {
            return "TaggedObject";
        }
        String result = MAP_BYTE_TO_TYPE.get(dTagByte);
        if (result == null || result.isEmpty()) {
            return "unknown";
        }
        return result;
    }

    public static byte[] checkTagBytes(byte[] dTagBytes) {
        AssertUtil.notNullOrEmpty(dTagBytes, "tag bytes");
        if (ByteUtil.areBitsSet(dTagBytes[0], (byte)31)) {
            AssertUtil.greaterEquals(dTagBytes.length, 2, "tag bytes count");
            for (int i = 1; i < dTagBytes.length; ++i) {
                if (i == dTagBytes.length - 1 && ByteUtil.areBitsSet(dTagBytes[i], ByteConstants.MASK_BIT8)) {
                    throw new IllegalArgumentException("tag bytes not valid, most significant bit not expected to be set at last byte, but found: " + HexUtil.hexify(dTagBytes[i]));
                }
                if (i != dTagBytes.length - 1 && !ByteUtil.areBitsSet(dTagBytes[i], ByteConstants.MASK_BIT8)) {
                    throw new IllegalArgumentException("tag bytes not valid, at all tag bytes from second up to next to last most significant bit expected to be set, but not found at byte index " + i + ": " + HexUtil.hexify(dTagBytes[i]));
                }
                if ((dTagBytes[i] & 0x7F) != 0) continue;
                throw new IllegalArgumentException("tag bytes not valid, at all tag bytes from first up to last at least one bit expected to be set, but not found at byte index " + i + ": " + HexUtil.hexify(dTagBytes[i]));
            }
        } else if (dTagBytes.length != 1) {
            throw new IllegalArgumentException("only one byte for tag permitted, because extended tag not indicated at first byte, tag bytes  not valid");
        }
        return dTagBytes;
    }

    private ASN1Util() {
    }

    public static void skipEOC(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED);
        }
        byte[] eoc = ASN1Constants.EOC_ASN1.getEncoded();
        int n = eoc.length;
        for (int i = 0; i < n; ++i) {
            byte b = (byte)(stream.read() & 0xFF);
            if (b == eoc[i]) continue;
            throw new IOException("EOC not found, error at index " + i + ": " + HexUtil.hexify(eoc[i]) + " <> " + HexUtil.hexify(b));
        }
    }

    public static void printASN1(ASN1 asn1) {
        System.out.println(ASN1Util.toString(null, asn1, 0));
    }

    public static String toString(StringBuilder builder, ASN1 asn1, int depth) {
        if (asn1 == null) {
            throw new IllegalArgumentException("asn1 not permitted as null");
        }
        if (depth < 0) {
            throw new IllegalArgumentException("depth expected greater equals than 0");
        }
        StringBuilder lBuilder = builder;
        if (lBuilder == null) {
            lBuilder = new StringBuilder();
        }
        ASN1Util.indent(lBuilder, depth);
        String indent1 = "";
        for (int i = 0; i < depth; ++i) {
            indent1 = indent1.concat("   ");
        }
        lBuilder.append(asn1.toString(indent1, "", ASN1Constants.FULL_FORMAT) + "\n");
        try {
            if (asn1.getChildElements().length > 0) {
                for (ASN1 sub : asn1.getChildElements()) {
                    ASN1Util.toString(lBuilder, sub, depth + 1);
                }
            }
        }
        catch (IOException e1) {
            LOG.debug((Object)"ignored ASN.1 coding error", (Throwable)e1);
        }
        return lBuilder.toString();
    }

    private static void indent(StringBuilder builder, int depth) {
        for (int i = 0; i < depth; ++i) {
            builder.append("   ");
        }
    }

    public static BigInteger extractTag(byte[] dTagBytes) {
        byte firstTagByte;
        BigInteger result = null;
        if (dTagBytes == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED);
        }
        if (dTagBytes.length < 1) {
            throw new IllegalArgumentException("tag descriptor bytes expected as array with at least 1 byte");
        }
        int offset = 0;
        if (dTagBytes[0] == 0 && dTagBytes.length > 1) {
            offset = 1;
        }
        if (((firstTagByte = dTagBytes[offset]) & 0x1F) == 31) {
            BigInteger tmp = BigInteger.valueOf(0L);
            BigInteger tagBits = null;
            for (int i = offset + 1; i < dTagBytes.length; ++i) {
                tmp = tmp.shiftLeft(7);
                tagBits = BigInteger.valueOf(0x7F & dTagBytes[i]);
                tmp = tmp.or(tagBits);
            }
            result = tmp;
        } else {
            if (dTagBytes.length - offset != 1) {
                throw new IllegalArgumentException("only 1 byte expected as tag descriptor bytes (leading null-byte ignored)");
            }
            result = BigInteger.valueOf(firstTagByte & 0x7F);
        }
        return result;
    }

    public static boolean isCompleteASN1(byte[] bytes) {
        try {
            return new ASN1(bytes).getEncoded().length == bytes.length;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static byte[] getLengthBytes(byte[] value) {
        if (value == null) {
            return new byte[]{0};
        }
        byte[] result = null;
        if (value.length < 127) {
            result = new byte[]{(byte)value.length};
        } else {
            byte[] tmpLengthBytes1 = BigInteger.valueOf(value.length).toByteArray();
            int offset = 0;
            if (tmpLengthBytes1[0] == 0) {
                offset = 1;
            }
            byte[] tmpLengthBytes2 = new byte[tmpLengthBytes1.length + 1 - offset];
            System.arraycopy(tmpLengthBytes1, offset, tmpLengthBytes2, 1, tmpLengthBytes1.length - offset);
            tmpLengthBytes2[0] = (byte)(tmpLengthBytes1.length | 0x80);
            tmpLengthBytes2[0] = (byte)(tmpLengthBytes2[0] - (tmpLengthBytes1[0] == 0 ? (byte)1 : 0));
            result = tmpLengthBytes2;
        }
        return result;
    }

    public static BigInteger getEncodedLength(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED);
        }
        try {
            return ASN1Util.getEncodedLength(new ByteArrayInputStream(bytes), true);
        }
        catch (IOException e) {
            LOG.debug((Object)"ignored ASN.1 coding error getEncodedLength", (Throwable)e);
            return null;
        }
    }

    public static BigInteger getEncodedLength(InputStream stream) throws IOException {
        return ASN1Util.getEncodedLength(stream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigInteger getEncodedLength(InputStream stream, boolean close) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED);
        }
        try {
            byte[] tagDescriptorBytes = ASN1Util.getDTagBytes(stream);
            byte[] lengthBytes = ASN1Util.getBytesOfLength(stream);
            BigInteger bigInteger = ASN1Util.toLength(lengthBytes).add(BigInteger.valueOf(tagDescriptorBytes.length)).add(BigInteger.valueOf(lengthBytes.length));
            return bigInteger;
        }
        finally {
            if (close) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.debug((Object)"ignored ASN.1 coding error getEncodedLength", (Throwable)e);
                }
            }
        }
    }

    public static BigInteger getLength(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED);
        }
        try {
            return ASN1Util.getLength(new ByteArrayInputStream(bytes), true);
        }
        catch (IOException e) {
            LOG.debug((Object)"ignored ASN.1 coding error getLength", (Throwable)e);
            return null;
        }
    }

    public static BigInteger getLength(InputStream stream) throws IOException {
        return ASN1Util.getLength(stream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigInteger getLength(InputStream stream, boolean close) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED);
        }
        try {
            ASN1Util.getDTagBytes(stream);
            byte[] lengthBytes = ASN1Util.getBytesOfLength(stream);
            BigInteger bigInteger = ASN1Util.toLength(lengthBytes);
            return bigInteger;
        }
        finally {
            if (close) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.debug((Object)"ignored ASN.1 coding error getLength", (Throwable)e);
                }
            }
        }
    }

    public static BigInteger toLength(byte[] bytesOfLength) {
        if (bytesOfLength == null || bytesOfLength.length == 0) {
            throw new IllegalArgumentException("bytes with length of ASN.1-structure expected");
        }
        if (bytesOfLength.length == 1 && bytesOfLength[0] == -128) {
            return ASN1Constants.LENGTH_UNDETERMINED;
        }
        if (bytesOfLength.length == 1 && bytesOfLength[0] < 0) {
            throw new IllegalArgumentException("wrong length coding: one byte length, but more than one byte announced");
        }
        if (bytesOfLength[0] < 0 && (bytesOfLength[0] & 0x7F) != bytesOfLength.length - 1) {
            throw new IllegalArgumentException("wrong length coding: number of bytes announced not matching number of bytes present");
        }
        if (bytesOfLength.length == 1 && bytesOfLength[0] > 0 && bytesOfLength[0] <= 127) {
            return BigInteger.valueOf(bytesOfLength[0] & 0xFF);
        }
        byte[] result = new byte[bytesOfLength.length];
        System.arraycopy(bytesOfLength, 0, result, 0, bytesOfLength.length);
        result[0] = 0;
        return new BigInteger(result);
    }

    public static boolean isSequence(byte[] dTagBytes) {
        if (dTagBytes == null || dTagBytes.length == 0) {
            throw new IllegalArgumentException(MSG_NULL_OR_EMPTY_ARRAY_NOT_PERMITTED);
        }
        return ASN1Util.isUniversal(dTagBytes) && (dTagBytes[0] & 0x1F) == 16;
    }

    public static boolean isSet(byte[] dTagBytes) {
        if (dTagBytes == null || dTagBytes.length == 0) {
            throw new IllegalArgumentException(MSG_NULL_OR_EMPTY_ARRAY_NOT_PERMITTED);
        }
        return ASN1Util.isUniversal(dTagBytes) && (dTagBytes[0] & 0x1F) == 17;
    }

    public static boolean isUniversal(byte[] dTagBytes) {
        if (dTagBytes == null || dTagBytes.length == 0) {
            throw new IllegalArgumentException(MSG_NULL_OR_EMPTY_ARRAY_NOT_PERMITTED);
        }
        return (dTagBytes[0] & 0xFFFFFFC0) == 0;
    }

    public static boolean isApplication(byte[] dTagBytes) {
        if (dTagBytes == null || dTagBytes.length == 0) {
            throw new IllegalArgumentException(MSG_NULL_OR_EMPTY_ARRAY_NOT_PERMITTED);
        }
        return (dTagBytes[0] & 0xFFFFFFC0) == 64;
    }

    public static boolean isContextSpecific(byte[] dTagBytes) {
        if (dTagBytes == null || dTagBytes.length == 0) {
            throw new IllegalArgumentException(MSG_NULL_OR_EMPTY_ARRAY_NOT_PERMITTED);
        }
        return (dTagBytes[0] & 0xFFFFFFC0) == -128;
    }

    public static boolean isPrivate(byte[] dTagBytes) {
        if (dTagBytes == null || dTagBytes.length == 0) {
            throw new IllegalArgumentException(MSG_NULL_OR_EMPTY_ARRAY_NOT_PERMITTED);
        }
        return (dTagBytes[0] & 0xFFFFFFC0) == -64;
    }

    public static boolean isPrimitive(byte[] dTagBytes) {
        if (dTagBytes == null || dTagBytes.length == 0) {
            throw new IllegalArgumentException(MSG_NULL_OR_EMPTY_ARRAY_NOT_PERMITTED);
        }
        return (dTagBytes[0] & 0x20) == 0;
    }

    public static boolean isConstructed(byte[] dTagBytes) {
        if (dTagBytes == null || dTagBytes.length == 0) {
            throw new IllegalArgumentException(MSG_NULL_OR_EMPTY_ARRAY_NOT_PERMITTED);
        }
        return !ASN1Util.isPrimitive(dTagBytes);
    }

    public static ASN1[] getChildElements(ASN1 asn1) throws IOException {
        if (asn1 == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED);
        }
        ASN1[] children = ASN1Constants.EMPTY_ASN1_ARRAY;
        byte[] tagDescriptorBytes = asn1.getDTagBytes();
        if (ASN1Util.isSequence(tagDescriptorBytes) || ASN1Util.isSet(tagDescriptorBytes) || ASN1Util.isConstructed(tagDescriptorBytes) || !ASN1Util.isUniversal(tagDescriptorBytes)) {
            byte[] valueBytes;
            byte[] tmp = valueBytes = asn1.getValue();
            if (valueBytes != null && valueBytes.length > 0 && valueBytes[0] == 0) {
                tmp = new byte[valueBytes.length - 1];
                System.arraycopy(valueBytes, 1, tmp, 0, tmp.length);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(tmp);
            children = ASN1Util.getElements(bis, true);
        }
        return children;
    }

    public static List<ASN1> getChildElementList(ASN1 asn1) throws IOException {
        if (asn1 == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED);
        }
        ASN1[] children = ASN1Constants.EMPTY_ASN1_ARRAY;
        byte[] tagDescriptorBytes = asn1.getDTagBytes();
        ArrayList<ASN1> result = new ArrayList<ASN1>();
        if (ASN1Util.isSequence(tagDescriptorBytes) || ASN1Util.isSet(tagDescriptorBytes) || ASN1Util.isConstructed(tagDescriptorBytes)) {
            byte[] valueBytes;
            byte[] tmp = valueBytes = asn1.getValue();
            if (valueBytes != null && valueBytes.length > 0 && valueBytes[0] == 0) {
                tmp = new byte[valueBytes.length - 1];
                System.arraycopy(valueBytes, 1, tmp, 0, tmp.length);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(tmp);
            children = ASN1Util.getElements(bis, true);
        }
        if (children != null) {
            for (ASN1 tmp : children) {
                if (tmp == null) continue;
                result.add(tmp);
            }
        }
        return result;
    }

    public static ASN1 addChild(ASN1 parent, ASN1 child) throws IOException {
        if (parent == null || child == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED_AS_ARGUMENT);
        }
        byte[] tagDescriptorBytes = parent.getDTagBytes();
        if (!ASN1Util.isSequence(tagDescriptorBytes) && !ASN1Util.isSet(tagDescriptorBytes) && !ASN1Util.isConstructed(tagDescriptorBytes) && ASN1Util.isUniversal(tagDescriptorBytes)) {
            throw new IllegalArgumentException(MSG_UNSUITABLE_PARENT_ELEMENT);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(parent.getValue());
        baos.write(child.getEncoded());
        baos.close();
        return new ASN1(tagDescriptorBytes, baos.toByteArray());
    }

    public static ASN1 removeChild(ASN1 parent, byte[] tag, int index) throws IOException {
        if (parent == null || tag == null || tag.length == 0) {
            throw new IllegalArgumentException("null or empty array not permitted as argument");
        }
        byte[] tagDescriptorBytes = parent.getDTagBytes();
        if (!ASN1Util.isSequence(tagDescriptorBytes) && !ASN1Util.isSet(tagDescriptorBytes) && !ASN1Util.isConstructed(tagDescriptorBytes) && ASN1Util.isUniversal(tagDescriptorBytes)) {
            throw new IllegalArgumentException(MSG_UNSUITABLE_PARENT_ELEMENT);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int counter = 0;
        for (ASN1 asn1 : parent.getChildElements()) {
            if (Arrays.equals(asn1.getDTagBytes(), tag)) {
                if (counter != index) {
                    baos.write(asn1.getEncoded());
                }
                ++counter;
                continue;
            }
            baos.write(asn1.getEncoded());
        }
        baos.close();
        return new ASN1(tagDescriptorBytes, baos.toByteArray());
    }

    public static ASN1 removeChild(ASN1 root, ASN1Path path) throws IOException {
        if (root == null || path == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED_AS_ARGUMENT);
        }
        if (path.getParent() == null) {
            throw new IllegalArgumentException("path without parent not permitted");
        }
        byte[] tagDescriptorBytes = root.getDTagBytes();
        if (!ASN1Util.isSequence(tagDescriptorBytes) && !ASN1Util.isSet(tagDescriptorBytes) && !ASN1Util.isConstructed(tagDescriptorBytes) && ASN1Util.isUniversal(tagDescriptorBytes)) {
            throw new IllegalArgumentException("unsuitable root element");
        }
        ASN1Path parentPath = path.getParent();
        ASN1 parent = parentPath.getParent() == null ? root : root.getChildElementByPath(parentPath);
        parent = ASN1Util.removeChild(parent, path.getTag().toByteArray(), path.getIndex());
        return ASN1Util.exchangeChildInt(root, parentPath, parent);
    }

    public static ASN1 exchangeChildValue(ASN1 root, ASN1Path path, byte[] newValue) throws IOException {
        if (root == null || path == null || newValue == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED_AS_ARGUMENT);
        }
        if (path.getParent() == null) {
            throw new IllegalArgumentException("path without parent not permitted");
        }
        byte[] tagDescriptorBytes = root.getDTagBytes();
        if (!ASN1Util.isSequence(tagDescriptorBytes) && !ASN1Util.isSet(tagDescriptorBytes) && !ASN1Util.isConstructed(tagDescriptorBytes) && ASN1Util.isUniversal(tagDescriptorBytes)) {
            throw new IllegalArgumentException("unsuitable root element");
        }
        ASN1 newChild = new ASN1(path.getTag().toByteArray(), newValue);
        return ASN1Util.exchangeChildInt(root, path, newChild);
    }

    private static ASN1 exchangeChildInt(ASN1 root, ASN1Path path, ASN1 child) throws IOException {
        if (root == null || path == null || child == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED);
        }
        ASN1 lRoot = root;
        ASN1Path lPath = path;
        ASN1 lChild = child;
        while (lPath.getParent() != null) {
            ASN1 lParent = lPath.getParent().getParent() == null ? lRoot : lRoot.getChildElementByPath(lPath.getParent());
            lParent = ASN1Util.exchangeChildValue(lParent, lChild.getDTagBytes(), lPath.getIndex(), lChild.getValue());
            lPath = lPath.getParent();
            lChild = lParent;
        }
        return lChild;
    }

    public static ASN1 exchangeChildValue(ASN1 parent, byte[] tag, int index, byte[] newValue) throws IOException {
        if (parent == null || tag == null || tag.length == 0 || newValue == null) {
            throw new IllegalArgumentException("null or empty array not permitted as argument");
        }
        byte[] tagDescriptorBytes = parent.getDTagBytes();
        if (!ASN1Util.isSequence(tagDescriptorBytes) && !ASN1Util.isSet(tagDescriptorBytes) && !ASN1Util.isConstructed(tagDescriptorBytes) && ASN1Util.isUniversal(tagDescriptorBytes)) {
            throw new IllegalArgumentException(MSG_UNSUITABLE_PARENT_ELEMENT);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int counter = 0;
        for (ASN1 asn1 : parent.getChildElements()) {
            if (Arrays.equals(asn1.getDTagBytes(), tag)) {
                if (counter != index) {
                    baos.write(asn1.getEncoded());
                } else {
                    baos.write(new ASN1(tag, newValue).getEncoded());
                }
                ++counter;
                continue;
            }
            baos.write(asn1.getEncoded());
        }
        baos.close();
        return new ASN1(tagDescriptorBytes, baos.toByteArray());
    }

    public static ASN1 exchangeChildTag(ASN1 parent, byte[] tag, int index, byte[] newTag) throws IOException {
        if (parent == null || tag == null || tag.length == 0 || newTag == null || newTag.length == 0) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED_AS_ARGUMENT);
        }
        byte[] tagDescriptorBytes = parent.getDTagBytes();
        if (!ASN1Util.isSequence(tagDescriptorBytes) && !ASN1Util.isSet(tagDescriptorBytes) && !ASN1Util.isConstructed(tagDescriptorBytes) && ASN1Util.isUniversal(tagDescriptorBytes)) {
            throw new IllegalArgumentException(MSG_UNSUITABLE_PARENT_ELEMENT);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int counter = 0;
        for (ASN1 asn1 : parent.getChildElements()) {
            if (Arrays.equals(asn1.getDTagBytes(), tag)) {
                if (counter != index) {
                    baos.write(asn1.getEncoded());
                } else {
                    baos.write(new ASN1(newTag, asn1.getValue()).getEncoded());
                }
                ++counter;
                continue;
            }
            baos.write(asn1.getEncoded());
        }
        baos.close();
        return new ASN1(tagDescriptorBytes, baos.toByteArray());
    }

    public static ASN1[] getElements(InputStream stream) throws IOException {
        return ASN1Util.getElements(stream, null, true);
    }

    public static ASN1[] getElements(InputStream stream, boolean close) throws IOException {
        return ASN1Util.getElements(stream, null, close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ASN1[] getElements(InputStream stream, ASN1 endValue, boolean close) throws IOException {
        ArrayList<ASN1> resultList = new ArrayList<ASN1>();
        boolean endValueFound = false;
        if (stream == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED);
        }
        try {
            ASN1 tmp = null;
            while (stream.available() != 0) {
                tmp = new ASN1(stream, false);
                if (endValue != null && endValue.equals(tmp)) {
                    endValueFound = true;
                    break;
                }
                resultList.add(tmp);
            }
        }
        catch (Exception e) {
            resultList.clear();
        }
        finally {
            if (close) {
                stream.close();
            }
        }
        if (endValue != null && !endValueFound) {
            throw new IOException("terminating end value not read from stream: " + HexUtil.hexify(endValue.getEncoded()));
        }
        return resultList.toArray(new ASN1[resultList.size()]);
    }

    public static ASN1[] filterByTag(ASN1[] asn1s, Short tag) {
        if (tag == null) {
            throw new IllegalArgumentException(MSG_TAG_NOT_PERMITTED_AS_NULL);
        }
        return ASN1Util.filterByTag(asn1s, (long)tag.shortValue());
    }

    public static ASN1[] filterByTag(ASN1[] asn1s, Integer tag) {
        if (tag == null) {
            throw new IllegalArgumentException(MSG_TAG_NOT_PERMITTED_AS_NULL);
        }
        return ASN1Util.filterByTag(asn1s, (long)tag.intValue());
    }

    public static ASN1[] filterByTag(ASN1[] asn1s, Long tag) {
        if (tag == null) {
            throw new IllegalArgumentException(MSG_TAG_NOT_PERMITTED_AS_NULL);
        }
        return ASN1Util.filterByTag(asn1s, (long)tag);
    }

    public static ASN1[] filterByTag(ASN1[] asn1s, short tag) {
        return ASN1Util.filterByTag(asn1s, (long)tag);
    }

    public static ASN1[] filterByTag(ASN1[] asn1s, int tag) {
        return ASN1Util.filterByTag(asn1s, (long)tag);
    }

    public static ASN1[] filterByTag(ASN1[] asn1s, long tag) {
        ASN1[] lResult = ASN1Constants.EMPTY_ASN1_ARRAY;
        if (asn1s != null) {
            BigInteger tmpTag = BigInteger.valueOf(tag);
            ArrayList<ASN1> resultList = new ArrayList<ASN1>();
            for (int i = 0; i < asn1s.length; ++i) {
                if (asn1s[i] == null || !asn1s[i].getTag().equals(tmpTag)) continue;
                resultList.add(asn1s[i]);
            }
            lResult = resultList.toArray(new ASN1[resultList.size()]);
        }
        return lResult;
    }

    public static ASN1[] filterByTagOfDTag(ASN1[] asn1s, BigInteger dTag) {
        if (dTag == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED);
        }
        return ASN1Util.filterByTagOfDTagBytes(asn1s, dTag.toByteArray());
    }

    public static ASN1[] filterByTagOfDTagBytes(ASN1[] asn1s, byte[] dTagBytes) {
        if (dTagBytes == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED);
        }
        ASN1[] lResult = ASN1Constants.EMPTY_ASN1_ARRAY;
        if (asn1s != null) {
            BigInteger tag = ASN1Util.extractTag(dTagBytes);
            ArrayList<ASN1> resultList = new ArrayList<ASN1>();
            for (int i = 0; i < asn1s.length; ++i) {
                if (asn1s[i] == null || !asn1s[i].getTag().equals(tag)) continue;
                resultList.add(asn1s[i]);
            }
            lResult = resultList.toArray(new ASN1[resultList.size()]);
        }
        return lResult;
    }

    public static ASN1[] filterByDTag(ASN1[] asn1Objects, BigInteger dTag) {
        if (dTag == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED);
        }
        return ASN1Util.filterByDTagBytes(asn1Objects, dTag.toByteArray());
    }

    public static ASN1[] filterByDTagBytes(ASN1[] asn1s, byte[] dTagBytes) {
        if (dTagBytes == null || dTagBytes.length == 0) {
            throw new IllegalArgumentException(MSG_NULL_OR_EMPTY_ARRAY_NOT_PERMITTED);
        }
        byte[] lDTagBytes = dTagBytes;
        ASN1[] lResult = ASN1Constants.EMPTY_ASN1_ARRAY;
        int i = 0;
        while (lDTagBytes[i] == 0) {
            ++i;
        }
        lDTagBytes = ByteUtil.subbytes(ByteUtil.copy(lDTagBytes), i);
        if (asn1s != null) {
            ArrayList<ASN1> resultList = new ArrayList<ASN1>();
            for (i = 0; i < asn1s.length; ++i) {
                if (asn1s[i] == null || !Arrays.equals(asn1s[i].getDTagBytes(), lDTagBytes)) continue;
                resultList.add(asn1s[i]);
            }
            lResult = resultList.toArray(new ASN1[resultList.size()]);
        }
        return lResult;
    }

    public static byte[] getBytesOfValue(byte[] dTagBytes, BigInteger length, InputStream stream) throws IOException {
        if (dTagBytes == null || dTagBytes.length == 0 || length == null || stream == null) {
            throw new IllegalArgumentException(MSG_NULL_OR_EMPTY_ARRAY_NOT_PERMITTED);
        }
        byte[] result = null;
        if (length != ASN1Constants.LENGTH_UNDETERMINED) {
            result = ASN1Util.readValueLengthUndetermined(length, stream);
        } else if (ASN1Util.isSequence(dTagBytes) || ASN1Util.isSet(dTagBytes) || ASN1Util.isConstructed(dTagBytes) || !ASN1Util.isUniversal(dTagBytes)) {
            ASN1[] asn1Values = ASN1Util.getElements(stream, ASN1Constants.EOC_ASN1, false);
            result = ASN1Util.encode(asn1Values);
        } else {
            result = ASN1Util.readValueEndingWithEOC(stream);
        }
        return result;
    }

    private static byte[] readValueLengthUndetermined(BigInteger length, InputStream stream) throws IOException {
        int modBufferLength = length.mod(ASN1Constants.BI_BUFFER_SIZE).intValue();
        int divBufferCount = length.divide(BigInteger.valueOf(4096L)).intValue();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int r = 0;
        byte[] buffer = new byte[4096];
        for (int i = 0; i < divBufferCount; ++i) {
            r = stream.read(buffer, 0, 4096);
            baos.write(buffer, 0, r);
        }
        if (modBufferLength > 0) {
            int rSum = 0;
            int retries = 10;
            while (retries > 0 && modBufferLength != rSum) {
                r = stream.read(buffer, 0, modBufferLength);
                if (r != -1) {
                    rSum += r;
                    baos.write(buffer, 0, r);
                    continue;
                }
                --retries;
            }
            if (modBufferLength != rSum) {
                throw new IOException("insufficient data: " + (modBufferLength - rSum) + " byte more expected");
            }
        }
        baos.flush();
        baos.close();
        byte[] result = baos.toByteArray();
        return result;
    }

    private static byte[] readValueEndingWithEOC(InputStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int eocByteCounter = 0;
        int b = 0;
        byte[] eoc = ASN1Constants.EOC_ASN1.getEncoded();
        while (eocByteCounter < eoc.length && (b = stream.read()) != -1) {
            baos.write((byte)b);
            if (eocByteCounter == 0) {
                if (b != eoc[eocByteCounter]) continue;
                ++eocByteCounter;
                continue;
            }
            if (b == eoc[eocByteCounter]) {
                ++eocByteCounter;
                continue;
            }
            eocByteCounter = 0;
        }
        baos.flush();
        baos.close();
        if (eocByteCounter != ASN1Constants.EOC_ASN1.getEncoded().length) {
            throw new IOException("insufficient data: EOC bytes not found");
        }
        byte[] result = baos.toByteArray();
        return result;
    }

    protected static void appendBytes(StringBuilder builder, String indent, byte[] bytes) {
        if (builder == null || indent == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED);
        }
        String hex = HexUtil.hexify(bytes, " ");
        hex = hex.replaceAll("\n", "\n" + indent);
        builder.append(indent + hex);
    }

    public static byte[] encode(ASN1[] asn1s) throws IOException {
        byte[] result = null;
        if (asn1s != null && asn1s.length > 0) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                for (int i = 0; i < asn1s.length; ++i) {
                    baos.write(asn1s[i].getEncoded());
                }
                result = baos.toByteArray();
            }
            catch (Exception e) {
                result = new byte[]{};
            }
        } else {
            result = new byte[]{};
        }
        return result;
    }

    public static byte[] getDTagBytes(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(MSG_NULL_NOT_PERMITTED);
        }
        byte[] result = null;
        int tag1 = stream.read();
        if (tag1 < 0) {
            throw new IOException(MSG_END_OF_STREAM_REACHED);
        }
        if ((tag1 & 0x1F) == 31) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write((byte)tag1);
            tag1 = stream.read();
            baos.write((byte)tag1);
            if (tag1 >= 128) {
                while ((tag1 = stream.read()) >= 128) {
                    baos.write((byte)tag1);
                }
                baos.write((byte)tag1);
            }
            baos.flush();
            baos.close();
            result = baos.toByteArray();
        } else {
            result = new byte[]{(byte)tag1};
        }
        return result;
    }

    public static byte[] getBytesOfLength(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("null nor permitted");
        }
        byte[] result = null;
        int length = stream.read();
        if (length < 0) {
            throw new IOException(MSG_END_OF_STREAM_REACHED);
        }
        if (length < 128) {
            result = new byte[]{(byte)length};
        } else if (length == 129) {
            result = ASN1Util.handleLongFormatLeadingZero(stream, length);
        } else if (length > 128) {
            result = ASN1Util.handleLongFormatDetermined(stream, length);
        } else if (length == 128) {
            result = new byte[]{(byte)length};
        }
        return result;
    }

    private static byte[] handleLongFormatLeadingZero(InputStream stream, int plength) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write((byte)plength);
        int length = plength & 0x7F;
        int offset = 0;
        int i = 0;
        int n = length;
        while (i < n) {
            offset = 0;
            length = stream.read();
            if (i == 0 && length == 0) {
                offset = -1;
            }
            baos.write((byte)length);
            i = i + 1 + offset;
        }
        baos.flush();
        baos.close();
        byte[] result = baos.toByteArray();
        return result;
    }

    private static byte[] handleLongFormatDetermined(InputStream stream, int plength) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write((byte)plength);
        int length = plength & 0x7F;
        int n = length;
        for (int i = 0; i < n; ++i) {
            length = stream.read();
            if (length < 0) {
                throw new IOException(MSG_END_OF_STREAM_REACHED);
            }
            baos.write((byte)length);
        }
        baos.flush();
        baos.close();
        byte[] result = baos.toByteArray();
        return result;
    }

    public static byte[] getBytesOfValue(byte[] dTagBytes, byte[] length, InputStream stream) throws IOException {
        return ASN1Util.getBytesOfValue(dTagBytes, ASN1Util.toLength(length), stream);
    }

    static {
        LinkedHashMap<Byte, String> tmp = new LinkedHashMap<Byte, String>();
        tmp.put((byte)1, "Boolean");
        tmp.put((byte)2, "Integer");
        tmp.put((byte)3, "BitString");
        tmp.put((byte)4, "OctetString");
        tmp.put((byte)5, "Null");
        tmp.put((byte)6, "OID");
        tmp.put((byte)17, "Set");
        tmp.put((byte)16, "Sequence");
        tmp.put((byte)12, "UTF8-String");
        tmp.put((byte)18, "NumericString");
        tmp.put((byte)19, "PrintableString");
        tmp.put((byte)20, "TeletexString");
        tmp.put((byte)21, "VideotexString");
        tmp.put((byte)22, "IA5String");
        tmp.put((byte)25, "GraphicString");
        tmp.put((byte)26, "VisibleString");
        tmp.put((byte)27, "GeneralString");
        tmp.put((byte)23, "UTCTime");
        tmp.put((byte)24, "Generalized Time");
        tmp.put((byte)30, "BMPString");
        tmp.put((byte)17, "Set");
        tmp.put((byte)16, "Sequence");
        tmp.put((byte)49, "ConstructedSet");
        tmp.put((byte)48, "ConstructedSequence");
        MAP_BYTE_TO_TYPE = Collections.unmodifiableMap(tmp);
        MAP_OID_TO_NAME = Collections.unmodifiableMap(CollectionUtil.convert(CollectionUtil.readPropertiesResource(ASN1Util.class)));
    }
}

