/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.Filter;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.ASN1Encoder;
import de.bos_bremen.common.asn1.ASN1PathType;
import de.bos_bremen.common.asn1.ASN1Util;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ASN1Path {
    private static final String ARG_TAG = "tag";
    private static final String ARG_FILTER = "filter";
    private static final String MSG_TAG_HEX_STRING = "tag hex string";
    private static final Log LOG = LogFactory.getLog(ASN1Path.class);
    public static final int NO_INDEX = -1;
    private Filter<ASN1> filter = null;
    private String name = "";
    private ASN1Path parent = null;
    private BigInteger tag = null;
    private int index = 0;
    private ASN1PathType type = null;
    private Class<? extends ASN1Encoder> encoderClass = null;

    public final Filter<ASN1> getFilter() {
        return this.filter;
    }

    protected ASN1Path(ASN1Path path) {
        this(AssertUtil.notNullReturn(path, (String)"path").name, path.tag, path.index, path.filter, path.parent, path.encoderClass, path.type);
    }

    protected ASN1Path(String name, BigInteger tag, int index, ASN1Path parent) {
        this(name, AssertUtil.notNullReturn(tag, ARG_TAG), index, parent, null, ASN1PathType.NO_INFORMATION);
    }

    protected ASN1Path(String name, BigInteger tag, int index, ASN1Path parent, ASN1PathType type) {
        this(name, AssertUtil.notNullReturn(tag, ARG_TAG), index, parent, null, type);
    }

    protected ASN1Path(String name, byte[] tagBytes, int index, ASN1Path parent) {
        this(name, new BigInteger(ASN1Util.checkTagBytes(tagBytes)), index, parent, null, ASN1PathType.NO_INFORMATION);
    }

    protected ASN1Path(String name, byte[] tagBytes, int index, ASN1Path parent, ASN1PathType type) {
        this(name, new BigInteger(ASN1Util.checkTagBytes(tagBytes)), index, parent, null, AssertUtil.notNullReturn(type, "type"));
    }

    protected ASN1Path(String name, String tagHexString, int index, ASN1Path parent) {
        this(name, HexUtil.parse(AssertUtil.notNullOrEmpty(tagHexString, MSG_TAG_HEX_STRING)), index, parent, null, ASN1PathType.NO_INFORMATION);
    }

    protected ASN1Path(String name, String tagHexString, int index, ASN1Path parent, ASN1PathType type) {
        this(name, HexUtil.parse(AssertUtil.notNullOrEmpty(tagHexString, MSG_TAG_HEX_STRING)), index, parent, null, AssertUtil.notNullReturn(type, "type"));
    }

    protected ASN1Path(String name, BigInteger tag, int index, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass, ASN1PathType type) {
        this(name, AssertUtil.notNullReturn(tag, ARG_TAG), index, null, parent, encoderClass, AssertUtil.notNullReturn(type, "type"));
    }

    protected ASN1Path(String name, byte tagByte, int index, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass) {
        this(name, new byte[]{tagByte}, index, parent, encoderClass, ASN1PathType.NO_INFORMATION);
    }

    protected ASN1Path(String name, byte tagByte, int index, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass, ASN1PathType type) {
        this(name, new byte[]{tagByte}, index, parent, encoderClass, AssertUtil.notNullReturn(type, "type"));
    }

    protected ASN1Path(String name, byte[] tagBytes, int index, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass) {
        this(name, new BigInteger(ASN1Util.checkTagBytes(tagBytes)), index, parent, encoderClass, ASN1PathType.NO_INFORMATION);
    }

    protected ASN1Path(String name, byte[] tagBytes, int index, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass, ASN1PathType type) {
        this(name, new BigInteger(ASN1Util.checkTagBytes(tagBytes)), index, parent, encoderClass, AssertUtil.notNullReturn(type, "type"));
    }

    protected ASN1Path(String name, String tagHexString, int index, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass) {
        this(name, HexUtil.parse(AssertUtil.notNullOrEmpty(tagHexString, MSG_TAG_HEX_STRING)), index, parent, encoderClass, ASN1PathType.NO_INFORMATION);
    }

    protected ASN1Path(String name, String tagHexString, int index, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass, ASN1PathType type) {
        this(name, HexUtil.parse(AssertUtil.notNullOrEmpty(tagHexString, MSG_TAG_HEX_STRING)), index, parent, encoderClass, AssertUtil.notNullReturn(type, "type"));
    }

    protected ASN1Path(String name, BigInteger tag, Filter<ASN1> filter, ASN1Path parent) {
        this(name, AssertUtil.notNullReturn(tag, ARG_TAG), AssertUtil.notNullReturn(filter, ARG_FILTER), parent, null, ASN1PathType.NO_INFORMATION);
    }

    protected ASN1Path(String name, BigInteger tag, Filter<ASN1> filter, ASN1Path parent, ASN1PathType type) {
        this(name, AssertUtil.notNullReturn(tag, ARG_TAG), AssertUtil.notNullReturn(filter, ARG_FILTER), parent, null, AssertUtil.notNullReturn(type, "type"));
    }

    protected ASN1Path(String name, byte[] tagBytes, Filter<ASN1> filter, ASN1Path parent) {
        this(name, new BigInteger(ASN1Util.checkTagBytes(tagBytes)), AssertUtil.notNullReturn(filter, ARG_FILTER), parent, null, ASN1PathType.NO_INFORMATION);
    }

    protected ASN1Path(String name, byte[] tagBytes, Filter<ASN1> filter, ASN1Path parent, ASN1PathType type) {
        this(name, new BigInteger(ASN1Util.checkTagBytes(tagBytes)), AssertUtil.notNullReturn(filter, ARG_FILTER), parent, null, AssertUtil.notNullReturn(type, "type"));
    }

    protected ASN1Path(String name, String tagHexString, Filter<ASN1> filter, ASN1Path parent) {
        this(name, HexUtil.parse(AssertUtil.notNullOrEmpty(tagHexString, MSG_TAG_HEX_STRING)), AssertUtil.notNullReturn(filter, ARG_FILTER), parent, null, ASN1PathType.NO_INFORMATION);
    }

    protected ASN1Path(String name, String tagHexString, Filter<ASN1> filter, ASN1Path parent, ASN1PathType type) {
        this(name, HexUtil.parse(AssertUtil.notNullOrEmpty(tagHexString, MSG_TAG_HEX_STRING)), AssertUtil.notNullReturn(filter, ARG_FILTER), parent, null, AssertUtil.notNullReturn(type, "type"));
    }

    protected ASN1Path(String name, BigInteger tag, Filter<ASN1> filter, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass, ASN1PathType type) {
        this(name, AssertUtil.notNullReturn(tag, ARG_TAG), -1, AssertUtil.notNullReturn(filter, ARG_FILTER), parent, encoderClass, AssertUtil.notNullReturn(type, "type"));
    }

    protected ASN1Path(String name, BigInteger tag, int index, Filter<ASN1> filter, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass, ASN1PathType type) {
        AssertUtil.notNull(tag, ARG_TAG);
        ASN1Util.checkTagBytes(tag.toByteArray());
        if (filter != null && index != -1) {
            throw new IllegalArgumentException("filter specified, index only permitted as -1");
        }
        if (filter == null) {
            AssertUtil.zeroOrPositive(index, "index");
        } else {
            AssertUtil.equals(ASN1.class, filter.getFilterClass(), "filter class");
        }
        if (encoderClass != null) {
            try {
                encoderClass.getConstructor(new Class[0]);
                encoderClass.newInstance();
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("Class of encoder not permitted, expected empty constructor does not exist or not accessible");
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Class of encoder not permitted, expected empty constructor does not exist");
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("instance of encoder Class can not be instantiated");
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Class of encoder not permitted, expected empty constructor does not accessible");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Class of encoder not permitted, instantiation of encoder instance failed: " + e.getMessage(), e);
            }
        }
        AssertUtil.notNull((Object)type, "type");
        this.name = name;
        this.tag = tag;
        this.filter = filter;
        this.index = index;
        this.parent = parent;
        this.encoderClass = encoderClass;
        this.type = type;
    }

    protected ASN1Path(String name, byte tagByte, Filter<ASN1> filter, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass) {
        this(name, new byte[]{tagByte}, filter, parent, encoderClass, ASN1PathType.NO_INFORMATION);
    }

    protected ASN1Path(String name, byte tagByte, Filter<ASN1> filter, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass, ASN1PathType type) {
        this(name, new byte[]{tagByte}, filter, parent, encoderClass, type);
    }

    protected ASN1Path(String name, byte[] tagBytes, Filter<ASN1> filter, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass) {
        this(name, new BigInteger(ASN1Util.checkTagBytes(tagBytes)), filter, parent, encoderClass, ASN1PathType.NO_INFORMATION);
    }

    protected ASN1Path(String name, byte[] tagBytes, Filter<ASN1> filter, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass, ASN1PathType type) {
        this(name, new BigInteger(ASN1Util.checkTagBytes(tagBytes)), filter, parent, encoderClass, type);
    }

    protected ASN1Path(String name, String tagHexString, Filter<ASN1> filter, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass) {
        this(name, HexUtil.parseBigInteger(tagHexString), filter, parent, encoderClass, ASN1PathType.NO_INFORMATION);
    }

    protected ASN1Path(String name, String tagHexString, Filter<ASN1> filter, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass, ASN1PathType type) {
        this(name, HexUtil.parseBigInteger(tagHexString), filter, parent, encoderClass, type);
    }

    public ASN1Path getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public BigInteger getTag() {
        return this.tag;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return this.getName() + "(Tag: 0x" + HexUtil.hexify(this.tag.toByteArray()) + ", Index: " + this.index + ", Parent: " + (this.parent != null ? this.parent.name : "no parent") + ")";
    }

    public final ASN1 getASN1(byte[] bytes) throws IOException {
        AssertUtil.notNullOrEmpty(bytes, "bytes");
        ASN1Encoder encoder = this.getEncoder();
        if (encoder != null) {
            return encoder.decode(bytes);
        }
        return null;
    }

    private ASN1Encoder getEncoder() {
        ASN1Encoder result = null;
        if (this.encoderClass != null) {
            try {
                result = this.encoderClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.debug((Object)e);
            }
        }
        return result;
    }

    public final ASN1 getASN1(ASN1 asn1) {
        AssertUtil.notNull(asn1, "asn1");
        ASN1Encoder encoder = this.getEncoder();
        if (encoder != null) {
            return encoder.decode(asn1);
        }
        return null;
    }

    public Class<? extends ASN1Encoder> getEncoderClass() {
        return this.encoderClass;
    }

    public ASN1PathType getType() {
        return this.type;
    }

    public static List<ASN1Path> getParentList(ASN1Path path) {
        AssertUtil.notNull(path, "path");
        ArrayList<ASN1Path> parentList = new ArrayList<ASN1Path>();
        ASN1Path tmp = path;
        do {
            parentList.add(0, tmp);
        } while ((tmp = tmp.getParent()) != null);
        return parentList;
    }

    public ASN1Path truncPath(int depth) {
        AssertUtil.zeroOrPositive(depth, "depth");
        List<ASN1Path> parentList = ASN1Path.getParentList(this);
        if (depth >= parentList.size()) {
            throw new IllegalArgumentException("requested depth exceeds tree depth");
        }
        int idx = parentList.size() - 1 - depth;
        ASN1Path tmp = parentList.get(idx);
        ASN1Path newRoot = new ASN1Path(tmp);
        newRoot.parent = null;
        tmp = newRoot;
        ASN1Path newChild = newRoot;
        for (int i = idx + 1; i < parentList.size(); ++i) {
            newChild = parentList.get(i);
            tmp = newChild = new ASN1Path(newChild.getName(), newChild.getTag(), newChild.getIndex(), newChild.getFilter(), tmp, newChild.getEncoderClass(), newChild.getType());
        }
        return newChild;
    }
}

