/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;

public class ASN1Compact {
    private byte tagLength = 0;
    private byte[] value = null;

    public ASN1Compact(byte[] complete) {
        AssertUtil.notNullOrEmpty(complete, "byte-array");
        if ((complete[0] & 0xF) != complete.length - 1) {
            throw new IllegalArgumentException("length not as indicated in first byte");
        }
        this.tagLength = complete[0];
        this.value = ByteUtil.subbytes(complete, 1);
    }

    public ASN1Compact(ASN1Compact asn1) {
        if (asn1 == null) {
            throw new IllegalArgumentException("null not allowed");
        }
        this.tagLength = asn1.getTagLength();
        this.value = asn1.getValue();
    }

    public ASN1Compact(byte tag, byte[] value) {
        if (value != null && value.length > 15) {
            throw new IllegalArgumentException("value too long");
        }
        if ((tag & 0xF) != 0) {
            throw new IllegalArgumentException("length bytes not allowed to be set");
        }
        this.value = value == null ? new byte[0] : ByteUtil.copy(value);
        this.tagLength = (byte)(tag | this.value.length);
    }

    public byte getTag() {
        return (byte)(this.tagLength & 0xF0);
    }

    public byte getLength() {
        return (byte)(this.tagLength & 0xF);
    }

    public byte getTagLength() {
        return this.tagLength;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getEncoded() {
        return ByteUtil.combine(new byte[]{this.tagLength}, this.value);
    }

    public String toString() {
        return "ASN1Compact: (Tag: " + (this.getTag() >> 4 & 0xF) + " - Length: " + this.getLength() + " - Value: " + HexUtil.hexify(this.value) + " )";
    }
}

