/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.asn1;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.Filter;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.ObjectUtil;
import de.bos_bremen.common.asn1.ASN1Constants;
import de.bos_bremen.common.asn1.ASN1Encoder;
import de.bos_bremen.common.asn1.ASN1Path;
import de.bos_bremen.common.asn1.ASN1Util;
import de.bos_bremen.common.constants.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ASN1
implements ASN1Encoder {
    private static final Log LOG = LogFactory.getLog(ASN1.class);
    public static final boolean DEFAULT_CLOSE = false;
    private boolean immutable = false;
    private boolean changeEnabled = true;
    private byte[] dTagBytes = null;
    private byte[] lengthBytes = null;
    private byte[] valueBytes = null;
    private List<ASN1> childElementList = null;
    private boolean changed = false;
    public static final int NO_VALUE = 0;

    public final synchronized void setImmutable() {
        if (this.immutable) {
            return;
        }
        this.updateInt();
        this.getEncoded();
        try {
            List<ASN1> childList = this.getChildElementListInt();
            if (!CollectionUtil.isNullOrEmpty(childList)) {
                for (ASN1 child : childList) {
                    child.setChangeEnabled(false);
                    child.setImmutable();
                }
            }
        }
        catch (IOException e) {
            LOG.debug((Object)"ignored error at ASN.1 setImmutable", (Throwable)e);
        }
        this.immutable = true;
        this.changeEnabled = false;
    }

    public final synchronized boolean isImmutable() {
        return this.immutable;
    }

    protected ASN1(byte[] dTagBytes, byte[] lengthBytes, byte[] valueBytes, boolean immutable) {
        this(dTagBytes, lengthBytes, valueBytes);
        if (immutable) {
            this.setImmutable();
        }
    }

    protected ASN1(byte[] dTagBytes, byte[] lengthBytes, byte[] valueBytes) {
        ASN1Util.checkTagBytes(dTagBytes);
        AssertUtil.notNullOrEmpty(lengthBytes, "length bytes");
        this.dTagBytes = ByteUtil.copy(dTagBytes);
        this.lengthBytes = ByteUtil.copy(lengthBytes);
        this.valueBytes = ByteUtil.copy(valueBytes);
        this.initValueBytes();
        if (!ASN1Constants.LENGTH_UNDETERMINED.equals(this.getLength())) {
            AssertUtil.equals(this.getLength().longValue(), (long)this.valueBytes.length, "length and length of value");
        }
        this.updateInt();
    }

    private void initValueBytes() {
        if (this.valueBytes == null) {
            this.valueBytes = Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
    }

    public ASN1(ASN1 asn1) {
        this(AssertUtil.notNullReturn(asn1, (String)"asn1").dTagBytes, asn1.lengthBytes, asn1.valueBytes);
    }

    public ASN1(int tag, byte[] valueBytes) {
        this(BigInteger.valueOf(tag).toByteArray(), valueBytes);
    }

    public ASN1(byte tag, byte[] valueBytes) {
        this(new byte[]{tag}, valueBytes);
    }

    public ASN1(byte[] dTagBytes, byte[] valueBytes) {
        AssertUtil.notNullOrEmpty(dTagBytes, "tag bytes");
        byte[] lDTagBytes = dTagBytes;
        if (lDTagBytes.length > 1) {
            lDTagBytes = ByteUtil.removeLeadingZero(lDTagBytes);
        }
        ASN1Util.checkTagBytes(lDTagBytes);
        this.dTagBytes = ByteUtil.copy(lDTagBytes);
        this.valueBytes = ByteUtil.copy(valueBytes);
        this.initValueBytes();
        this.lengthBytes = ASN1Util.getLengthBytes(this.valueBytes);
        if ((this.dTagBytes.length > 1 || this.dTagBytes.length == 1 && this.dTagBytes[0] != 0) && !ArrayUtil.isNullOrEmpty(this.valueBytes)) {
            this.updateInt();
        }
    }

    public ASN1(byte[] bytes) throws IOException {
        this(new ByteArrayInputStream(AssertUtil.notNullOrEmpty(bytes, "bytes")), true);
    }

    public ASN1(InputStream stream) throws IOException {
        this(stream, false);
    }

    public ASN1(InputStream stream, boolean close) throws IOException {
        try {
            AssertUtil.notNull(stream, "stream");
            this.dTagBytes = ASN1Util.checkTagBytes(ASN1Util.getDTagBytes(stream));
            this.lengthBytes = ASN1Util.getBytesOfLength(stream);
            this.valueBytes = ASN1Util.getBytesOfValue(this.dTagBytes, ASN1Util.toLength(this.lengthBytes), stream);
        }
        finally {
            if (ObjectUtil.notNull(stream) && close) {
                stream.close();
            }
        }
    }

    public boolean isUniversal() {
        return ASN1Util.isUniversal(this.dTagBytes);
    }

    public boolean isApplication() {
        return ASN1Util.isApplication(this.dTagBytes);
    }

    public boolean isContextSpecific() {
        return ASN1Util.isContextSpecific(this.dTagBytes);
    }

    public boolean isPrivate() {
        return ASN1Util.isPrivate(this.dTagBytes);
    }

    public boolean isSequence() {
        return ASN1Util.isSequence(this.dTagBytes);
    }

    public boolean isSet() {
        return ASN1Util.isSet(this.dTagBytes);
    }

    public boolean isPrimitive() {
        return ASN1Util.isPrimitive(this.dTagBytes);
    }

    public boolean isConstructed() {
        return !ASN1Util.isPrimitive(this.dTagBytes);
    }

    public BigInteger getDTag() {
        return new BigInteger(this.dTagBytes);
    }

    public byte[] getDTagBytes() {
        return ByteUtil.copy(this.dTagBytes);
    }

    public BigInteger getTag() {
        return ASN1Util.extractTag(this.dTagBytes);
    }

    public BigInteger getLength() {
        return ASN1Util.toLength(this.lengthBytes);
    }

    public byte[] getLengthBytes() {
        return ByteUtil.copy(this.lengthBytes);
    }

    public byte[] getValue() {
        return ByteUtil.copy(this.valueBytes);
    }

    public BigInteger size() {
        int l = this.dTagBytes.length + this.lengthBytes.length;
        if (this.getLength() == ASN1Constants.LENGTH_UNDETERMINED) {
            l += ASN1Constants.EOC_ASN1.getEncoded().length;
        }
        if (this.valueBytes != null) {
            l += this.valueBytes.length;
        }
        return BigInteger.valueOf(l);
    }

    public ASN1[] getChildElements() throws IOException {
        List<ASN1> childList = this.getChildElementList();
        return CollectionUtil.isNullOrEmpty(childList) ? new ASN1[]{} : childList.toArray(new ASN1[childList.size()]);
    }

    public final synchronized void addChildElements(List<ASN1> childList, ASN1 root) throws IOException {
        this.checkChangeEnabled();
        this.checkExtendedChildOperationAvailability();
        if (CollectionUtil.isNullOrEmpty(childList)) {
            return;
        }
        List<ASN1> currentChildList = this.getChildElementListInt();
        if (!CollectionUtil.isNullOrEmpty(currentChildList)) {
            for (ASN1 child : childList) {
                if (currentChildList.contains(child) || child == null) continue;
                currentChildList.add(child);
                this.setChanged(root);
            }
        }
    }

    public final synchronized List<ASN1> getChildElements(Filter<ASN1> filter) throws IOException {
        this.checkExtendedChildOperationAvailability();
        if (filter == null) {
            return this.getChildElementList();
        }
        ArrayList<ASN1> result = null;
        List<ASN1> childList = this.getChildElementListInt();
        if (!CollectionUtil.isNullOrEmpty(childList)) {
            result = new ArrayList<ASN1>();
            for (ASN1 child : childList) {
                if (!filter.accept(child)) continue;
                result.add(child);
            }
        }
        return result;
    }

    public final synchronized void removeChildElements(Filter<ASN1> filter, ASN1 root) throws IOException {
        this.checkChangeEnabled();
        this.checkExtendedChildOperationAvailability();
        if (filter == null) {
            return;
        }
        List<ASN1> childList = this.getChildElementListInt();
        if (!CollectionUtil.isNullOrEmpty(childList)) {
            List<ASN1> removeList = this.getChildElements(filter);
            int s = childList.size();
            childList.removeAll(removeList);
            if (s != childList.size()) {
                this.setChanged(root);
            }
        }
    }

    public final synchronized void removeChildElements(List<ASN1> childList, ASN1 root) throws IOException {
        this.checkChangeEnabled();
        this.checkExtendedChildOperationAvailability();
        if (CollectionUtil.isNullOrEmpty(childList)) {
            return;
        }
        List<ASN1> currentChildList = this.getChildElementListInt();
        if (!CollectionUtil.isNullOrEmpty(currentChildList)) {
            int s = currentChildList.size();
            currentChildList.removeAll(childList);
            if (s != currentChildList.size()) {
                this.setChanged(root);
            }
        }
    }

    public final synchronized void addChildElement(ASN1 child, ASN1 root) throws IOException {
        this.checkExtendedChildOperationAvailability();
        this.checkChangeEnabled();
        if (child == null) {
            return;
        }
        List<ASN1> childList = this.getChildElementListInt();
        if (!CollectionUtil.isNull(childList) && !childList.contains(child)) {
            childList.add(child);
            this.setChanged(root);
        }
    }

    private void checkExtendedChildOperationAvailability() {
        if (!(this.isSequence() || this.isSet() || this.isConstructed())) {
            throw new UnsupportedOperationException("not a sequence or set, no functionality to add or remove any child element");
        }
    }

    public final synchronized void setChildElement(int idx, ASN1 child, ASN1 root) throws IOException {
        this.checkChangeEnabled();
        this.checkExtendedChildOperationAvailability();
        if (idx < 0) {
            throw new IllegalArgumentException("illegal child index, greater equals 0 permitted only: " + idx);
        }
        List<ASN1> childList = this.getChildElementListInt();
        if (CollectionUtil.isNullOrEmpty(childList) || childList.size() == idx) {
            if (child != null) {
                this.addChildElement(child, root);
            }
        } else {
            if (childList.size() <= idx) {
                throw new IllegalArgumentException("illegal child index, last possible index is currently " + childList.size());
            }
            if (child == null) {
                childList.remove(idx);
                this.setChanged(root);
            } else {
                childList.set(idx, child);
                this.setChanged(root);
            }
        }
    }

    public final synchronized int getChildElementCount() throws IOException {
        List<ASN1> childList = this.getChildElementListInt();
        return CollectionUtil.isNullOrEmpty(childList) ? 0 : childList.size();
    }

    public final synchronized void replaceChildElement(ASN1 oldChild, ASN1 newChild, ASN1 root) throws IOException {
        this.checkChangeEnabled();
        this.checkExtendedChildOperationAvailability();
        if (oldChild == null) {
            throw new IllegalArgumentException("old child is null, use addChildElement for adding");
        }
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null, use removeChildElement for adding");
        }
        List<ASN1> childList = this.getChildElementListInt();
        if (!CollectionUtil.isNullOrEmpty(childList) && childList.contains(oldChild)) {
            childList.set(childList.indexOf(oldChild), newChild);
            this.setChanged(root);
        }
    }

    public final synchronized void removeChildElement(ASN1 child, ASN1 root) throws IOException {
        this.checkChangeEnabled();
        this.checkExtendedChildOperationAvailability();
        List<ASN1> childList = this.getChildElementListInt();
        if (!CollectionUtil.isNullOrEmpty(childList) && childList.contains(child)) {
            childList.remove(child);
            this.setChanged(root);
        }
    }

    public final synchronized void removeChildElements(ASN1 root) throws IOException {
        this.checkChangeEnabled();
        this.checkExtendedChildOperationAvailability();
        List<ASN1> childList = this.getChildElementListInt();
        if (!CollectionUtil.isNullOrEmpty(childList)) {
            childList.clear();
            this.valueBytes = new byte[0];
            this.setChanged(true);
            this.getEncoded();
            this.setChanged(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<ASN1> getChildElementListInt() throws IOException {
        if (this.valueBytes == null) {
            return this.childElementList;
        }
        ASN1 aSN1 = this;
        synchronized (aSN1) {
            if (this.childElementList == null || this.childElementList.isEmpty()) {
                this.childElementList = ASN1Util.getChildElementList(this);
            }
        }
        return this.childElementList;
    }

    public final List<ASN1> getChildElementList() throws IOException {
        return Collections.unmodifiableList(this.getChildElementListInt());
    }

    public ASN1[] getChildElementsByTag(Short childTag) throws IOException {
        return ASN1Util.filterByTag(this.getChildElements(), childTag);
    }

    public ASN1[] getChildElementsByTag(Integer childTag) throws IOException {
        return ASN1Util.filterByTag(this.getChildElements(), childTag);
    }

    public ASN1[] getChildElementsByTag(Long childTag) throws IOException {
        return ASN1Util.filterByTag(this.getChildElements(), childTag);
    }

    public ASN1[] getChildElementsByTag(short childTag) throws IOException {
        return ASN1Util.filterByTag(this.getChildElements(), childTag);
    }

    public ASN1[] getChildElementsByTag(int childTag) throws IOException {
        return ASN1Util.filterByTag(this.getChildElements(), childTag);
    }

    public ASN1[] getChildElementsByTag(long childTag) throws IOException {
        return ASN1Util.filterByTag(this.getChildElements(), childTag);
    }

    public ASN1[] getChildElementsByTag(BigInteger childTag) throws IOException {
        return ASN1Util.filterByTagOfDTag(this.getChildElements(), childTag);
    }

    public ASN1[] getChildElementsByTagBytes(byte[] childTagBytes) throws IOException {
        return ASN1Util.filterByTagOfDTagBytes(this.getChildElements(), childTagBytes);
    }

    public ASN1[] getChildElementsByDTag(BigInteger childDTag) throws IOException {
        return ASN1Util.filterByDTag(this.getChildElements(), childDTag);
    }

    public ASN1[] getChildElementsByDTagBytes(byte[] childDTagBytes) throws IOException {
        return ASN1Util.filterByDTagBytes(this.getChildElements(), childDTagBytes);
    }

    public final synchronized void setChanged(boolean newChanged) {
        this.checkChangeEnabled();
        this.changed = newChanged;
        try {
            List<ASN1> childList = this.getChildElementListInt();
            if (!CollectionUtil.isNullOrEmpty(childList)) {
                for (ASN1 child : childList) {
                    child.setChanged(newChanged);
                }
            }
        }
        catch (IOException e) {
            LOG.debug((Object)"ignored error at ASN.1 setChanged", (Throwable)e);
        }
    }

    public final synchronized void setValueBytes(byte[] newValueBytes, ASN1 root) {
        this.checkChangeEnabled();
        if (this.valueBytes == newValueBytes) {
            return;
        }
        if (this.valueBytes == null || newValueBytes == null || !Arrays.equals(this.valueBytes, newValueBytes)) {
            this.valueBytes = ByteUtil.copy(newValueBytes);
            this.lengthBytes = ASN1Util.getLengthBytes(this.valueBytes);
            if (!CollectionUtil.isNullOrEmpty(this.childElementList)) {
                this.childElementList.clear();
            }
            this.childElementList = null;
            this.getEncoded();
            try {
                this.getChildElementListInt();
            }
            catch (Exception e) {
                LOG.debug((Object)"ignored error at ASN.1 setValueBytes", (Throwable)e);
            }
            this.update();
            this.setChanged(root);
        }
    }

    private synchronized void setChanged(ASN1 root) {
        if (root != null) {
            root.setChanged(true);
            root.getEncoded();
        } else {
            this.setChanged(true);
            this.getEncoded();
        }
    }

    public final synchronized boolean isChanged() {
        boolean result;
        block4: {
            result = this.changed;
            if (result) break block4;
            List<ASN1> childList = null;
            try {
                childList = this.getChildElementList();
            }
            catch (IOException | NullPointerException e) {
                return true;
            }
            if (!CollectionUtil.isNullOrEmpty(this.childElementList)) {
                for (ASN1 child : childList) {
                    if (result |= child.isChanged()) break;
                }
            }
        }
        return result;
    }

    public synchronized byte[] getEncoded() {
        byte[] result = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            baos.write(this.dTagBytes);
            if (this.isChanged()) {
                if (!CollectionUtil.isNullOrEmpty(this.childElementList)) {
                    ByteArrayOutputStream cbaos = new ByteArrayOutputStream();
                    for (ASN1 child : this.childElementList) {
                        cbaos.write(child.getEncoded());
                    }
                    cbaos.flush();
                    cbaos.close();
                    this.valueBytes = cbaos.toByteArray();
                    this.lengthBytes = ASN1Util.getLengthBytes(this.valueBytes);
                    this.update();
                } else {
                    this.lengthBytes = ASN1Util.getLengthBytes(this.valueBytes);
                }
            }
            baos.write(this.lengthBytes);
            if (this.valueBytes != null && this.valueBytes.length > 0) {
                baos.write(this.valueBytes);
            }
            if (this.lengthBytes.length == 1 && this.lengthBytes[0] == -128) {
                baos.write(ASN1Constants.EOC_ASN1.getEncoded());
            }
            this.changed = false;
            result = baos.toByteArray();
        }
        catch (IOException e) {
            LOG.debug((Object)"encoding ASN.1 failed", (Throwable)e);
            LOG.debug((Object)"ignored error at flushing/closing ByteArrayOutputStream", (Throwable)e);
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ASN1)) {
            return false;
        }
        ASN1 friendlyASN1Value = (ASN1)object;
        return Arrays.equals(this.getEncoded(), friendlyASN1Value.getEncoded());
    }

    private String toStringClass() {
        Object result = super.toString();
        result = this.getClass().getName() + ((String)result).substring(((String)result).indexOf(64));
        return result;
    }

    public String toString() {
        return this.toString(ASN1Constants.FULL_FORMAT);
    }

    public String toString(boolean format) {
        return this.toString("", "", format);
    }

    public String dump() {
        return this.toString("", "", ASN1Constants.DUMP_FORMAT);
    }

    public String getType() {
        return ASN1Util.getType(this);
    }

    public String getValueAsString() {
        return ASN1Util.getValueAsString(this);
    }

    protected String toString(String indent1, String indent2, Boolean format) {
        return this.toString(indent1, indent2, format, 0);
    }

    protected String toString(String indent1, String indent2, Boolean format, int depth) {
        StringBuilder builder = new StringBuilder();
        if (format == ASN1Constants.FULL_FORMAT) {
            this.toStringFullFormat(indent1, indent2, builder);
        } else if (format == ASN1Constants.DUMP_FORMAT) {
            this.toStringDumpFormat(indent1, indent2, format, depth, builder);
        } else {
            this.toStringDefaultFormat(indent1, builder);
        }
        return builder.toString();
    }

    private void toStringDefaultFormat(String indent1, StringBuilder builder) {
        builder.append(indent1 + this.toStringClass());
        builder.append("(Tag: 0x" + HexUtil.hexify(this.getTag()));
        builder.append(", DTag: 0x" + HexUtil.hexify(this.getDTag()));
        builder.append(", Length: " + this.getLength());
        builder.append(", Encoded-Length: " + this.size());
        try {
            builder.append(", ChildElements: " + this.getChildElements().length);
        }
        catch (IOException e) {
            LOG.debug((Object)"ignored error at ASN.1 toString adding child length", (Throwable)e);
        }
        builder.append(")");
    }

    private void toStringDumpFormat(String indent1, String indent2, Boolean format, int depth, StringBuilder builder) {
        builder.append(indent1 + (depth == 0 ? "ASN.1-" : "") + this.getType());
        builder.append("(Tag: 0x" + HexUtil.hexify(this.getDTag()));
        builder.append(", Length: " + this.getLength());
        try {
            String value;
            ASN1[] children = this.getChildElements();
            if (children.length > 0) {
                builder.append(", ChildElements: " + children.length);
            }
            builder.append((String)((value = this.getValueAsString()) == null || value.isEmpty() ? ")\n" : "): " + value + "\n"));
            String childIndent1 = "--" + indent1;
            String childIndent2 = "--" + indent2;
            for (ASN1 child : children) {
                builder.append(child.toString(childIndent1, childIndent2, format, depth + 1));
            }
        }
        catch (IOException e) {
            builder.append(")\ndump of children failed: " + e.getMessage());
        }
    }

    private void toStringFullFormat(String indent1, String indent2, StringBuilder builder) {
        builder.append(indent1 + this.toStringClass());
        builder.append("\n" + indent1 + indent2 + "-    Tag:\n");
        ASN1Util.appendBytes(builder, indent1 + indent2, ASN1Util.extractTag(this.dTagBytes).toByteArray());
        builder.append("\n" + indent1 + indent2 + "-   DTag:\n");
        ASN1Util.appendBytes(builder, indent1 + indent2, this.dTagBytes);
        builder.append("\n" + indent1 + indent2 + "- Length:\n");
        ASN1Util.appendBytes(builder, indent1 + indent2, this.lengthBytes);
        builder.append("\n" + indent1 + indent2 + "-  Value:\n");
        int i = 0;
        while (i * 16 < this.valueBytes.length) {
            ASN1Util.appendBytes(builder, indent1 + indent2, ByteUtil.subbytes(this.valueBytes, i * 16, Math.min((i + 1) * 16, this.valueBytes.length)));
            builder.append("\n");
            ++i;
        }
    }

    public ASN1 getChildElementByPath(ASN1Path path) throws IOException {
        AssertUtil.notNull(path, "path");
        ArrayList<ASN1Path> partList = new ArrayList<ASN1Path>();
        ASN1Path rootPart = this.moveToRoot(path, partList);
        if (!this.getDTag().equals(rootPart.getTag())) {
            return null;
        }
        ASN1 tmp = this;
        for (ASN1Path p : partList) {
            ASN1[] children = tmp.getChildElementsByDTag(p.getTag());
            if (children == null || children.length <= p.getIndex()) {
                return null;
            }
            tmp = p.getFilter() == null ? children[p.getIndex()] : this.findElementsWithFilter(p, children);
            if (tmp != null) continue;
            return null;
        }
        Class<? extends ASN1Encoder> encoderClass = path.getEncoderClass();
        if (encoderClass != null) {
            tmp = path.getASN1(tmp);
        }
        return tmp;
    }

    private ASN1 findElementsWithFilter(ASN1Path p, ASN1[] children) {
        ASN1 tmp = null;
        Filter<ASN1> filter = p.getFilter();
        for (int i = 0; i < children.length; ++i) {
            if (!filter.accept(children[i])) continue;
            tmp = children[i];
            break;
        }
        return tmp;
    }

    private ASN1Path moveToRoot(ASN1Path path, List<ASN1Path> partList) {
        ASN1Path rootPart = path;
        while (rootPart.getParent() != null) {
            partList.add(0, rootPart);
            rootPart = rootPart.getParent();
        }
        return rootPart;
    }

    @Override
    public ASN1 decode(byte[] bytes) throws IOException {
        AssertUtil.notNullOrEmpty(bytes, "bytes");
        ASN1 asn1 = new ASN1(bytes);
        return this.decode(asn1);
    }

    @Override
    public ASN1 decode(ASN1 asn1) {
        this.checkChangeEnabled();
        AssertUtil.notNull(asn1, "ASN.1");
        if (!asn1.getClass().isAssignableFrom(this.getClass())) {
            throw new IllegalArgumentException("incompatible ASN1.object");
        }
        this.copy(asn1);
        return this;
    }

    protected void copy(ASN1 asn1) {
        this.checkChangeEnabled();
        AssertUtil.notNull(asn1, "ASN.1");
        this.dTagBytes = ByteUtil.copy(asn1.dTagBytes);
        this.lengthBytes = ByteUtil.copy(asn1.lengthBytes);
        this.valueBytes = ByteUtil.copy(asn1.valueBytes);
        this.childElementList = new ArrayList<ASN1>();
        try {
            List<ASN1> copyList = asn1.getChildElementList();
            if (!CollectionUtil.isNullOrEmpty(copyList)) {
                this.addChildElements(copyList, null);
            }
        }
        catch (IOException e) {
            LOG.debug((Object)"ignored error at ASN.1 copy", (Throwable)e);
        }
        this.updateInt();
    }

    private void updateInt() {
        try {
            this.childElementList = this.getChildElementListInt();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("copy failed: " + ioe.getMessage(), ioe);
        }
        this.update();
    }

    protected void update() {
    }

    public Integer valueAsNumber() {
        Integer result = null;
        result = !ArrayUtil.isNullOrEmpty(this.valueBytes) ? Integer.valueOf(new BigInteger(this.valueBytes).intValue()) : Integer.valueOf(0);
        return result;
    }

    private void checkChangeEnabled() {
        if (!this.changeEnabled) {
            throw new IllegalStateException("change not enabled");
        }
    }

    public final synchronized boolean isChangeEnabled() {
        return this.changeEnabled;
    }

    public final synchronized void setChangeEnabled(boolean newChangeEnabled) {
        if (this.immutable) {
            throw new UnsupportedOperationException("changing not supported for this immutable ASN.1");
        }
        this.changeEnabled = newChangeEnabled;
        try {
            List<ASN1> childList = this.getChildElementListInt();
            if (!CollectionUtil.isNullOrEmpty(childList)) {
                for (ASN1 child : childList) {
                    child.setChangeEnabled(newChangeEnabled);
                }
            }
        }
        catch (IOException e) {
            LOG.debug((Object)"ignored error at ASN.1 setChangeEnabled", (Throwable)e);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }
}

