/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.ClassUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public final class TypeInstanceCountManager {
    public static final int DEFAULT_LIMIT = 1;
    public static final Integer LIMIT_NONE = 0;
    private Map<Class<?>, Integer> mapTypeInstanceCount = new LinkedHashMap();
    private static TypeInstanceCountManager singleton = null;

    private TypeInstanceCountManager() {
    }

    public static synchronized TypeInstanceCountManager getManager() {
        if (singleton == null) {
            singleton = new TypeInstanceCountManager();
        }
        return singleton;
    }

    public synchronized void setInstanceLimit(Class<?> typeClass, Integer count) throws IllegalArgumentException {
        if (count == null) {
            this.mapTypeInstanceCount.remove(typeClass);
            return;
        }
        int countValue = count;
        if (countValue < LIMIT_NONE) {
            throw new IllegalArgumentException("count must be greater than " + LIMIT_NONE + " (limit none '" + LIMIT_NONE + "' indicate unlimited count of instances)");
        }
        this.mapTypeInstanceCount.put(typeClass, count);
    }

    public int getInstanceLimit(Class<?> typeClass) {
        if (typeClass == null) {
            return 1;
        }
        Integer mapInstanceCount = null;
        Class<?> lCurrentClass = typeClass;
        do {
            if ((mapInstanceCount = this.mapTypeInstanceCount.get(lCurrentClass)) == null) continue;
            return mapInstanceCount;
        } while (!Object.class.equals(lCurrentClass = lCurrentClass.getSuperclass()) && lCurrentClass != null);
        for (Class<?> interfaceClass : ClassUtil.getAllInterfaces(typeClass)) {
            mapInstanceCount = this.mapTypeInstanceCount.get(interfaceClass);
            if (mapInstanceCount == null) continue;
            return mapInstanceCount;
        }
        return 1;
    }

    public synchronized void reset() {
        this.mapTypeInstanceCount.clear();
    }
}

