/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.CallableExecutor;
import de.bos_bremen.common.ObjectUtil;
import de.bos_bremen.common.RunnableExecutor;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public final class ThreadUtil {
    public static final Logger LOG = Logger.getLogger(ThreadUtil.class);
    private static final int WAIT_DELAY = 10;
    private static final int IDX_CALLER = 3;
    private static final int MODE_CALLER_METHODNAME = 0;
    private static final int MODE_CALLER_CLASSNAME = 1;
    private static final int MODE_CALLER_SIMPLE_CLASSNAME = 2;

    private ThreadUtil() {
    }

    public static void join(Thread thread, long millis) throws IllegalArgumentException {
        ThreadUtil.checkJoinArguments(thread, millis);
        ThreadUtil.stableJoin(thread, millis);
    }

    public static void classicJoin(Thread thread, long millis) {
        ThreadUtil.checkJoinArguments(thread, millis);
        try {
            thread.join(millis);
        }
        catch (InterruptedException e) {
            LOG.debug((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stableJoin(Thread thread, long millis) throws IllegalArgumentException {
        ThreadUtil.checkJoinArguments(thread, millis);
        long lmillis = millis;
        Object o = new Object();
        if (lmillis == 0L) {
            while (thread.isAlive()) {
                Object object = o;
                synchronized (object) {
                    try {
                        o.wait(10L);
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)e);
                    }
                }
            }
        } else {
            for (int n = (int)(lmillis += 10L) / 10; n >= 0 && thread.isAlive(); --n) {
                Object object = o;
                synchronized (object) {
                    try {
                        o.wait(10L);
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)e);
                    }
                    continue;
                }
            }
        }
    }

    private static void checkJoinArguments(Thread thread, long millis) {
        AssertUtil.notNull(thread, "Thread");
        AssertUtil.zeroOrPositive(millis, "milliseconds");
        AssertUtil.isTrue(thread.isAlive(), "thread alive");
    }

    public static String getCallerMethodName() throws IllegalArgumentException {
        return ThreadUtil.getCallerMethodName(1);
    }

    public static String getCallerMethodName(int offset) throws IllegalArgumentException {
        ThreadUtil.checkOffset(offset);
        return ThreadUtil.getCallerInformation(0, offset + 3);
    }

    public static String getCallerClassName() throws IllegalArgumentException {
        return ThreadUtil.getCallerClassName(1);
    }

    public static String getCallerClassName(int offset) throws IllegalArgumentException {
        ThreadUtil.checkOffset(offset);
        return ThreadUtil.getCallerInformation(1, offset + 3);
    }

    public static String getCallerSimpleClassName() throws IllegalArgumentException {
        return ThreadUtil.getCallerSimpleClassName(1);
    }

    public static String getCallerSimpleClassName(int offset) throws IllegalArgumentException {
        ThreadUtil.checkOffset(offset);
        return ThreadUtil.getCallerInformation(2, offset + 3);
    }

    private static void checkOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("positive offset permitted only");
        }
    }

    private static String getCallerInformation(int mode, int level) throws IllegalArgumentException {
        StackTraceElement[] traceElements = Thread.currentThread().getStackTrace();
        if (traceElements.length <= level) {
            throw new IllegalArgumentException("not possible to receive caller information, stack does not contain enough elements");
        }
        String result = traceElements[level].toString();
        result = result.substring(0, result.indexOf("("));
        switch (mode) {
            case 2: {
                result = result.substring(0, result.lastIndexOf("."));
                result = result.substring(result.lastIndexOf(".") + 1);
                if (result == null || !result.contains("$")) break;
                result = result.substring(result.lastIndexOf("$") + 1);
                break;
            }
            case 1: {
                result = result.substring(0, result.lastIndexOf("."));
                break;
            }
            case 0: {
                result = result.substring(result.lastIndexOf(".") + 1);
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X extends Throwable> void syncExec(Runnable runnable, Integer timeout) throws IllegalArgumentException, X {
        AssertUtil.notNull(runnable, "runnable");
        Integer tmp = timeout;
        if (ObjectUtil.notNull(timeout)) {
            AssertUtil.zeroOrPositive(timeout, "timeout");
        } else {
            tmp = 0;
        }
        int waitTimeout = tmp;
        Object syncStart = new Object();
        Object syncEnd = new Object();
        RunnableExecutor runnableExecutor = new RunnableExecutor(runnable, syncStart, syncEnd);
        Thread threadExecutor = new Thread(runnableExecutor, "SyncExecRunnableThread");
        threadExecutor.start();
        while (threadExecutor.getState() != Thread.State.WAITING) {
            ThreadUtil.delay();
        }
        boolean success = false;
        try {
            try {
                Object object = syncEnd;
                synchronized (object) {
                    Object object2 = syncStart;
                    synchronized (object2) {
                        syncStart.notify();
                    }
                    syncEnd.wait(waitTimeout);
                }
            }
            finally {
                if (threadExecutor.getState() != Thread.State.TERMINATED && threadExecutor.isAlive() && !threadExecutor.isInterrupted()) {
                    threadExecutor.interrupt();
                    threadExecutor.stop();
                } else {
                    success = true;
                }
            }
        }
        catch (InterruptedException e) {
            LOG.debug((Object)e);
        }
        if (!success && ObjectUtil.notNull(runnableExecutor.getThrowable())) {
            throw runnableExecutor.getThrowable();
        }
    }

    private static void delay() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, X extends Throwable> T syncExec(Callable<T> callable, Integer timeout) throws IllegalArgumentException, X {
        AssertUtil.notNull(callable, "callable");
        Integer tmp = timeout;
        if (ObjectUtil.notNull(timeout)) {
            AssertUtil.zeroOrPositive(timeout, "timeout");
        } else {
            tmp = 0;
        }
        int waitTimeout = tmp;
        Object syncStart = new Object();
        Object syncEnd = new Object();
        CallableExecutor callableExecutor = new CallableExecutor(callable, syncStart, syncEnd);
        Thread threadExecutor = new Thread(callableExecutor, "SyncExecRunnableThread");
        threadExecutor.start();
        while (threadExecutor.getState() != Thread.State.WAITING) {
            ThreadUtil.delay();
        }
        boolean success = false;
        try {
            try {
                Object object = syncEnd;
                synchronized (object) {
                    Object object2 = syncStart;
                    synchronized (object2) {
                        syncStart.notify();
                    }
                    syncEnd.wait(waitTimeout);
                }
            }
            finally {
                if (threadExecutor.getState() != Thread.State.TERMINATED) {
                    threadExecutor.interrupt();
                    threadExecutor.stop();
                    if (!callableExecutor.isFinished()) {
                        callableExecutor.finish();
                    }
                } else {
                    success = true;
                }
            }
        }
        catch (InterruptedException e) {
            LOG.debug((Object)e);
        }
        if (!success && ObjectUtil.notNull(callableExecutor.getThrowable())) {
            throw callableExecutor.getThrowable();
        }
        List<T> resultList = callableExecutor.getResultList();
        T result = !resultList.isEmpty() ? (T)resultList.get(0) : null;
        return result;
    }
}

