/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import java.io.ByteArrayOutputStream;
import java.util.Formatter;
import java.util.Locale;

public final class StringUtil {
    public static final String MESSAGE_IS_EMPTY_FAILED_STRING_NULL = "String not permitted as null";

    private StringUtil() {
    }

    public static boolean isEmpty(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException(MESSAGE_IS_EMPTY_FAILED_STRING_NULL);
        }
        return s.length() == 0;
    }

    public static boolean notEmpty(String s) throws IllegalArgumentException {
        return !StringUtil.isEmpty(s);
    }

    public static boolean isNull(String s) {
        return s == null;
    }

    public static boolean notNull(String s) {
        return !StringUtil.isNull(s);
    }

    public static boolean isNullOrEmpty(String s) {
        return StringUtil.isNull(s) || StringUtil.isEmpty(s);
    }

    public static boolean notNullOrEmpty(String s) {
        return !StringUtil.isNullOrEmpty(s);
    }

    public static String format(String format, Object ... args) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Formatter f = new Formatter(baos);
        f.format(format, args);
        f.close();
        return new String(baos.toByteArray());
    }

    public static String format(Locale l, String format, Object ... args) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Formatter f = new Formatter(baos);
        f.format(l, format, args);
        f.close();
        return new String(baos.toByteArray());
    }
}

