/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.AssertUtil;
import org.apache.log4j.Logger;

public class RunnableExecutor<X extends Throwable>
implements Runnable {
    public static final Logger LOG = Logger.getLogger(RunnableExecutor.class);
    private final Object syncStart;
    private final Object syncEnd;
    private final Runnable runnable;
    private X throwable;
    private volatile boolean finished = false;

    public RunnableExecutor(Runnable runnable, Object syncStart, Object syncEnd) throws IllegalArgumentException {
        AssertUtil.notNull(runnable, "runnable");
        AssertUtil.notNull(syncStart, "syncStart");
        AssertUtil.notNull(syncEnd, "syncStart");
        this.runnable = runnable;
        this.syncStart = syncStart;
        this.syncEnd = syncEnd;
        this.throwable = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.syncStart;
        synchronized (object) {
            try {
                this.syncStart.wait(0L);
                this.runnable.run();
            }
            catch (ThreadDeath t) {
                LOG.debug((Object)t);
            }
            catch (Throwable t) {
                this.throwable = t;
            }
            finally {
                Object t = this.syncEnd;
                synchronized (t) {
                    this.finished = true;
                    this.syncEnd.notify();
                }
            }
        }
    }

    public X getThrowable() {
        return this.finished ? (X)this.throwable : null;
    }
}

