/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ClassUtil;
import de.bos_bremen.common.CollectionUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;

public final class ProxyUtil {
    public static final String METHOD_NAME_PREFIX_SETTER = "set";

    public static <T> T getProxy(Class<T> interfaceClass, final T instance) throws IllegalArgumentException {
        AssertUtil.notNull(interfaceClass, "interface class");
        AssertUtil.notNull(instance, "instance");
        ProxyUtil.checkInterfaceClass(interfaceClass);
        Object p = Proxy.newProxyInstance(instance.getClass().getClassLoader(), instance.getClass().getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object notUsedInstance, Method method, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
                return ProxyUtil.invokeInt(instance, method, parameters);
            }
        });
        return interfaceClass.cast(p);
    }

    static <T> Object invokeInt(T instance, Method method, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        try {
            return method.invoke(instance, parameters);
        }
        catch (InvocationTargetException e) {
            if (RuntimeException.class.isInstance(e.getCause())) {
                throw (RuntimeException)RuntimeException.class.cast(e.getCause());
            }
            throw e;
        }
    }

    public static <T> T getUnmodifableProxy(Class<T> interfaceClass, final T instance) throws IllegalArgumentException {
        AssertUtil.notNull(interfaceClass, "interface class");
        AssertUtil.notNull(instance, "instance");
        ProxyUtil.checkInterfaceClass(interfaceClass);
        Object p = Proxy.newProxyInstance(instance.getClass().getClassLoader(), instance.getClass().getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object arg0, Method method, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
                if (method.getName().startsWith(ProxyUtil.METHOD_NAME_PREFIX_SETTER)) {
                    throw new UnsupportedOperationException("unmodifiable proxy instance can not be changed");
                }
                return ProxyUtil.invokeInt(instance, method, parameters);
            }
        });
        return interfaceClass.cast(p);
    }

    private static <T> void checkInterfaceClass(Class<T> interfaceClass) throws IllegalArgumentException {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("proxy only can be created for an interface");
        }
        List<Class<?>> listInterfaces = ClassUtil.getAllInterfaces(interfaceClass);
        if (CollectionUtil.notNullOrEmpty(listInterfaces)) {
            for (Class<?> intClass : listInterfaces) {
                for (Method m : intClass.getMethods()) {
                    List<Class<?>> listExceptions = Arrays.asList(m.getExceptionTypes());
                    boolean allRuntimeExceptions = true;
                    if (CollectionUtil.notNullOrEmpty(listExceptions)) {
                        for (Class<?> exceptionClass : listExceptions) {
                            if (RuntimeException.class.isAssignableFrom(exceptionClass)) continue;
                            allRuntimeExceptions = false;
                            break;
                        }
                    }
                    if (allRuntimeExceptions || listExceptions.contains(InvocationTargetException.class)) continue;
                    throw new IllegalArgumentException("every method defining Exceptions that are not RuntimeException must define also InvocationTargetException to work correctly as proxy, incorrect interface '" + intClass + "' at method '" + m.getName() + "(" + Arrays.asList(m.getParameterTypes()) + ") throws " + listExceptions);
                }
            }
        }
    }

    private ProxyUtil() {
    }
}

