/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.AssertUtil;
import java.util.Comparator;

public final class ObjectUtil {
    public static final int COMPARE_RESULT_FIRST_EQUAL_TO_SECOND = 0;
    public static final int COMPARE_RESULT_FIRST_GREATER_SECOND = 1;
    public static final int COMPARE_RESULT_FIRST_LESS_SECOND = -1;
    public static final EqualsMode DEFAULT_EQUALS_MODE = EqualsMode.BOTH;

    private ObjectUtil() {
    }

    public static boolean isNull(Object o) {
        return ObjectUtil.isEqualsByReference(o, null);
    }

    public static boolean notNull(Object o) {
        return ObjectUtil.notEqualsByReference(o, null);
    }

    public static boolean notEquals(Object o1, Object o2) {
        return !ObjectUtil.isEquals(o1, o2);
    }

    public static boolean isEquals(Object o1, Object o2) {
        return ObjectUtil.isEquals(o1, o2, DEFAULT_EQUALS_MODE, null);
    }

    public static boolean notEquals(Object o1, Object o2, EqualsMode equalsMode, Comparator<Object> comparator) {
        return !ObjectUtil.isEquals(o1, o2, equalsMode, comparator);
    }

    public static boolean isEquals(Object o1, Object o2, EqualsMode equalsMode, Comparator<Object> comparator) {
        EqualsMode lEqualsMode = equalsMode;
        if (ObjectUtil.isNull(lEqualsMode)) {
            lEqualsMode = DEFAULT_EQUALS_MODE;
        }
        boolean result = false;
        if (ObjectUtil.notEqualsByReference(o1, o2)) {
            if (ObjectUtil.notNull(o1) && ObjectUtil.notNull(o2)) {
                boolean bl = result = lEqualsMode.compare(o1, o2) == 0;
                if (!result && ObjectUtil.notNull(comparator)) {
                    result = comparator.compare(o1, o2) == 0;
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    public static boolean isEqualsByReference(Object o1, Object o2) {
        return o1 == o2;
    }

    public static boolean notEqualsByReference(Object o1, Object o2) {
        return o1 != o2;
    }

    public static enum EqualsMode implements Comparator<Object>
    {
        FIRST_SECOND(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.equals(o2) ? 0 : -1;
            }
        }),
        SECOND_FIRST(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o2.equals(o1) ? 0 : -1;
            }
        }),
        ANYONE(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.equals(o2) || o2.equals(o1) ? 0 : -1;
            }
        }),
        BOTH(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.equals(o2) && o2.equals(o1) ? 0 : -1;
            }
        });

        private Comparator<Object> comparator = null;

        private EqualsMode(Comparator<Object> comparator) {
            AssertUtil.notNull(comparator, "comparator");
            this.comparator = comparator;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int result = -1;
            if (ObjectUtil.notEqualsByReference(o1, o2) && ObjectUtil.notNull(o1) && ObjectUtil.notNull(o2)) {
                result = this.comparator.compare(o1, o2);
            }
            return result;
        }
    }
}

