/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.NumInfo;
import de.bos_bremen.common.NumInterval;
import de.bos_bremen.common.ObjectUtil;
import java.math.BigInteger;

public final class Numbers {
    private Numbers() {
    }

    public static <T extends Number> int compareTo(T a, T b) {
        boolean bNaN;
        int r = 0;
        boolean aInfinity = ObjectUtil.isEquals(NumInfo.UNKNOWN_INFINITY, a);
        boolean bInfinity = ObjectUtil.isEquals(NumInfo.UNKNOWN_INFINITY, b);
        boolean aNaN = !aInfinity && (ObjectUtil.isEquals(Float.valueOf(Float.NaN), a) || ObjectUtil.isEquals(Double.NaN, a));
        boolean bl = bNaN = !bInfinity && (ObjectUtil.isEquals(Float.valueOf(Float.NaN), b) || ObjectUtil.isEquals(Double.NaN, b));
        if (!aInfinity && !bInfinity) {
            r = ((Comparable)((Object)a)).compareTo(b);
            r = r > 0 ? 1 : (r < 0 ? -1 : 0);
        } else if (aInfinity && bInfinity) {
            r = 0;
        } else if (aInfinity) {
            r = 1;
        } else if (bInfinity) {
            r = -1;
        }
        if (aInfinity && bNaN || aNaN && bInfinity) {
            r *= -1;
        }
        return r;
    }

    public static <T extends Number> boolean isLess(T a, T b) {
        int c = Numbers.compareTo(a, b);
        return c == -1;
    }

    public static <T extends Number> boolean isLessEquals(T a, T b) throws IllegalArgumentException {
        int c = Numbers.compareTo(a, b);
        return c == -1 || c == 0;
    }

    public static <T extends Number> boolean isEquals(T a, T b) throws IllegalArgumentException {
        int c = Numbers.compareTo(a, b);
        return c == 0;
    }

    public static <T extends Number> boolean notEquals(T a, T b) throws IllegalArgumentException {
        return !Numbers.isEquals(a, b);
    }

    public static <T extends Number> boolean isGreaterEquals(T a, T b) throws IllegalArgumentException {
        int c = Numbers.compareTo(a, b);
        return c == 1 || c == 0;
    }

    public static <T extends Number> boolean isGreater(T a, T b) throws IllegalArgumentException {
        int c = Numbers.compareTo(a, b);
        return c == 1;
    }

    public static <T extends Number> boolean isNegative(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return true;
        }
        return Numbers.isLess(value, Numbers.getNumInfo(value).getZero());
    }

    public static <T extends Number> boolean isZeroOrNegative(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return true;
        }
        return Numbers.isLessEquals(value, Numbers.getNumInfo(value).getZero());
    }

    public static <T extends Number> boolean isZero(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return false;
        }
        return Numbers.isEquals(value, Numbers.getNumInfo(value).getZero());
    }

    public static <T extends Number> boolean notZero(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return true;
        }
        return !Numbers.isEquals(value, Numbers.getNumInfo(value).getZero());
    }

    public static <T extends Number> boolean isZeroOrPositive(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return true;
        }
        return Numbers.isGreaterEquals(value, Numbers.getNumInfo(value).getZero());
    }

    public static <T extends Number> boolean isPositive(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return true;
        }
        return Numbers.isGreater(value, Numbers.getNumInfo(value).getZero());
    }

    public static <T extends Number> boolean isMin(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return false;
        }
        T min = Numbers.getNumInfo(value).getMin();
        return ObjectUtil.isEquals(value, min);
    }

    public static <T extends Number> boolean notMin(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return true;
        }
        T min = Numbers.getNumInfo(value).getMin();
        return ObjectUtil.notEquals(value, min);
    }

    public static <T extends Number> boolean isMax(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return false;
        }
        T max = Numbers.getNumInfo(value).getMax();
        return ObjectUtil.isEquals(value, max);
    }

    public static <T extends Number> boolean notMax(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return true;
        }
        T max = Numbers.getNumInfo(value).getMax();
        return ObjectUtil.notEquals(value, max);
    }

    public static <T extends Number> boolean isNaN(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_NAN)) {
            return true;
        }
        T nan = Numbers.getNumInfo(value).getNaN();
        return ObjectUtil.isEquals(value, nan);
    }

    public static <T extends Number> boolean notNaN(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_NAN)) {
            return false;
        }
        T nan = Numbers.getNumInfo(value).getNaN();
        return ObjectUtil.notEquals(value, nan);
    }

    public static <T extends Number> boolean isNegativeInfinity(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return true;
        }
        T infinity = Numbers.getNumInfo(value).getNegativeInfinity();
        return ObjectUtil.isEquals(value, infinity);
    }

    public static <T extends Number> boolean notNegativeInfinity(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return false;
        }
        T infinity = Numbers.getNumInfo(value).getNegativeInfinity();
        return ObjectUtil.notEquals(value, infinity);
    }

    public static <T extends Number> boolean isPositiveInfinity(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return true;
        }
        T infinity = Numbers.getNumInfo(value).getPositiveInfinity();
        return ObjectUtil.isEquals(value, infinity);
    }

    public static <T extends Number> boolean notPositiveInfinity(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return false;
        }
        T infinity = Numbers.getNumInfo(value).getPositiveInfinity();
        return ObjectUtil.notEquals(value, infinity);
    }

    public static <T extends Number> int getSize(T value) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return 0;
        }
        return Numbers.getNumInfo(value).getSize(value);
    }

    public static <T extends Number> NumInfo<T> getNumInfo(T value) throws IllegalArgumentException {
        if (ObjectUtil.isNull(value)) {
            return null;
        }
        Class<T> clazz = Numbers.cast(value.getClass());
        return NumInfo.Util.getNumInfo(clazz);
    }

    public static <T extends Number> T getMin(Class<T> typeClass) throws IllegalArgumentException {
        AssertUtil.notNull(typeClass, "type class");
        return NumInfo.Util.getNumInfo(typeClass).getMin();
    }

    public static <T extends Number> T getZero(Class<T> typeClass) throws IllegalArgumentException {
        AssertUtil.notNull(typeClass, "type class");
        return NumInfo.Util.getNumInfo(typeClass).getZero();
    }

    public static <T extends Number> T getMax(Class<T> typeClass) throws IllegalArgumentException {
        AssertUtil.notNull(typeClass, "type class");
        return NumInfo.Util.getNumInfo(typeClass).getMax();
    }

    public static <T extends Number> T getNegativeInfinity(Class<T> typeClass) throws IllegalArgumentException {
        AssertUtil.notNull(typeClass, "type class");
        return NumInfo.Util.getNumInfo(typeClass).getNegativeInfinity();
    }

    public static <T extends Number> T getPositiveInfinity(Class<T> typeClass) throws IllegalArgumentException {
        AssertUtil.notNull(typeClass, "type class");
        return NumInfo.Util.getNumInfo(typeClass).getPositiveInfinity();
    }

    public static <T extends Number> T getNaN(Class<T> typeClass) throws IllegalArgumentException {
        AssertUtil.notNull(typeClass, "type class");
        return NumInfo.Util.getNumInfo(typeClass).getNaN();
    }

    public static Integer to(Character value) {
        if (ObjectUtil.isEquals(NumInfo.UNKNOWN_INFINITY, value)) {
            return NumInfo.NEGATIVE_INFINITY_INTEGER;
        }
        return value.charValue();
    }

    public static Character to(Integer value) {
        if (ObjectUtil.isEquals(NumInfo.NEGATIVE_INFINITY_INTEGER, value)) {
            return (Character)Character.class.cast(null);
        }
        return Character.valueOf((char)value.intValue());
    }

    public static <T extends Number> T mod(T a, T b) throws IllegalArgumentException {
        AssertUtil.notNull(a, "a");
        AssertUtil.notNull(b, "b");
        T r = null;
        Class<T> c = Numbers.cast(a.getClass());
        if (Byte.class.isInstance(a)) {
            r = Numbers.cast((byte)((Byte)Byte.class.cast(a) % (Byte)Byte.class.cast(b)), c);
        } else if (Short.class.isInstance(a)) {
            r = Numbers.cast((short)((Short)Short.class.cast(a) % (Short)Short.class.cast(b)), c);
        } else if (Integer.class.isInstance(a)) {
            r = Numbers.cast((Integer)Integer.class.cast(a) % (Integer)Integer.class.cast(b), c);
        } else if (Long.class.isInstance(a)) {
            r = Numbers.cast((Long)Long.class.cast(a) % (Long)Long.class.cast(b), c);
        } else if (BigInteger.class.isInstance(a)) {
            r = Numbers.cast(((BigInteger)BigInteger.class.cast(a)).mod((BigInteger)BigInteger.class.cast(b)), c);
        } else if (Float.class.isInstance(a)) {
            r = Numbers.cast(Float.valueOf(((Float)Float.class.cast(a)).floatValue() % ((Float)Float.class.cast(b)).floatValue()), c);
        } else if (Double.class.isInstance(a)) {
            r = Numbers.cast((Double)Double.class.cast(a) % (Double)Double.class.cast(b), c);
        }
        return r;
    }

    public static <T extends Number> T subtract(T a, T b) throws IllegalArgumentException {
        AssertUtil.notNull(a, "a");
        AssertUtil.notNull(b, "b");
        T r = null;
        Class<T> c = Numbers.cast(a.getClass());
        if (Byte.class.isInstance(a)) {
            r = Numbers.cast((byte)((Byte)Byte.class.cast(a) - (Byte)Byte.class.cast(b)), c);
        } else if (Short.class.isInstance(a)) {
            r = Numbers.cast((short)((Short)Short.class.cast(a) - (Short)Short.class.cast(b)), c);
        } else if (Integer.class.isInstance(a)) {
            r = Numbers.cast((Integer)Integer.class.cast(a) - (Integer)Integer.class.cast(b), c);
        } else if (Long.class.isInstance(a)) {
            r = Numbers.cast((Long)Long.class.cast(a) - (Long)Long.class.cast(b), c);
        } else if (BigInteger.class.isInstance(a)) {
            r = Numbers.cast(((BigInteger)BigInteger.class.cast(a)).subtract((BigInteger)BigInteger.class.cast(b)), c);
        } else if (Float.class.isInstance(a)) {
            r = Numbers.cast(Float.valueOf(((Float)Float.class.cast(a)).floatValue() - ((Float)Float.class.cast(b)).floatValue()), c);
        } else if (Double.class.isInstance(a)) {
            r = Numbers.cast((Double)Double.class.cast(a) - (Double)Double.class.cast(b), c);
        }
        return r;
    }

    public static <T extends Number> T add(T a, T b) throws IllegalArgumentException {
        AssertUtil.notNull(a, "a");
        AssertUtil.notNull(b, "b");
        T r = null;
        Class<T> c = Numbers.cast(a.getClass());
        if (Byte.class.isInstance(a)) {
            r = Numbers.cast((byte)((Byte)Byte.class.cast(a) + (Byte)Byte.class.cast(b)), c);
        } else if (Short.class.isInstance(a)) {
            r = Numbers.cast((short)((Short)Short.class.cast(a) + (Short)Short.class.cast(b)), c);
        } else if (Integer.class.isInstance(a)) {
            r = Numbers.cast((Integer)Integer.class.cast(a) + (Integer)Integer.class.cast(b), c);
        } else if (Long.class.isInstance(a)) {
            r = Numbers.cast((Long)Long.class.cast(a) + (Long)Long.class.cast(b), c);
        } else if (BigInteger.class.isInstance(a)) {
            r = Numbers.cast(((BigInteger)BigInteger.class.cast(a)).add((BigInteger)BigInteger.class.cast(b)), c);
        } else if (Float.class.isInstance(a)) {
            r = Numbers.cast(Float.valueOf(((Float)Float.class.cast(a)).floatValue() + ((Float)Float.class.cast(b)).floatValue()), c);
        } else if (Double.class.isInstance(a)) {
            r = Numbers.cast((Double)Double.class.cast(a) + (Double)Double.class.cast(b), c);
        }
        return r;
    }

    public static <T extends Number> T multiply(T a, T b) throws IllegalArgumentException {
        AssertUtil.notNull(a, "a");
        AssertUtil.notNull(b, "b");
        T r = null;
        Class<T> c = Numbers.cast(a.getClass());
        if (Byte.class.isInstance(a)) {
            r = Numbers.cast((byte)((Byte)Byte.class.cast(a) * (Byte)Byte.class.cast(b)), c);
        } else if (Short.class.isInstance(a)) {
            r = Numbers.cast((short)((Short)Short.class.cast(a) * (Short)Short.class.cast(b)), c);
        } else if (Integer.class.isInstance(a)) {
            r = Numbers.cast((Integer)Integer.class.cast(a) * (Integer)Integer.class.cast(b), c);
        } else if (Long.class.isInstance(a)) {
            r = Numbers.cast((Long)Long.class.cast(a) * (Long)Long.class.cast(b), c);
        } else if (BigInteger.class.isInstance(a)) {
            r = Numbers.cast(((BigInteger)BigInteger.class.cast(a)).multiply((BigInteger)BigInteger.class.cast(b)), c);
        } else if (Float.class.isInstance(a)) {
            r = Numbers.cast(Float.valueOf(((Float)Float.class.cast(a)).floatValue() * ((Float)Float.class.cast(b)).floatValue()), c);
        } else if (Double.class.isInstance(a)) {
            r = Numbers.cast((Double)Double.class.cast(a) * (Double)Double.class.cast(b), c);
        }
        return r;
    }

    public static <T extends Number> T divide(T a, T b) throws IllegalArgumentException, ArithmeticException {
        AssertUtil.notNull(a, "a");
        AssertUtil.notNull(b, "b");
        T r = null;
        Class<T> c = Numbers.cast(a.getClass());
        if (Byte.class.isInstance(a)) {
            r = Numbers.cast((byte)((Byte)Byte.class.cast(a) / (Byte)Byte.class.cast(b)), c);
        } else if (Short.class.isInstance(a)) {
            r = Numbers.cast((short)((Short)Short.class.cast(a) / (Short)Short.class.cast(b)), c);
        } else if (Integer.class.isInstance(a)) {
            r = Numbers.cast((Integer)Integer.class.cast(a) / (Integer)Integer.class.cast(b), c);
        } else if (Long.class.isInstance(a)) {
            r = Numbers.cast((Long)Long.class.cast(a) / (Long)Long.class.cast(b), c);
        } else if (BigInteger.class.isInstance(a)) {
            r = Numbers.cast(((BigInteger)BigInteger.class.cast(a)).divide((BigInteger)BigInteger.class.cast(b)), c);
        } else if (Float.class.isInstance(a)) {
            r = Numbers.cast(Float.valueOf(((Float)Float.class.cast(a)).floatValue() / ((Float)Float.class.cast(b)).floatValue()), c);
        } else if (Double.class.isInstance(a)) {
            r = Numbers.cast((Double)Double.class.cast(a) / (Double)Double.class.cast(b), c);
        }
        return r;
    }

    public static <T extends Number> Class<T> cast(Class<? extends Number> typeClass) throws IllegalArgumentException {
        AssertUtil.notNull(typeClass, "number class");
        if (!Comparable.class.isAssignableFrom(typeClass)) {
            throw new IllegalArgumentException("Comparable must be assignable from type class");
        }
        return typeClass;
    }

    public static <T extends Number> T cast(Number number, Class<T> c) throws IllegalArgumentException {
        AssertUtil.notNull(c, null);
        if (ObjectUtil.notNull(number) && !c.isInstance(number)) {
            throw new IllegalArgumentException("Number must be an instance of " + c);
        }
        return (T)((Number)c.cast(number));
    }

    public static <T extends Number> T min(T a, T b) {
        if (Float.class.isInstance(a) && Numbers.isNaN(a) || Float.class.isInstance(b) && Numbers.isNaN(b)) {
            Class<T> c = Numbers.cast(a != null ? a.getClass() : b.getClass());
            return Numbers.cast(Float.valueOf(Float.NaN), c);
        }
        if (Double.class.isInstance(a) && Numbers.isNaN(a) || Double.class.isInstance(b) && Numbers.isNaN(b)) {
            Class<T> c = Numbers.cast(a != null ? a.getClass() : b.getClass());
            return Numbers.cast(Double.NaN, c);
        }
        int c = Numbers.compareTo(a, b);
        return c <= 0 ? a : b;
    }

    public static <T extends Number> T max(T a, T b) throws IllegalArgumentException {
        int c = Numbers.compareTo(a, b);
        return c >= 0 ? a : b;
    }

    public static <T extends Number> T abs(T value) throws IllegalArgumentException {
        if (ObjectUtil.isNull(value)) {
            return value;
        }
        Class<T> c = Numbers.cast(value.getClass());
        if (Byte.class.isInstance(value)) {
            return Numbers.cast((byte)Math.abs(((Byte)Byte.class.cast(value)).byteValue()), c);
        }
        if (Short.class.isInstance(value)) {
            return Numbers.cast((short)Math.abs(((Short)Short.class.cast(value)).shortValue()), c);
        }
        if (Integer.class.isInstance(value)) {
            return Numbers.cast(Math.abs((Integer)Integer.class.cast(value)), c);
        }
        if (Long.class.isInstance(value)) {
            return Numbers.cast(Math.abs((Long)Long.class.cast(value)), c);
        }
        if (BigInteger.class.isInstance(value)) {
            return Numbers.cast(((BigInteger)BigInteger.class.cast(value)).abs(), c);
        }
        if (Float.class.isInstance(value)) {
            return Numbers.cast(Float.valueOf(Math.abs(((Float)Float.class.cast(value)).floatValue())), c);
        }
        if (Double.class.isInstance(value)) {
            return Numbers.cast(Math.abs((Double)Double.class.cast(value)), c);
        }
        return value;
    }

    public static <T extends Number> int signum(T value) throws IllegalArgumentException {
        AssertUtil.notNull(value, "value");
        return Numbers.compareTo(value, Numbers.getNumInfo(value).getZero());
    }

    public static <T extends Number> boolean isInside(T value, NumInterval<T> interval) {
        if (ObjectUtil.isNull(interval) || ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return false;
        }
        return interval.isInside(value);
    }

    public static <T extends Number> boolean isOutside(T value, NumInterval<T> interval) {
        if (ObjectUtil.isNull(interval) || ObjectUtil.isEquals(value, NumInfo.UNKNOWN_INFINITY)) {
            return true;
        }
        return interval.isOutside(value);
    }
}

