/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.NumBound;
import de.bos_bremen.common.NumInfo;
import de.bos_bremen.common.Numbers;
import de.bos_bremen.common.ObjectUtil;
import de.bos_bremen.common.StringRepresentable;

public class NumInterval<T extends Number>
implements StringRepresentable {
    private NumBound<T> boundLower = null;
    private NumBound<T> boundUpper = null;

    public NumInterval(NumBound<T> lowerBound, NumBound<T> upperBound) throws IllegalArgumentException {
        AssertUtil.notNull(lowerBound, "left bound");
        AssertUtil.notNull(upperBound, "right bound");
        AssertUtil.lessEquals(lowerBound.getBoundValue(), upperBound.getBoundValue(), "bounds");
        if (this.checkBound(lowerBound, upperBound)) {
            throw new IllegalArgumentException("illegal combinations of bounds, lower bound: " + lowerBound + ", upper bound: " + upperBound);
        }
        if (Numbers.isEquals(lowerBound.getBoundValue(), upperBound.getBoundValue())) {
            AssertUtil.isTrue(lowerBound.isIncluded(), "lower bound value included");
            AssertUtil.isTrue(upperBound.isIncluded(), "upper bound value included");
        }
        this.boundLower = lowerBound;
        this.boundUpper = upperBound;
    }

    private boolean checkBound(NumBound<T> lowerBound, NumBound<T> upperBound) {
        if (ObjectUtil.isNull(lowerBound.getBoundValue()) && ObjectUtil.isNull(upperBound.getBoundValue())) {
            return true;
        }
        if (NumInfo.NEGATIVE_INFINITY_FLOAT.equals(lowerBound.getBoundValue()) && NumInfo.NEGATIVE_INFINITY_FLOAT.equals(upperBound.getBoundValue()) || NumInfo.POSITIVE_INFINITY_FLOAT.equals(lowerBound.getBoundValue()) && NumInfo.POSITIVE_INFINITY_FLOAT.equals(upperBound.getBoundValue())) {
            return true;
        }
        if (NumInfo.NEGATIVE_INFINITY_DOUBLE.equals(lowerBound.getBoundValue()) && NumInfo.NEGATIVE_INFINITY_DOUBLE.equals(upperBound.getBoundValue()) || NumInfo.POSITIVE_INFINITY_DOUBLE.equals(lowerBound.getBoundValue()) && NumInfo.POSITIVE_INFINITY_DOUBLE.equals(upperBound.getBoundValue())) {
            return true;
        }
        return NumInfo.POSITIVE_INFINITY_FLOAT.equals(lowerBound.getBoundValue()) && ObjectUtil.isNull(upperBound.getBoundValue()) || NumInfo.POSITIVE_INFINITY_DOUBLE.equals(lowerBound.getBoundValue()) && ObjectUtil.isNull(upperBound.getBoundValue());
    }

    public final NumBound<T> getLowerBound() {
        return this.boundLower;
    }

    public final NumBound<T> getUpperBound() {
        return this.boundUpper;
    }

    public final boolean isOpenLeft() {
        return this.boundLower.isExcluded();
    }

    public final boolean isOpenRight() {
        return this.boundUpper.isExcluded();
    }

    public final boolean isInside(T value) {
        boolean result = false;
        if (Numbers.notNegativeInfinity(value) && Numbers.notPositiveInfinity(value) && Numbers.notNaN(value)) {
            if (this.boundLower.isInfinity() && this.boundUpper.isInfinity()) {
                result = true;
            } else if (this.boundLower.isInfinity() && this.isOpenRight()) {
                result = Numbers.isLess(value, this.boundUpper.getBoundValue());
            } else if (this.boundLower.isInfinity() && !this.isOpenRight()) {
                result = Numbers.isLessEquals(value, this.boundUpper.getBoundValue());
            } else if (this.boundUpper.isInfinity() && this.isOpenLeft()) {
                result = Numbers.isGreater(value, this.boundLower.getBoundValue());
            } else if (this.boundUpper.isInfinity() && !this.isOpenLeft()) {
                result = Numbers.isGreaterEquals(value, this.boundLower.getBoundValue());
            } else if (this.isOpenLeft() && this.isOpenRight()) {
                result = Numbers.isGreater(value, this.boundLower.getBoundValue()) && Numbers.isLess(value, this.boundUpper.getBoundValue());
            } else if (!this.isOpenLeft() && this.isOpenRight()) {
                result = Numbers.isGreaterEquals(value, this.boundLower.getBoundValue()) && Numbers.isLess(value, this.boundUpper.getBoundValue());
            } else if (this.isOpenLeft() && !this.isOpenRight()) {
                result = Numbers.isGreater(value, this.boundLower.getBoundValue()) && Numbers.isLessEquals(value, this.boundUpper.getBoundValue());
            } else if (!this.isOpenLeft() && !this.isOpenRight()) {
                result = Numbers.isGreaterEquals(value, this.boundLower.getBoundValue()) && Numbers.isLessEquals(value, this.boundUpper.getBoundValue());
            }
        }
        return result;
    }

    public final boolean isOutside(T value) {
        return !this.isInside(value);
    }

    @Override
    public String toString() {
        return super.toString() + this.toSimpleString();
    }

    public String toSimpleString() {
        return (this.boundLower.isIncluded() ? "[" : "(") + this.boundLower + ", " + this.boundUpper + (this.boundUpper.isIncluded() ? "]" : ")");
    }
}

