/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ObjectUtil;
import de.bos_bremen.common.StringRepresentable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface NumInfo<T extends Number>
extends StringRepresentable {
    public static final int UNKNOWN_ZERO = 0;
    public static final Byte ZERO_BYTE = 0;
    public static final Short ZERO_SHORT = 0;
    public static final Integer ZERO_INTEGER = 0;
    public static final Long ZERO_LONG = 0L;
    public static final BigInteger ZERO_BIGINTEGER = BigInteger.ZERO;
    public static final Float ZERO_FLOAT = Float.valueOf(0.0f);
    public static final Double ZERO_DOUBLE = 0.0;
    public static final int UNKNOWN_SIZE = 0;
    public static final Number UNKNOWN_INFINITY = null;
    public static final Byte NEGATIVE_INFINITY_BYTE = (Byte)Byte.class.cast(UNKNOWN_INFINITY);
    public static final Short NEGATIVE_INFINITY_SHORT = (Short)Short.class.cast(UNKNOWN_INFINITY);
    public static final Integer NEGATIVE_INFINITY_INTEGER = (Integer)Integer.class.cast(UNKNOWN_INFINITY);
    public static final Long NEGATIVE_INFINITY_LONG = (Long)Long.class.cast(UNKNOWN_INFINITY);
    public static final BigInteger NEGATIVE_INFINITY_BIGINTEGER = (BigInteger)BigInteger.class.cast(UNKNOWN_INFINITY);
    public static final Float NEGATIVE_INFINITY_FLOAT = Float.valueOf(Float.NEGATIVE_INFINITY);
    public static final Double NEGATIVE_INFINITY_DOUBLE = Double.NEGATIVE_INFINITY;
    public static final Byte POSITIVE_INFINITY_BYTE = (Byte)Byte.class.cast(UNKNOWN_INFINITY);
    public static final Short POSITIVE_INFINITY_SHORT = (Short)Short.class.cast(UNKNOWN_INFINITY);
    public static final Integer POSITIVE_INFINITY_INTEGER = (Integer)Integer.class.cast(UNKNOWN_INFINITY);
    public static final Long POSITIVE_INFINITY_LONG = (Long)Long.class.cast(UNKNOWN_INFINITY);
    public static final BigInteger POSITIVE_INFINITY_BIGINTEGER = (BigInteger)BigInteger.class.cast(UNKNOWN_INFINITY);
    public static final Float POSITIVE_INFINITY_FLOAT = Float.valueOf(Float.POSITIVE_INFINITY);
    public static final Double POSITIVE_INFINITY_DOUBLE = Double.POSITIVE_INFINITY;
    public static final Number UNKNOWN_NAN = null;
    public static final Byte NAN_BYTE = (Byte)Byte.class.cast(UNKNOWN_NAN);
    public static final Short NAN_SHORT = (Short)Short.class.cast(UNKNOWN_NAN);
    public static final Integer NAN_INTEGER = (Integer)Integer.class.cast(UNKNOWN_NAN);
    public static final Long NAN_LONG = (Long)Long.class.cast(UNKNOWN_NAN);
    public static final BigInteger NAN_BIGINTEGER = (BigInteger)BigInteger.class.cast(UNKNOWN_NAN);
    public static final Float NAN_FLOAT = Float.valueOf(Float.NaN);
    public static final Double NAN_DOUBLE = Double.NaN;
    public static final Number UNKNOWN_MIN = null;
    public static final Byte MIN_BYTE = -128;
    public static final Short MIN_SHORT = Short.MIN_VALUE;
    public static final Integer MIN_INTEGER = Integer.MIN_VALUE;
    public static final Long MIN_LONG = Long.MIN_VALUE;
    public static final BigInteger MIN_BIGINTEGER = (BigInteger)BigInteger.class.cast(UNKNOWN_MIN);
    public static final Float MIN_FLOAT = Float.valueOf(Float.MIN_VALUE);
    public static final Double MIN_DOUBLE = Double.MIN_VALUE;
    public static final Number UNKNOWN_MAX = null;
    public static final Byte MAX_BYTE = 127;
    public static final Short MAX_SHORT = Short.MAX_VALUE;
    public static final Integer MAX_INTEGER = Integer.MAX_VALUE;
    public static final Long MAX_LONG = Long.MAX_VALUE;
    public static final BigInteger MAX_BIGINTEGER = (BigInteger)BigInteger.class.cast(UNKNOWN_MAX);
    public static final Float MAX_FLOAT = Float.valueOf(Float.MAX_VALUE);
    public static final Double MAX_DOUBLE = Double.MAX_VALUE;
    public static final NumInfo<Byte> BYTE = NumInfoImpl.CBYTE;
    public static final NumInfo<Short> SHORT = NumInfoImpl.CSHORT;
    public static final NumInfo<Integer> INTEGER = NumInfoImpl.CINTEGER;
    public static final NumInfo<Long> LONG = NumInfoImpl.CLONG;
    public static final NumInfo<BigInteger> BIGINTEGER = NumInfoImpl.CBIGINTEGER;
    public static final NumInfo<Float> FLOAT = NumInfoImpl.CFLOAT;
    public static final NumInfo<Double> DOUBLE = NumInfoImpl.CDOUBLE;

    public Class<T> getNumClass();

    public T getZero();

    public T getNegativeInfinity();

    public T getPositiveInfinity();

    public T getMax();

    public T getMin();

    public T getNaN();

    public int getSize(T var1);

    public static final class NumInfoImpl<T extends Number>
    implements NumInfo<T> {
        public static final NumInfo<Byte> CBYTE = new NumInfoImpl<Object>((Class<Object>)Byte.class, ZERO_BYTE, NEGATIVE_INFINITY_BYTE, NEGATIVE_INFINITY_BYTE, MIN_BYTE, MAX_BYTE, null, 8);
        public static final NumInfo<Short> CSHORT = new NumInfoImpl<Short>(Short.class, ZERO_SHORT, NEGATIVE_INFINITY_SHORT, NEGATIVE_INFINITY_SHORT, MIN_SHORT, MAX_SHORT, NAN_SHORT, 16);
        public static final NumInfo<Integer> CINTEGER = new NumInfoImpl<Integer>(Integer.class, ZERO_INTEGER, NEGATIVE_INFINITY_INTEGER, NEGATIVE_INFINITY_INTEGER, MIN_INTEGER, MAX_INTEGER, NAN_INTEGER, 32);
        public static final NumInfo<Long> CLONG = new NumInfoImpl<Long>(Long.class, ZERO_LONG, NEGATIVE_INFINITY_LONG, NEGATIVE_INFINITY_LONG, MIN_LONG, MAX_LONG, NAN_LONG, 64);
        public static final NumInfo<BigInteger> CBIGINTEGER = new NumInfoImpl<BigInteger>(BigInteger.class, ZERO_BIGINTEGER, NEGATIVE_INFINITY_BIGINTEGER, POSITIVE_INFINITY_BIGINTEGER, MIN_BIGINTEGER, MAX_BIGINTEGER, NAN_BIGINTEGER, 0);
        public static final NumInfo<Float> CFLOAT = new NumInfoImpl<Float>(Float.class, ZERO_FLOAT, NEGATIVE_INFINITY_FLOAT, POSITIVE_INFINITY_FLOAT, MIN_FLOAT, MAX_FLOAT, NAN_FLOAT, 32);
        public static final NumInfo<Double> CDOUBLE = new NumInfoImpl<Double>(Double.class, ZERO_DOUBLE, NEGATIVE_INFINITY_DOUBLE, POSITIVE_INFINITY_DOUBLE, MIN_DOUBLE, MAX_DOUBLE, NAN_DOUBLE, 64);
        static final List<NumInfo<?>> CLIST_NUM_INFO;
        private T zero = null;
        private T negativeInfinity = null;
        private T positiveInfinity = null;
        private T min = null;
        private T max = null;
        private T nan = null;
        private Class<T> numClass = null;
        private int size = 0;

        public static List<NumInfo<?>> values() {
            return CLIST_NUM_INFO;
        }

        private NumInfoImpl(Class<T> numClass, T zero, T negativeInfinity, T positiveInfinity, T min, T max, T nan, int size) {
            AssertUtil.notNull(numClass, "number class");
            AssertUtil.notNull(zero, "zero");
            AssertUtil.greaterEquals(size, 0, "size");
            this.numClass = numClass;
            this.zero = zero;
            this.negativeInfinity = negativeInfinity;
            this.positiveInfinity = positiveInfinity;
            this.min = min;
            this.max = max;
            this.nan = nan;
            this.size = size;
        }

        @Override
        public T getNegativeInfinity() {
            return this.negativeInfinity;
        }

        @Override
        public T getPositiveInfinity() {
            return this.positiveInfinity;
        }

        @Override
        public T getMin() {
            return this.min;
        }

        @Override
        public T getMax() {
            return this.max;
        }

        @Override
        public T getNaN() {
            return this.nan;
        }

        @Override
        public Class<T> getNumClass() {
            return this.numClass;
        }

        @Override
        public T getZero() {
            return this.zero;
        }

        @Override
        public int getSize(T value) {
            if (ObjectUtil.notNull(value) && BigInteger.class.equals(value.getClass())) {
                return ((BigInteger)BigInteger.class.cast(value)).toByteArray().length * 8;
            }
            return this.size;
        }

        @Override
        public String toString() {
            return super.toString() + " (Class: " + this.numClass + ", zero: " + this.zero + ", negative infinity: " + this.negativeInfinity + ", positive infinity: " + this.positiveInfinity + ", minimum: " + this.min + ", maximum: " + this.max + ", NaN: " + this.nan + ", size: " + this.size + ")";
        }

        static {
            ArrayList<NumInfo<Number>> tmp = new ArrayList<NumInfo<Number>>();
            tmp.add(CBYTE);
            tmp.add(CSHORT);
            tmp.add(CINTEGER);
            tmp.add(CLONG);
            tmp.add(CBIGINTEGER);
            tmp.add(CDOUBLE);
            tmp.add(CFLOAT);
            CLIST_NUM_INFO = Collections.unmodifiableList(tmp);
        }
    }

    public static final class Util {
        private Util() {
        }

        public static <T extends Number> NumInfo<T> getNumInfo(Class<T> typeClass) {
            AssertUtil.notNull(typeClass, "type class");
            for (NumInfo<?> ni : NumInfoImpl.CLIST_NUM_INFO) {
                if (!ni.getNumClass().equals(typeClass)) continue;
                return ni;
            }
            throw new IllegalArgumentException("unknown number type: " + typeClass);
        }
    }
}

