/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.NumInfo;
import de.bos_bremen.common.Numbers;
import de.bos_bremen.common.StringRepresentable;
import java.math.BigInteger;

public class NumBound<T extends Number>
implements StringRepresentable {
    public static final boolean INCLUDE = true;
    public static final boolean EXCLUDE = false;
    public static final NumBound<Byte> INFINITY_BOUND_BYTE = new NumBound<Byte>((Byte)NumInfo.UNKNOWN_INFINITY);
    public static final NumBound<Short> INFINITY_BOUND_SHORT = new NumBound<Short>((Short)NumInfo.UNKNOWN_INFINITY);
    public static final NumBound<Integer> INFINITY_BOUND_INTEGER = new NumBound<Integer>((Integer)NumInfo.UNKNOWN_INFINITY);
    public static final NumBound<Long> INFINITY_BOUND_LONG = new NumBound<Long>((Long)NumInfo.UNKNOWN_INFINITY);
    public static final NumBound<BigInteger> INFINITY_BOUND_BIGINTEGER = new NumBound<BigInteger>((BigInteger)NumInfo.UNKNOWN_INFINITY);
    public static final NumBound<Float> NEGATIVE_INFINITY_BOUND_FLOAT = new NumBound<Float>(NumInfo.NEGATIVE_INFINITY_FLOAT);
    public static final NumBound<Float> POSITIVE_INFINITY_BOUND_FLOAT = new NumBound<Float>(NumInfo.POSITIVE_INFINITY_FLOAT);
    public static final NumBound<Double> NEGATIVE_INFINITY_BOUND_DOUBLE = new NumBound<Double>(NumInfo.NEGATIVE_INFINITY_DOUBLE);
    public static final NumBound<Double> POSITIVE_INFINITY_BOUND_DOUBLE = new NumBound<Double>(NumInfo.POSITIVE_INFINITY_DOUBLE);
    public static final boolean DEFAULT_INCLUDE_EXCLUDE = true;
    private T bound = null;
    private boolean includeValue = true;
    private boolean infinity = false;

    public NumBound(T bound, boolean include) throws IllegalArgumentException {
        if (Double.class.isInstance(bound) || Float.class.isInstance(bound)) {
            AssertUtil.notNaN(bound, "bound");
        }
        if (Numbers.notPositiveInfinity(bound) && Numbers.notNegativeInfinity(bound)) {
            this.includeValue = include;
            this.infinity = false;
        } else {
            this.includeValue = false;
            this.infinity = true;
        }
        this.bound = bound;
    }

    public NumBound(T bound) {
        this(bound, true);
    }

    public T getBoundValue() {
        return this.bound;
    }

    public boolean isIncluded() {
        return this.includeValue;
    }

    public boolean isExcluded() {
        return !this.includeValue;
    }

    public boolean isInfinity() {
        return this.infinity;
    }

    @Override
    public String toString() {
        if (NumInfo.NEGATIVE_INFINITY_FLOAT.equals(this.bound) || NumInfo.NEGATIVE_INFINITY_DOUBLE.equals(this.bound)) {
            return "NEGATIVE INFINITY";
        }
        if (NumInfo.POSITIVE_INFINITY_FLOAT.equals(this.bound) || NumInfo.POSITIVE_INFINITY_DOUBLE.equals(this.bound)) {
            return "POSITIVE INFINITY";
        }
        return this.bound != NumInfo.UNKNOWN_INFINITY ? this.bound.toString() : "INFINITY";
    }
}

