/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.Numbers;
import de.bos_bremen.common.ObjectUtil;
import de.bos_bremen.common.TypeInstanceCountManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public final class ListUtil {
    public static final Logger LOG = Logger.getLogger(ListUtil.class);

    private ListUtil() {
    }

    public static List<Integer> toList(int[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (values.length > 0) {
            for (int value : values) {
                result.add(value);
            }
        }
        return result;
    }

    public static List<Long> toList(long[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        if (values.length > 0) {
            for (long value : values) {
                result.add(value);
            }
        }
        return result;
    }

    public static List<Byte> toList(byte[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<Byte> result = new ArrayList<Byte>();
        if (values.length > 0) {
            for (byte value : values) {
                result.add(value);
            }
        }
        return result;
    }

    public static List<Boolean> toList(boolean[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        if (values.length > 0) {
            for (boolean value : values) {
                result.add(value);
            }
        }
        return result;
    }

    public static List<Short> toList(short[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<Short> result = new ArrayList<Short>();
        if (values.length > 0) {
            for (short value : values) {
                result.add(value);
            }
        }
        return result;
    }

    public static List<Character> toList(char[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<Character> result = new ArrayList<Character>();
        if (values.length > 0) {
            for (char value : values) {
                result.add(Character.valueOf(value));
            }
        }
        return result;
    }

    public static List<Double> toList(double[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<Double> result = new ArrayList<Double>();
        if (values.length > 0) {
            for (double value : values) {
                result.add(value);
            }
        }
        return result;
    }

    public static List<Float> toList(float[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<Float> result = new ArrayList<Float>();
        if (values.length > 0) {
            for (float value : values) {
                result.add(Float.valueOf(value));
            }
        }
        return result;
    }

    public static <T> T[] toArray(List<T> valueList, Class<T[]> typeClass) throws IllegalArgumentException {
        if (CollectionUtil.isNull(valueList)) {
            return null;
        }
        AssertUtil.notNullArrayClassObject(typeClass, "type class");
        Class<?> tClass = typeClass.getComponentType();
        if (CollectionUtil.notEmpty(valueList)) {
            for (T value : valueList) {
                if (value == null || tClass.isInstance(value)) continue;
                throw new IllegalArgumentException("value of List not compatible with not type Class, value: " + value + " , class: " + tClass);
            }
        }
        T[] result = typeClass.cast(ArrayUtil.getArray(tClass, valueList.size()));
        return valueList.toArray(result);
    }

    public static <T> List<T> createUnmodifableCopy(List<T> list) {
        if (ObjectUtil.isNull(list)) {
            return null;
        }
        ArrayList<T> tmpList = new ArrayList<T>();
        if (!list.isEmpty()) {
            tmpList.addAll(list);
        }
        return Collections.unmodifiableList(tmpList);
    }

    public static <T> List<T> combine(List<T> ... lists) {
        if (ObjectUtil.isNull(lists) || ArrayUtil.isEmpty(lists) || Numbers.isEquals(1, lists.length) && ArrayUtil.containsNull(lists)) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        if (!ArrayUtil.isEmpty(lists)) {
            for (List<T> list : lists) {
                if (CollectionUtil.isNull(list)) continue;
                for (T t : list) {
                    if (result.contains(t)) continue;
                    result.add(t);
                }
            }
        }
        return result;
    }

    public static <T> List<T> createNewInstanceList(Class<? extends T>[] handlerClasses) {
        ArrayList result = new ArrayList();
        if (handlerClasses != null) {
            for (Class<? extends T> handlerClass : handlerClasses) {
                ListUtil.addNewInstance(result, handlerClass);
            }
        }
        return result;
    }

    public static <T> List<T> createNewInstanceList(Class<T> typeClass, Class<?>[] handlerClasses) {
        ArrayList result = new ArrayList();
        if (handlerClasses != null) {
            for (Class<?> handlerClass : handlerClasses) {
                int instanceCount = TypeInstanceCountManager.getManager().getInstanceLimit(handlerClass);
                for (int i = 0; i < instanceCount; ++i) {
                    ListUtil.addNewInstance(typeClass, result, handlerClass);
                }
            }
        }
        return result;
    }

    public static <T> void addNewInstance(Class<T> typeClass, List<T> handlerList, Class<?> handlerClass) {
        if (ObjectUtil.isNull(typeClass) || ObjectUtil.isNull(handlerClass) || CollectionUtil.isNull(handlerList)) {
            return;
        }
        try {
            if (typeClass.isAssignableFrom(handlerClass)) {
                T handler = typeClass.cast(handlerClass.newInstance());
                handlerList.add(handler);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
    }

    public static <T> void addNewInstance(List<T> handlerList, Class<? extends T> handlerClass) {
        if (ObjectUtil.isNull(handlerClass) || CollectionUtil.isNull(handlerList)) {
            return;
        }
        try {
            T handler = handlerClass.newInstance();
            handlerList.add(handler);
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
    }
}

