/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.constants.Constants;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class HexUtil {
    public static final String EMPTY_HEXSTRING = "";
    public static final String DEFAULT_INDENT = "";
    public static final int DEFAULT_LINE_SIZE = 16;

    private HexUtil() {
    }

    public static String dump(byte[] data) {
        return HexUtil.dump("", data, 16);
    }

    public static String dump(String indent, byte[] data, int lineSize) {
        if (lineSize < 1) {
            throw new IllegalArgumentException("size of line expected greater equals 1");
        }
        if (data == null || data.length == 0) {
            if (indent != null && indent.length() > 0) {
                return indent;
            }
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        Object lineBytes = "";
        Object lineASCII = "";
        char[] filler = new char[lineSize * 3];
        Arrays.fill(filler, " ".charAt(0));
        for (int i = 0; i <= data.length / lineSize; ++i) {
            lineASCII = "";
            lineBytes = "";
            if (indent != null && indent.length() > 0) {
                buffer.append(indent);
            }
            buffer.append(HexUtil.hexify(new byte[]{(byte)(count / 256)}));
            buffer.append(HexUtil.hexify(new byte[]{(byte)(count % 256)}));
            buffer.append(": ");
            for (int j = 0; i * lineSize + j < data.length && j < lineSize; ++j) {
                byte tmp = data[i * lineSize + j];
                lineBytes = (String)lineBytes + HexUtil.hexify(tmp) + " ";
                lineASCII = tmp >= 32 && tmp < 127 ? (String)lineASCII + new String(new byte[]{tmp}) : (String)lineASCII + new String(".");
            }
            buffer.append((String)lineBytes);
            buffer.append(String.copyValueOf(filler, 0, lineSize * 3 - ((String)lineBytes).length()));
            buffer.append("  " + (String)lineASCII + "\n");
            if ((count += lineSize) == data.length) break;
        }
        return buffer.toString();
    }

    public static String hexify(byte[] bytes) {
        return HexUtil.hexify(bytes, "");
    }

    public static String hexify(byte[] bytes, String separator) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        Object tmp = new BigInteger(1, bytes).toString(16);
        int l = bytes.length * 2 - ((String)tmp).length();
        while (l-- > 0) {
            tmp = "0" + (String)tmp;
        }
        if (separator == null || separator.length() == 0) {
            return tmp;
        }
        Object result = "";
        for (int i = 0; i < ((String)tmp).length(); i += 2) {
            result = (String)result + ((String)tmp).substring(i, i + 2) + separator;
        }
        result = ((String)result).substring(0, ((String)result).length() - separator.length());
        return result;
    }

    public static byte[] parse(String hexString) {
        int byteResultLength;
        int byteResultLengthDelta;
        if (hexString == null || hexString.length() == 0) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        String result = hexString;
        BigInteger resultBI = HexUtil.parseBigInteger(result = HexUtil.cleanString(result));
        byte[] resultBytes = resultBI.toByteArray();
        if (resultBytes.length >= 1 && resultBytes[0] == 0 && !result.startsWith("00") && resultBytes[1] < 0) {
            byte[] tmp = resultBytes;
            ByteBuffer bb = ByteBuffer.allocate(tmp.length - 1);
            bb.put(tmp, 1, tmp.length - 1);
            resultBytes = bb.array();
        }
        if ((byteResultLengthDelta = (byteResultLength = result.length() / 2) - resultBytes.length) > 0) {
            ByteBuffer bb = ByteBuffer.allocate(byteResultLength);
            byte[] tmp = new byte[byteResultLengthDelta];
            Arrays.fill(tmp, (byte)0);
            bb.put(tmp);
            bb.put(resultBytes);
            resultBytes = bb.array();
        }
        return resultBytes;
    }

    public static BigInteger parseBigInteger(String hexString) throws IllegalArgumentException {
        if (hexString == null || hexString.length() == 0) {
            return null;
        }
        String result = hexString;
        if ((result = HexUtil.cleanString(result)).length() % 2 == 1) {
            throw new IllegalArgumentException("String with hex representation expected as String with even length");
        }
        return new BigInteger(result, 16);
    }

    public static String cleanString(String src) {
        String result = src;
        result = result.replace(" ", "");
        result = result.replace("\n", "");
        result = result.replace("\r", "");
        return result;
    }

    public static String hexify(BigInteger bi) {
        if (bi == null) {
            return "";
        }
        return HexUtil.hexify(bi.toByteArray());
    }

    public static String hexify(byte value) {
        return HexUtil.hexify((long)value);
    }

    public static String hexify(Byte value) {
        return value == null ? "" : HexUtil.hexify((byte)value);
    }

    public static String hexify(short value) {
        return HexUtil.hexify((long)value);
    }

    public static String hexify(Short value) {
        return value == null ? "" : HexUtil.hexify((short)value);
    }

    public static String hexify(int value) {
        return HexUtil.hexify((long)value);
    }

    public static String hexify(Integer value) {
        return value == null ? "" : HexUtil.hexify((int)value);
    }

    public static String hexify(long value) {
        String tmp = HexUtil.hexify(BigInteger.valueOf(value).toByteArray());
        return tmp;
    }

    public static String hexify(Long value) {
        return value == null ? "" : HexUtil.hexify((long)value);
    }
}

