/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.Filter;
import de.bos_bremen.common.ObjectUtil;
import de.bos_bremen.common.WrapperFilter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilterUtil {
    private static final Log LOG = LogFactory.getLog(FilterUtil.class);

    public static <E> Filter<E> all(final Class<E> filterClass) throws IllegalArgumentException {
        AssertUtil.notNull(filterClass, "filter class");
        return new Filter<E>(){

            @Override
            public boolean accept(E f) {
                return true;
            }

            @Override
            public Class<E> getFilterClass() {
                return filterClass;
            }
        };
    }

    public static <E> Filter<E> and(Class<E> filterClass, Filter<E> ... filters) throws IllegalArgumentException {
        AssertUtil.notNull(filterClass, "filter class");
        List<Filter<E>> filterList = FilterUtil.toList(filters);
        return FilterUtil.and(filterClass, filterList);
    }

    public static <E> Filter<E> and(final Class<E> filterClass, List<Filter<E>> filterList) throws IllegalArgumentException {
        AssertUtil.notNull(filterClass, "filter class");
        if (CollectionUtil.isNullOrEmpty(filterList)) {
            return FilterUtil.all(filterClass);
        }
        final List<Filter<E>> fFilterList = FilterUtil.createCleanCopy(filterClass, filterList);
        if (CollectionUtil.isNullOrEmpty(fFilterList)) {
            return FilterUtil.all(filterClass);
        }
        if (fFilterList.size() == 1) {
            return fFilterList.get(0);
        }
        return new Filter<E>(){

            @Override
            public boolean accept(E f) {
                for (Filter filter : fFilterList) {
                    if (filter.accept(f)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Class<E> getFilterClass() {
                return filterClass;
            }
        };
    }

    public static <E> Filter<E> cast(Class<E> filterClass, Filter<?> filter) throws IllegalArgumentException {
        AssertUtil.notNull(filterClass, "filter class");
        AssertUtil.notNull(filter, "filter");
        AssertUtil.notNull(filter.getFilterClass(), "filter class of filter");
        AssertUtil.isTrue(filter.getFilterClass().isAssignableFrom(filterClass), "filter class of filter assignable from filter type class");
        if (filterClass.equals(filter.getFilterClass())) {
            return filter;
        }
        Method m = null;
        for (Method tmp : filter.getClass().getDeclaredMethods()) {
            if (!"accept".equals(tmp.getName()) || tmp.getParameterTypes() == null || tmp.getParameterTypes().length != 1) continue;
            m = tmp;
            break;
        }
        if (m == null) {
            throw new IllegalArgumentException("accept method not found");
        }
        return FilterUtil.createCastFilter(filterClass, filter, m);
    }

    public static <E> List<E> filter(Filter<E> filter, E[] array) {
        if (ObjectUtil.notNull(filter)) {
            AssertUtil.notNull(filter.getFilterClass(), "filter class");
        }
        ArrayList<E> resultList = new ArrayList<E>();
        if (ArrayUtil.isNullOrEmpty(array)) {
            return resultList;
        }
        if (ObjectUtil.isNull(filter)) {
            resultList.addAll(Arrays.asList(array));
            return resultList;
        }
        for (E e : array) {
            if (!filter.accept(e)) continue;
            resultList.add(e);
        }
        return resultList;
    }

    public static <E> Collection<E> filter(Filter<E> filter, Collection<E> collection) throws IllegalArgumentException {
        if (ObjectUtil.notNull(filter)) {
            AssertUtil.notNull(filter.getFilterClass(), "filter class");
        }
        if (ObjectUtil.isNull(filter) || CollectionUtil.isNullOrEmpty(collection)) {
            return collection;
        }
        ArrayList<E> resultCollection = new ArrayList<E>();
        for (E t : collection) {
            if (!filter.accept(t)) continue;
            resultCollection.add(t);
        }
        return resultCollection;
    }

    public static <E> List<E> filter(Filter<E> filter, List<E> list) throws IllegalArgumentException {
        if (ObjectUtil.notNull(filter)) {
            AssertUtil.notNull(filter.getFilterClass(), "filter class");
        }
        if (ObjectUtil.isNull(filter) || CollectionUtil.isNullOrEmpty(list)) {
            return list;
        }
        ArrayList<E> resultList = new ArrayList<E>();
        for (E t : list) {
            if (!filter.accept(t)) continue;
            resultList.add(t);
        }
        return resultList;
    }

    public static <E> Set<E> filter(Filter<E> filter, Set<E> set) throws IllegalArgumentException {
        if (ObjectUtil.notNull(filter)) {
            AssertUtil.notNull(filter.getFilterClass(), "filter class");
        }
        if (ObjectUtil.isNull(filter) || CollectionUtil.isNullOrEmpty(set)) {
            return set;
        }
        HashSet<E> resultSet = new HashSet<E>();
        for (E t : set) {
            if (!filter.accept(t)) continue;
            resultSet.add(t);
        }
        return resultSet;
    }

    public static <K, V> Map<K, V> filter(Filter<K> keyFilter, Filter<V> valueFilter, Map<K, V> map) throws IllegalArgumentException {
        if (ObjectUtil.notNull(keyFilter)) {
            AssertUtil.notNull(keyFilter.getFilterClass(), "filter class of key filter");
        }
        if (ObjectUtil.notNull(valueFilter)) {
            AssertUtil.notNull(valueFilter.getFilterClass(), "filter class of value filter");
        }
        if (ObjectUtil.isNull(keyFilter) && ObjectUtil.isNull(valueFilter) || CollectionUtil.isNullOrEmpty(map)) {
            return map;
        }
        HashMap<K, V> resultMap = new HashMap<K, V>();
        for (Map.Entry<K, V> e : map.entrySet()) {
            if (!ObjectUtil.isNull(keyFilter) && !keyFilter.accept(e.getKey()) || !ObjectUtil.isNull(valueFilter) && !valueFilter.accept(e.getValue())) continue;
            resultMap.put(e.getKey(), e.getValue());
        }
        return resultMap;
    }

    public static <E> Filter<E> not(final Filter<E> filter) throws IllegalArgumentException {
        AssertUtil.notNull(filter, "filter");
        AssertUtil.notNull(filter.getFilterClass(), "filter class");
        return new Filter<E>(){

            @Override
            public boolean accept(E f) {
                return !filter.accept(f);
            }

            @Override
            public Class<E> getFilterClass() {
                return filter.getFilterClass();
            }
        };
    }

    public static <E> Filter<E> nothing(final Class<E> filterClass) throws IllegalArgumentException {
        AssertUtil.notNull(filterClass, "filter class");
        return new Filter<E>(){

            @Override
            public boolean accept(E f) {
                return false;
            }

            @Override
            public Class<E> getFilterClass() {
                return filterClass;
            }
        };
    }

    public static <E> Filter<E> or(Class<E> filterClass, Filter<E> ... filters) throws IllegalArgumentException {
        AssertUtil.notNull(filterClass, "filter class");
        List<Filter<E>> filterList = FilterUtil.toList(filters);
        return FilterUtil.or(filterClass, filterList);
    }

    public static <E> Filter<E> or(final Class<E> filterClass, List<Filter<E>> filterList) throws IllegalArgumentException {
        AssertUtil.notNull(filterClass, "filter class");
        if (CollectionUtil.isNullOrEmpty(filterList)) {
            return FilterUtil.all(filterClass);
        }
        final List<Filter<E>> fFilterList = FilterUtil.createCleanCopy(filterClass, filterList);
        if (CollectionUtil.isNullOrEmpty(fFilterList)) {
            return FilterUtil.all(filterClass);
        }
        if (fFilterList.size() == 1) {
            return fFilterList.get(0);
        }
        return new Filter<E>(){

            @Override
            public boolean accept(E f) {
                for (Filter filter : fFilterList) {
                    if (!filter.accept(f)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Class<E> getFilterClass() {
                return filterClass;
            }
        };
    }

    public static <E> Filter<E> secure(final Filter<E> filter) throws IllegalArgumentException {
        AssertUtil.notNull(filter, "filter");
        AssertUtil.notNull(filter.getFilterClass(), "filter class of filter");
        return new Filter<E>(){

            @Override
            public boolean accept(E object) {
                boolean result = false;
                try {
                    result = filter.accept(object);
                }
                catch (Throwable t) {
                    LOG.error((Object)t);
                }
                return result;
            }

            @Override
            public Class<E> getFilterClass() {
                return filter.getFilterClass();
            }
        };
    }

    public static <E> List<Filter<E>> toList(Filter<E> ... filters) throws IllegalArgumentException {
        ArrayList<Filter<Filter<E>>> filterList = new ArrayList<Filter<Filter<E>>>();
        if (ArrayUtil.isNullOrEmpty(filters)) {
            return filterList;
        }
        for (Filter<E> filter : filters) {
            if (filter == null) continue;
            AssertUtil.notNull(filter.getFilterClass(), "filter class");
            if (filterList.contains(filter)) continue;
            filterList.add(filter);
        }
        return filterList;
    }

    public static <E> Filter<E> xor(Class<E> filterClass, Filter<E> ... filters) throws IllegalArgumentException {
        AssertUtil.notNull(filterClass, "filter class");
        List<Filter<E>> filterList = FilterUtil.toList(filters);
        return FilterUtil.xor(filterClass, filterList);
    }

    public static <E> Filter<E> xor(final Class<E> filterClass, List<Filter<E>> filterList) throws IllegalArgumentException {
        AssertUtil.notNull(filterClass, "filter class");
        if (CollectionUtil.isNullOrEmpty(filterList)) {
            return FilterUtil.all(filterClass);
        }
        final List<Filter<E>> fFilterList = FilterUtil.createCleanCopy(filterClass, filterList);
        if (CollectionUtil.isNullOrEmpty(fFilterList)) {
            return FilterUtil.all(filterClass);
        }
        if (fFilterList.size() == 1) {
            return fFilterList.get(0);
        }
        return new Filter<E>(){

            @Override
            public boolean accept(E f) {
                boolean result = false;
                for (Filter filter : fFilterList) {
                    result ^= filter.accept(f);
                }
                return result;
            }

            @Override
            public Class<E> getFilterClass() {
                return filterClass;
            }
        };
    }

    private static <E> Filter<E> createCastFilter(Class<E> filterTypeClass, Filter<?> filter, Method m) {
        return new WrapperFilter<E>(filterTypeClass, filter, m);
    }

    private static <E> List<Filter<E>> createCleanCopy(Class<E> filterClass, List<Filter<E>> listFilter) {
        ArrayList<Filter<Filter<E>>> listfFilterResult = new ArrayList<Filter<Filter<E>>>();
        if (!CollectionUtil.isNullOrEmpty(listFilter)) {
            for (Filter<E> filter : listFilter) {
                if (ObjectUtil.notNull(filter)) {
                    AssertUtil.equals(filterClass, filter.getFilterClass(), "filter class and class of not null filter of list");
                }
                if (!ObjectUtil.notNull(filter) || listfFilterResult.contains(filter)) continue;
                listfFilterResult.add(filter);
            }
        }
        return listfFilterResult;
    }

    private FilterUtil() {
    }
}

