/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.AssertUtil;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public final class EnumUtil {
    public static final Logger LOG = Logger.getLogger(EnumUtil.class);
    private static final String METHOD_NAME_VALUES = "values";

    private EnumUtil() {
    }

    public static <T extends Enum<T>> T getEnumByName(Class<T> enumType, String name) throws IllegalArgumentException {
        AssertUtil.notNull(enumType, "Class");
        AssertUtil.notNull(name, "name");
        T result = null;
        try {
            result = Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)e);
        }
        return result;
    }

    public static <T extends Enum<T>> T getEnumByOrdinal(Class<T> enumType, int ordinal) throws IllegalArgumentException {
        Enum[] values = EnumUtil.getEnumValues(enumType);
        Enum result = null;
        if (values != null && ordinal >= 0 && ordinal < values.length) {
            result = values[ordinal];
        }
        return (T)result;
    }

    public static <T extends Enum<T>> T[] getEnumValues(Class<T> enumType) throws IllegalArgumentException {
        AssertUtil.notNull(enumType, "Class");
        Enum[] values = null;
        try {
            Enum[] tmp;
            Method valuesMethod = enumType.getMethod(METHOD_NAME_VALUES, new Class[0]);
            values = tmp = (Enum[])valuesMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return values;
    }
}

