/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.asn1.HashAlgorithm;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.constants.OIDConstants;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public final class DigestUtil {
    private DigestUtil() {
    }

    public static MessageDigest getDigestByOID(OID oid) throws NoSuchAlgorithmException, NoSuchProviderException {
        AssertUtil.notNull(oid, "OID");
        MessageDigest md = null;
        if (oid.equals(OIDConstants.OID_TA_ECDSA_SHA_1) || oid.equals(OIDConstants.OID_TA_RSA_PSS_SHA_1) || oid.equals(OIDConstants.OID_TA_RSA_v1_5_SHA_1) || oid.equals(OIDConstants.OID_RSADSI_SHA1_WITH_RSA) || oid.equals(HashAlgorithm.Algorithm.SHA1.getOID())) {
            md = MessageDigest.getInstance("SHA1", "BC");
        } else if (oid.equals(OIDConstants.OID_TA_ECDSA_SHA_224) || oid.equals(OIDConstants.OID_RSADSI_SHA224_WITH_RSA) || oid.equals(HashAlgorithm.Algorithm.SHA224.getOID())) {
            md = MessageDigest.getInstance("SHA224", "BC");
        } else if (oid.equals(OIDConstants.OID_TA_ECDSA_SHA_256) || oid.equals(OIDConstants.OID_TA_RSA_PSS_SHA_256) || oid.equals(OIDConstants.OID_TA_RSA_v1_5_SHA_256) || oid.equals(OIDConstants.OID_RSADSI_SHA256_WITH_RSA) || oid.equals(HashAlgorithm.Algorithm.SHA256.getOID())) {
            md = MessageDigest.getInstance("SHA256", "BC");
        } else if (oid.equals(HashAlgorithm.Algorithm.SHA384.getOID()) || oid.equals(OIDConstants.OID_RSADSI_SHA384_WITH_RSA)) {
            md = MessageDigest.getInstance("SHA384", "BC");
        } else if (oid.equals(HashAlgorithm.Algorithm.SHA512.getOID()) || oid.equals(OIDConstants.OID_RSADSI_SHA512_WITH_RSA)) {
            md = MessageDigest.getInstance("SHA512", "BC");
        } else if (oid.equals(HashAlgorithm.Algorithm.RIPEMD160.getOID())) {
            md = MessageDigest.getInstance("RIPEMD160", "BC");
        } else if (oid.equals(HashAlgorithm.Algorithm.WHIRLPOOL.getOID())) {
            md = MessageDigest.getInstance("WHIRLPOOL", "BC");
        } else {
            throw new IllegalArgumentException("unknown OID");
        }
        return md;
    }
}

