/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class CollectionUtil {
    public static final String MESSAGE_FAILED_COLLECTION_NULL = "Collection not permitted as null";
    public static final String MESSAGE_FAILED_LIST_NULL = "List not permitted as null";
    public static final String MESSAGE_FAILED_MAP_NULL = "Map not permitted as null";
    public static final String MESSAGE_FAILED_SET_NULL = "Set not permitted as null";
    public static final String FILE_SUFFIX_PROPERTIES = ".properties";

    private CollectionUtil() {
    }

    public static boolean containsNull(Collection<?> collection) throws IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_MAP_NULL);
        }
        return collection.contains(null);
    }

    public static boolean notContainsNull(Collection<?> collection) throws IllegalArgumentException {
        return !CollectionUtil.containsNull(collection);
    }

    public static boolean containsNull(List<?> list) throws IllegalArgumentException {
        if (list == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_LIST_NULL);
        }
        return list.contains(null);
    }

    public static boolean notContainsNull(List<?> list) throws IllegalArgumentException {
        return !CollectionUtil.containsNull(list);
    }

    public static boolean containsNull(Map<?, ?> map) throws IllegalArgumentException {
        if (map == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_MAP_NULL);
        }
        return map.containsValue(null);
    }

    public static boolean notContainsNull(Map<?, ?> map) throws IllegalArgumentException {
        return !CollectionUtil.containsNull(map);
    }

    public static boolean containsNull(Set<?> set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_SET_NULL);
        }
        return set.contains(null);
    }

    public static boolean notContainsNull(Set<?> set) throws IllegalArgumentException {
        return !CollectionUtil.containsNull(set);
    }

    public static boolean isEmpty(Collection<?> collection) throws IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_COLLECTION_NULL);
        }
        return collection.isEmpty();
    }

    public static boolean notEmpty(Collection<?> collection) throws IllegalArgumentException {
        return !CollectionUtil.isEmpty(collection);
    }

    public static boolean isEmpty(List<?> list) throws IllegalArgumentException {
        if (list == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_LIST_NULL);
        }
        return list.isEmpty();
    }

    public static boolean notEmpty(List<?> list) throws IllegalArgumentException {
        return !CollectionUtil.isEmpty(list);
    }

    public static boolean isEmpty(Map<?, ?> map) throws IllegalArgumentException {
        if (map == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_MAP_NULL);
        }
        return map.isEmpty();
    }

    public static boolean notEmpty(Map<?, ?> map) throws IllegalArgumentException {
        return !CollectionUtil.isEmpty(map);
    }

    public static boolean isEmpty(Set<?> set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_SET_NULL);
        }
        return set.isEmpty();
    }

    public static boolean notEmpty(Set<?> set) throws IllegalArgumentException {
        return !CollectionUtil.isEmpty(set);
    }

    public static boolean isNull(Collection<?> collection) {
        return collection == null;
    }

    public static boolean notNull(Collection<?> collection) {
        return !CollectionUtil.isNull(collection);
    }

    public static boolean isNull(List<?> list) {
        return list == null;
    }

    public static boolean notNull(List<?> list) {
        return !CollectionUtil.isNull(list);
    }

    public static boolean isNull(Map<?, ?> map) {
        return map == null;
    }

    public static boolean notNull(Map<?, ?> map) {
        return !CollectionUtil.isNull(map);
    }

    public static boolean isNull(Set<?> set) {
        return set == null;
    }

    public static boolean notNull(Set<?> set) {
        return !CollectionUtil.isNull(set);
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return CollectionUtil.isNull(collection) || CollectionUtil.isEmpty(collection);
    }

    public static boolean notNullOrEmpty(Collection<?> collection) {
        return !CollectionUtil.isNullOrEmpty(collection);
    }

    public static boolean isNullOrEmpty(List<?> list) {
        return CollectionUtil.isNull(list) || CollectionUtil.isEmpty(list);
    }

    public static boolean notNullOrEmpty(List<?> list) {
        return !CollectionUtil.isNullOrEmpty(list);
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return CollectionUtil.isNull(map) || CollectionUtil.isEmpty(map);
    }

    public static boolean notNullOrEmpty(Map<?, ?> map) {
        return !CollectionUtil.isNullOrEmpty(map);
    }

    public static boolean isNullOrEmpty(Set<?> set) {
        return CollectionUtil.isNull(set) || CollectionUtil.isEmpty(set);
    }

    public static boolean notNullOrEmpty(Set<?> set) {
        return !CollectionUtil.isNullOrEmpty(set);
    }

    public static boolean isNullOrEmptyOrContainsNull(Collection<?> collection) {
        return CollectionUtil.isNullOrEmpty(collection) || CollectionUtil.containsNull(collection);
    }

    public static boolean notNullOrEmptyOrContainsNull(Collection<?> collection) {
        return !CollectionUtil.isNullOrEmptyOrContainsNull(collection);
    }

    public static boolean isNullOrEmptyOrContainsNull(List<?> list) {
        return CollectionUtil.isNullOrEmpty(list) || CollectionUtil.containsNull(list);
    }

    public static boolean notNullOrEmptyOrContainsNull(List<?> list) {
        return !CollectionUtil.isNullOrEmptyOrContainsNull(list);
    }

    public static boolean isNullOrEmptyOrContainsNull(Map<?, ?> map) {
        return CollectionUtil.isNullOrEmpty(map) || CollectionUtil.containsNull(map);
    }

    public static boolean notNullOrEmptyOrContainsNull(Map<?, ?> map) {
        return !CollectionUtil.isNullOrEmptyOrContainsNull(map);
    }

    public static boolean isNullOrEmptyOrContainsNull(Set<?> set) {
        return CollectionUtil.isNullOrEmpty(set) || CollectionUtil.containsNull(set);
    }

    public static boolean notNullOrEmptyOrContainsNull(Set<?> set) {
        return !CollectionUtil.isNullOrEmptyOrContainsNull(set);
    }

    public static <E> List<E> cast(Class<E> entryClass, List<?> list) {
        return (List)CollectionUtil.cast(entryClass, list);
    }

    public static <E> Collection<E> cast(Class<E> entryClass, Collection<?> collection) {
        AssertUtil.notNull(entryClass, "entry Class");
        if (collection == null) {
            return null;
        }
        ArrayList<E> result = new ArrayList<E>();
        for (Object o : collection) {
            if (!entryClass.isInstance(o)) continue;
            result.add(entryClass.cast(o));
        }
        return result;
    }

    public static <K, V> Map<K, V> cast(Class<K> keyClass, Class<V> valueClass, Map<?, ?> map) {
        AssertUtil.notNull(keyClass, "key Class");
        AssertUtil.notNull(valueClass, "value Class");
        if (map == null) {
            return null;
        }
        HashMap<K, Object> result = new HashMap<K, Object>();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            if (key != null && !keyClass.isInstance(key)) continue;
            K castedKey = keyClass.cast(key);
            Object castedValue = null;
            if (value != null && !valueClass.isInstance(value)) continue;
            castedValue = valueClass.cast(value);
            result.put(castedKey, castedValue);
        }
        return result;
    }

    public static Map<String, String> convert(Properties properties) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (entry == null) continue;
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null && value == null) {
                    map.put(null, null);
                    continue;
                }
                if (key != null && value != null) {
                    map.put(key.toString(), value.toString());
                    continue;
                }
                if (key == null) {
                    map.put(null, value.toString());
                    continue;
                }
                map.put(key.toString(), null);
            }
        }
        return map;
    }

    public static Properties readPropertiesResource(Class<?> clazz) {
        Properties p = new Properties();
        try (InputStream is = clazz.getResourceAsStream(clazz.getSimpleName() + FILE_SUFFIX_PROPERTIES);){
            if (is != null) {
                p.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return p;
    }
}

