/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ObjectUtil;
import de.bos_bremen.common.constants.Constants;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;

public final class ClassUtil {
    public static final Logger LOG = Logger.getLogger(ClassUtil.class);

    public static Class<?> forNameWithoutException(String name) {
        AssertUtil.notNullOrEmpty(name, "name of Class");
        Class<?> result = null;
        try {
            result = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)e);
        }
        return result;
    }

    private ClassUtil() {
    }

    public static <T> T newInstance(Class<T> clazz, Class<?>[] constructorClasses, Object[] constructorArguments) throws IllegalAccessException, IllegalArgumentException {
        ClassUtil.newInstanceCheck(clazz, constructorClasses, constructorArguments);
        T result = null;
        try {
            Constructor<T> c = clazz.getConstructor(constructorClasses);
            result = c.newInstance(constructorArguments);
        }
        catch (SecurityException e) {
            IllegalAccessException iae = new IllegalAccessException("creating instance failed: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
        catch (NoSuchMethodException e) {
            IllegalAccessException iae = new IllegalAccessException("creating instance failed: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
        catch (InvocationTargetException e) {
            IllegalAccessException iae = new IllegalAccessException("creating instance failed: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
        catch (InstantiationException e) {
            IllegalAccessException iae = new IllegalAccessException("creating instance failed: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
        return result;
    }

    private static <T> void newInstanceCheck(Class<?> clazz, Class<?>[] constructorClasses, Object[] constructorArguments) throws IllegalArgumentException {
        AssertUtil.notNull(clazz, "Class");
        AssertUtil.isTrue(!clazz.isInterface(), "Class.isInterface()");
        Class<?>[] lConstructorClasses = constructorClasses;
        Object[] lConstructorArguments = constructorArguments;
        if (ObjectUtil.isNull(lConstructorClasses)) {
            lConstructorClasses = Constants.EMPTY_CLASS_ARRAY;
        }
        if (ObjectUtil.isNull(lConstructorArguments)) {
            lConstructorArguments = Constants.EMPTY_OBJECT_ARRAY;
        }
        AssertUtil.equals(lConstructorClasses.length, lConstructorArguments.length, "count of constructor Classes and arguments");
        for (int i = 0; i < lConstructorClasses.length; ++i) {
            AssertUtil.notNull(lConstructorClasses[i], "Constructor Class");
            if (lConstructorArguments[i] == null || lConstructorClasses[i].isInstance(lConstructorArguments[i])) continue;
            throw new IllegalArgumentException("error, type mismatch between constructor class and constructor argument, expected: " + lConstructorClasses[i].getName() + ", but found argument: " + lConstructorArguments[i].getClass().getName());
        }
        AssertUtil.isTrue(ClassUtil.hasConstructor(clazz, lConstructorClasses, null), "Constructor exists");
    }

    public static boolean hasConstructor(Class<?> clazz, Class<?>[] constructorClasses, Integer modifiers) throws IllegalArgumentException {
        AssertUtil.notNull(clazz, "Class");
        AssertUtil.isTrue(!clazz.isInterface(), "Class.isInterface()");
        boolean result = false;
        try {
            Constructor<?> c = clazz.getDeclaredConstructor(constructorClasses);
            if (ObjectUtil.notNull(c)) {
                if (ObjectUtil.notNull(modifiers)) {
                    AssertUtil.equals((int)modifiers, c.getModifiers(), "modifiers");
                }
                result = true;
            }
        }
        catch (Throwable e) {
            LOG.error((Object)e);
        }
        return result;
    }

    public static boolean hasMethod(Class<?> clazz, String name, Class<?>[] parameterTypes, Integer modifiers) {
        AssertUtil.notNull(clazz, "Class");
        AssertUtil.notNullOrEmpty(name, "name of method");
        boolean result = false;
        try {
            Method m = clazz.getDeclaredMethod(name, parameterTypes);
            if (ObjectUtil.notNull(m)) {
                if (ObjectUtil.notNull(modifiers)) {
                    AssertUtil.equals((int)modifiers, m.getModifiers(), "modifiers");
                }
                result = true;
            }
        }
        catch (Throwable e) {
            LOG.error((Object)e);
        }
        return result;
    }

    public static <T> T newInstanceWithoutException(Class<T> clazz, Class<?>[] constructorClasses, Object[] constructorArguments) throws IllegalArgumentException {
        ClassUtil.newInstanceCheck(clazz, constructorClasses, constructorArguments);
        T result = null;
        try {
            Constructor<T> c = clazz.getConstructor(constructorClasses);
            result = c.newInstance(constructorArguments);
        }
        catch (Throwable e) {
            result = null;
        }
        return result;
    }

    public static List<Class<?>> getAllInterfaces(Class<?> c) {
        Object[] interfaces;
        ArrayList result = new ArrayList<Class<?>>(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean addAll(Collection<? extends Class<?>> clazz) {
                ArrayList tmp = new ArrayList(clazz);
                tmp.removeAll(this);
                return super.addAll(tmp);
            }
        };
        if (c == null || Object.class.equals(c)) {
            return result;
        }
        if (c.isInterface()) {
            result.add(c);
        }
        if (!ArrayUtil.isNullOrEmpty(interfaces = c.getInterfaces())) {
            result.addAll(Arrays.asList(interfaces));
            for (int i = 0; i < interfaces.length; ++i) {
                result.addAll(ClassUtil.getAllInterfaces(interfaces[i]));
            }
        }
        result.addAll(ClassUtil.getAllInterfaces(c.getSuperclass()));
        Collections.sort(result, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                String s1 = o1.getName();
                String s2 = o2.getName();
                return s1.compareTo(s2);
            }
        });
        return result;
    }

    public static List<Class<?>> getHierarchy(Class<?> clazz) {
        ArrayList result = new ArrayList();
        Class<?> lClazz = clazz;
        while (!Object.class.equals(lClazz)) {
            result.add(lClazz);
            lClazz = lClazz.getSuperclass();
        }
        result.add(lClazz);
        return result;
    }

    public static boolean notNull(Class<?> c) {
        return !ClassUtil.isNull(c);
    }

    public static boolean isNull(Class<?> c) {
        return ObjectUtil.isNull(c);
    }

    public static boolean notNullInterface(Class<?> c) {
        return !ClassUtil.isNull(c) && (c.isInterface() || ClassUtil.notNullArrayInterface(c));
    }

    public static boolean notNullNotInterface(Class<?> c) {
        return !ClassUtil.isNull(c) && !c.isInterface() && !ClassUtil.notNullArrayInterface(c);
    }

    public static boolean notNullClassObject(Class<?> c) {
        return !ClassUtil.isNull(c) && !c.isInterface() && !c.isPrimitive() && !ClassUtil.notNullArrayInterface(c) && !ClassUtil.notNullArrayClassPrimitive(c);
    }

    public static boolean notNullClassPrimitive(Class<?> c) {
        return !ClassUtil.isNull(c) && !c.isInterface() && (c.isPrimitive() || ClassUtil.notNullArrayClassPrimitive(c));
    }

    public static boolean notNullNotClassPrimitive(Class<?> c) {
        return !ClassUtil.isNull(c) && !c.isPrimitive() && !ClassUtil.notNullArrayClassPrimitive(c);
    }

    public static boolean notNullNotArrayInterface(Class<?> c) {
        return !ClassUtil.isNull(c) && !c.isArray() && c.isInterface();
    }

    public static boolean notNullNotArrayNotInterface(Class<?> c) {
        return !ClassUtil.isNull(c) && !c.isArray() && !c.isInterface();
    }

    public static boolean notNullNotArrayClassObject(Class<?> c) {
        return !ClassUtil.isNull(c) && !c.isArray() && !c.isInterface() && !c.isPrimitive();
    }

    public static boolean notNullNotArrayClassPrimitive(Class<?> c) {
        return !ClassUtil.isNull(c) && !c.isArray() && !c.isInterface() && c.isPrimitive();
    }

    public static boolean notNullNotArrayNotClassPrimitive(Class<?> c) {
        return !ClassUtil.isNull(c) && !c.isArray() && !c.isPrimitive();
    }

    public static boolean notNullArrayInterface(Class<?> c) {
        return !ClassUtil.isNull(c) && c.isArray() && c.getComponentType().isInterface();
    }

    public static boolean notNullArrayNotInterface(Class<?> c) {
        return !ClassUtil.isNull(c) && c.isArray() && !c.getComponentType().isInterface();
    }

    public static boolean notNullArrayClassObject(Class<?> c) {
        return !ClassUtil.isNull(c) && c.isArray() && !c.getComponentType().isInterface() && !c.getComponentType().isPrimitive();
    }

    public static boolean notNullArrayClassPrimitive(Class<?> c) {
        return !ClassUtil.isNull(c) && c.isArray() && !c.getComponentType().isInterface() && c.getComponentType().isPrimitive();
    }

    public static boolean notNullArrayNotClassPrimitive(Class<?> c) {
        return !ClassUtil.isNull(c) && c.isArray() && !c.getComponentType().isPrimitive();
    }
}

