/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.constants.Constants;
import java.util.Arrays;

public final class CharUtil {
    private CharUtil() {
    }

    public static byte[] convert(char[] chars) {
        return ByteUtil.convert(chars);
    }

    public static byte convert(char c) {
        return ByteUtil.convert(c);
    }

    public static char[] convert(byte[] bytes) {
        if (ArrayUtil.isNull(bytes)) {
            return null;
        }
        if (ArrayUtil.isEmpty(bytes)) {
            return Constants.EMPTY_PRIMITIVE_CHARACTER_ARRAY;
        }
        char[] result = new char[bytes.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (char)bytes[i];
        }
        return result;
    }

    public static char convert(byte b) {
        return (char)b;
    }

    public static char[] copyOf(char[] original, int newLength) throws IllegalArgumentException {
        if (newLength < 0) {
            throw new IllegalArgumentException("illegal length");
        }
        AssertUtil.notNull(original, "char array");
        char[] result = new char[newLength];
        Arrays.fill(result, '\u0000');
        System.arraycopy(original, 0, result, 0, Math.min(original.length, newLength));
        return result;
    }
}

