/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.AssertUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class CallableExecutor<T, X extends Throwable>
implements Runnable {
    public static final Logger LOG = Logger.getLogger(CallableExecutor.class);
    private final Object syncStart;
    private final Object syncEnd;
    private final Callable<T> callable;
    private final List<T> resultList;
    private X throwable;
    private volatile boolean finished = false;

    public CallableExecutor(Callable<T> callable, Object syncStart, Object syncEnd) {
        AssertUtil.notNull(callable, "callable");
        AssertUtil.notNull(syncStart, "syncStart");
        AssertUtil.notNull(syncEnd, "syncStart");
        this.callable = callable;
        this.syncStart = syncStart;
        this.syncEnd = syncEnd;
        this.throwable = null;
        this.resultList = new ArrayList<T>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.syncStart;
        synchronized (object) {
            try {
                this.syncStart.wait(0L);
                this.resultList.add(this.callable.call());
            }
            catch (ThreadDeath t) {
                this.resultList.clear();
            }
            catch (Throwable t) {
                this.resultList.clear();
                this.throwable = t;
            }
            finally {
                Object t = this.syncEnd;
                synchronized (t) {
                    this.finished = true;
                    this.syncEnd.notify();
                }
            }
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void finish() {
        this.finished = true;
    }

    public List<T> getResultList() {
        return this.finished ? this.resultList : null;
    }

    public X getThrowable() {
        return this.finished ? (X)this.throwable : null;
    }
}

