/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.ArrayCompareDifference;
import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.BCDUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.constants.ByteConstants;
import de.bos_bremen.common.constants.Constants;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public final class ByteUtil {
    public static final Logger LOG = Logger.getLogger(ByteUtil.class);
    public static final int INDEX_NOT_FOUND = -1;
    public static final int SPLIT_AT_RESULT_INDEX_BEGIN = 0;
    public static final int SPLIT_AT_RESULT_INDEX_END = 1;

    private ByteUtil() {
    }

    private static void checkBitIndex(int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("index only permitted greater equals 0");
        }
        if (index > 7) {
            throw new IllegalArgumentException("index only permitted less equals 7");
        }
    }

    private static void checkBitIndex(int[] indices) throws IllegalArgumentException {
        if (indices == null || indices.length == 0) {
            return;
        }
        for (int i = 0; i < indices.length; ++i) {
            ByteUtil.checkBitIndex(indices[i]);
        }
    }

    private static void checkBytesAndByteIndex(byte[] bytes, int byteIndex) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex, true);
    }

    private static void checkBytesAndByteIndex(byte[] bytes, int byteIndex, boolean lengthOfArrayExcluded) throws IllegalArgumentException {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("byte-array not permitted as null or empty array");
        }
        if (byteIndex < 0) {
            throw new IllegalArgumentException("byte index not permitted less than 0");
        }
        if (lengthOfArrayExcluded) {
            if (byteIndex >= bytes.length) {
                throw new IllegalArgumentException("byte index not permitted greater equals length of array");
            }
            if (byteIndex > bytes.length) {
                throw new IllegalArgumentException("byte index not permitted greater length of array");
            }
        }
    }

    public static boolean areBitsSet(byte b, byte mask) {
        if (mask == 0) {
            return false;
        }
        return mask == (byte)(b & mask);
    }

    public static boolean areBitsSet(byte b, int[] indices) throws IllegalArgumentException {
        if (indices == null || indices.length == 0) {
            return false;
        }
        byte mask = ByteUtil.createBitMask(indices);
        return ByteUtil.areBitsSet(b, mask);
    }

    public static boolean areBitsSet(byte[] bytes, int byteIndex, byte mask) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex);
        return ByteUtil.areBitsSet(bytes[byteIndex], mask);
    }

    public static boolean areBitsSet(byte[] bytes, int byteIndex, int[] indices) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex);
        if (indices == null || indices.length == 0) {
            return false;
        }
        byte mask = ByteUtil.createBitMask(indices);
        return ByteUtil.areBitsSet(bytes[byteIndex], mask);
    }

    public static byte clearBit(byte b, int index) throws IllegalArgumentException {
        return ByteUtil.clearBits(b, new int[]{index});
    }

    public static void clearBit(byte[] bytes, int byteIndex, int index) throws IllegalArgumentException {
        ByteUtil.clearBits(bytes, byteIndex, new int[]{index});
    }

    public static byte clearBits(byte b, byte mask) {
        return (byte)(b & ByteUtil.xorBits((byte)-1, mask));
    }

    public static byte clearBits(byte b, int[] indices) throws IllegalArgumentException {
        if (indices == null || indices.length == 0) {
            return b;
        }
        byte mask = ByteUtil.createBitMask(indices);
        return ByteUtil.clearBits(b, mask);
    }

    public static void clearBits(byte[] bytes, int byteIndex, byte mask) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex);
        bytes[byteIndex] = ByteUtil.clearBits(bytes[byteIndex], mask);
    }

    public static void clearBits(byte[] bytes, int byteIndex, int[] indices) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex);
        if (indices == null || indices.length == 0) {
            return;
        }
        bytes[byteIndex] = ByteUtil.clearBits(bytes[byteIndex], indices);
    }

    public static byte[] combine(byte[] bytes1, byte[] bytes2) {
        if (bytes1 == null && bytes2 == null) {
            return null;
        }
        if ((bytes1 == null || bytes1.length == 0) && bytes2 != null && bytes2.length != 0) {
            return ByteUtil.copy(bytes2);
        }
        if ((bytes2 == null || bytes2.length == 0) && bytes1 != null && bytes1.length != 0) {
            return ByteUtil.copy(bytes1);
        }
        if (bytes1 != null && bytes1.length == 0 && bytes2 != null && bytes2.length == 0) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        if (bytes1 != null && bytes2 != null) {
            ByteBuffer buffer = ByteBuffer.allocate(bytes1.length + bytes2.length);
            buffer.put(bytes1);
            buffer.put(bytes2);
            return buffer.array();
        }
        return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
    }

    public static byte[] combine(byte[][] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        int size = ByteUtil.count(bytes);
        if (size == 0) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == null || bytes[i].length <= 0) continue;
            buffer.put(bytes[i]);
        }
        return buffer.array();
    }

    public static byte convert(char c) {
        return (byte)c;
    }

    public static byte[] convert(char[] chars) {
        if (chars == null) {
            return null;
        }
        if (chars.length == 0) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        byte[] result = new byte[chars.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ByteUtil.convert(chars[i]);
        }
        return result;
    }

    public static byte[] convertBCD(String bcdString) throws IllegalArgumentException {
        if (bcdString == null) {
            return null;
        }
        if (bcdString.length() == 0) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        if (bcdString.length() % 2 == 1) {
            throw new IllegalArgumentException("bcdString expected as String of even length");
        }
        for (int i = 0; i < bcdString.length(); ++i) {
            char c = bcdString.charAt(i);
            if (c >= BCDUtil.BCD_NIBBLE_ASCII_MINIMUM && c <= BCDUtil.BCD_NIBBLE_ASCII_MAXIMUM) continue;
            throw new IllegalArgumentException("illegal character found at String at index " + i);
        }
        return HexUtil.parse(bcdString);
    }

    public static byte[] convertHex(String hexString) {
        return HexUtil.parse(hexString);
    }

    public static byte[] copy(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        return buffer.array();
    }

    public static int count(byte[][] bytes) {
        if (bytes == null) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == null || bytes[i].length <= 0) continue;
            size += bytes[i].length;
        }
        return size;
    }

    public static byte createBitMask(int index) throws IllegalArgumentException {
        return ByteUtil.createBitMask(new int[]{index});
    }

    public static byte createBitMask(int[] indices) throws IllegalArgumentException {
        if (indices == null) {
            throw new IllegalArgumentException("indices array not permitted as null");
        }
        byte mask = 0;
        if (indices.length == 0) {
            return mask;
        }
        ByteUtil.checkBitIndex(indices);
        ArrayList<Integer> indicesList = new ArrayList<Integer>();
        for (int i = 0; i < indices.length; ++i) {
            if (indicesList.contains(indices[i])) continue;
            mask = (byte)(mask | ByteConstants.BIT_INDEX_MASK_LIST.get(indices[i]));
            indicesList.add(indices[i]);
        }
        return mask;
    }

    public static String createBitString(byte b) {
        Object result = BigInteger.valueOf(b >= 0 ? (long)b : (long)(b + 256)).toString(2);
        result = "00000000" + (String)result;
        result = ((String)result).substring(((String)result).length() - 8);
        return result;
    }

    public static void eraseRND(byte[] bytes) throws IllegalArgumentException {
        if (bytes == null) {
            throw new IllegalArgumentException("byte-array not permitted as null");
        }
        if (bytes.length == 0) {
            return;
        }
        SecureRandom sr = new SecureRandom();
        byte[] rndBytes = sr.generateSeed(bytes.length);
        while (Arrays.equals(rndBytes, bytes)) {
            rndBytes = sr.generateSeed(bytes.length);
        }
        System.arraycopy(rndBytes, 0, bytes, 0, bytes.length);
    }

    public static void eraseZero(byte[] bytes) throws IllegalArgumentException {
        if (bytes == null) {
            throw new IllegalArgumentException("byte-array not permitted as null");
        }
        if (bytes.length == 0) {
            return;
        }
        ByteUtil.fill(bytes, (byte)0);
    }

    public static byte[] extend(byte[] bytes, int size) throws IllegalArgumentException {
        if (bytes == null) {
            throw new IllegalArgumentException("byte[]-array not permitted as null for extend");
        }
        if (size < 0) {
            throw new IllegalArgumentException("size not permitted less than 0");
        }
        if (size == 0) {
            return ByteUtil.copy(bytes);
        }
        return ByteUtil.resize(bytes, bytes.length + size);
    }

    public static void fill(byte[] bytes, byte fillByte) throws IllegalArgumentException {
        if (bytes == null) {
            throw new IllegalArgumentException("byte-array not permitted as null");
        }
        ByteUtil.fill(bytes, fillByte, 0, bytes.length);
    }

    public static void fill(byte[] bytes, byte fillByte, int beginIndex) throws IllegalArgumentException {
        if (bytes == null) {
            throw new IllegalArgumentException("byte-array not permitted as null");
        }
        ByteUtil.fill(bytes, fillByte, beginIndex, bytes.length);
    }

    public static void fill(byte[] bytes, byte fillByte, int beginIndex, int endIndex) throws IllegalArgumentException {
        if (bytes == null) {
            throw new IllegalArgumentException("byte-array not permitted as null");
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("begin index only permitted greater equals 0");
        }
        if (endIndex < 0) {
            throw new IllegalArgumentException("end index only permitted greater equals 0");
        }
        if (beginIndex > bytes.length) {
            throw new IllegalArgumentException("begin index only permitted less equals length of array");
        }
        if (endIndex > bytes.length) {
            throw new IllegalArgumentException("end index only permitted less equals length of array");
        }
        if (beginIndex == bytes.length && endIndex != bytes.length) {
            throw new IllegalArgumentException("if begin index equals length of array, end index expected equals length of array");
        }
        if (endIndex < beginIndex) {
            throw new IllegalArgumentException("end index only permitted greater equals begin index");
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            bytes[i] = fillByte;
        }
    }

    public static byte[] flip(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = bytes[bytes.length - 1 - i];
        }
        return result;
    }

    public static void flipInternal(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = bytes[bytes.length - 1 - i];
        }
        System.arraycopy(result, 0, bytes, 0, bytes.length);
    }

    public static int indexOf(byte[] bytes, byte[] search) {
        return ByteUtil.indexOf(bytes, search, 0);
    }

    public static int indexOf(byte[] bytes, byte[] search, int beginIndex) throws IllegalArgumentException {
        if (beginIndex < 0) {
            throw new IllegalArgumentException("index for search not permitted less than 0");
        }
        if (bytes != null && beginIndex > bytes.length) {
            throw new IllegalArgumentException("index for search not permitted greater equals than length of byte-array");
        }
        if (bytes == null) {
            return -1;
        }
        if (search == null || search.length == 0) {
            return beginIndex;
        }
        if (bytes.length == 0 && search.length > 0) {
            return -1;
        }
        if (bytes.length < beginIndex + search.length) {
            return -1;
        }
        int result = -1;
        for (int i = beginIndex; i <= bytes.length - search.length; ++i) {
            result = i;
            for (int j = 0; j < search.length; ++j) {
                if (bytes[i + j] == search[j]) continue;
                result = -1;
                break;
            }
            if (result != -1) break;
        }
        return result;
    }

    public static byte[] insert(byte[] bytes, byte[] insert) throws IllegalArgumentException {
        return ByteUtil.insert(bytes, insert, 0);
    }

    public static byte[] insert(byte[] bytes, byte[] insert, int byteIndex) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex, false);
        if (insert == null || insert.length == 0) {
            return ByteUtil.copy(bytes);
        }
        byte[][] parts = ByteUtil.splitAt(bytes, byteIndex);
        byte[][] tmp = new byte[][]{parts[0], insert, parts[1]};
        return ByteUtil.combine(tmp);
    }

    public static boolean isBitSet(byte b, int index) throws IllegalArgumentException {
        return ByteUtil.areBitsSet(b, new int[]{index});
    }

    public static boolean isBitSet(byte[] bytes, int byteIndex, int index) throws IllegalArgumentException {
        return ByteUtil.areBitsSet(bytes, byteIndex, new int[]{index});
    }

    public static byte keepBit(byte b, int index) throws IllegalArgumentException {
        return ByteUtil.keepBits(b, new int[]{index});
    }

    public static void keepBit(byte[] bytes, int byteIndex, int index) throws IllegalArgumentException {
        ByteUtil.keepBits(bytes, byteIndex, new int[]{index});
    }

    public static byte keepBits(byte b, byte mask) {
        return (byte)(b & mask);
    }

    public static byte keepBits(byte b, int[] indices) {
        if (indices == null || indices.length == 0) {
            return 0;
        }
        byte mask = ByteUtil.createBitMask(indices);
        return ByteUtil.keepBits(b, mask);
    }

    public static void keepBits(byte[] bytes, int byteIndex, byte mask) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex);
        bytes[byteIndex] = ByteUtil.keepBits(bytes[byteIndex], mask);
    }

    public static void keepBits(byte[] bytes, int byteIndex, int[] indices) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex);
        if (indices == null || indices.length == 0) {
            bytes[byteIndex] = 0;
            return;
        }
        bytes[byteIndex] = ByteUtil.keepBits(bytes[byteIndex], indices);
    }

    public static int lastIndexOf(byte[] bytes, byte[] search) {
        if (bytes == null) {
            return -1;
        }
        return ByteUtil.lastIndexOf(bytes, search, bytes.length);
    }

    public static int lastIndexOf(byte[] bytes, byte[] search, int beginIndex) {
        if (beginIndex < 0) {
            throw new IllegalArgumentException("index for search not permitted less than 0");
        }
        if (bytes != null && beginIndex > bytes.length) {
            throw new IllegalArgumentException("index for search not permitted greater equals than length of byte-array");
        }
        if (bytes == null) {
            return -1;
        }
        if (search == null || search.length == 0) {
            return beginIndex;
        }
        if (bytes.length == 0 && search.length > 0) {
            return -1;
        }
        if (bytes.length < search.length) {
            return -1;
        }
        int result = -1;
        for (int i = Math.min(beginIndex, bytes.length - search.length); i >= 0; --i) {
            result = i;
            for (int j = 0; j < search.length; ++j) {
                if (bytes[i + j] == search[j]) continue;
                result = -1;
                break;
            }
            if (result != -1) break;
        }
        return result;
    }

    public static byte negate(byte b) {
        return ~b;
    }

    public static byte[] negate(byte[] bytes) throws IllegalArgumentException {
        if (bytes == null) {
            throw new IllegalArgumentException("byte-array not permitted as null");
        }
        if (bytes.length == 0) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = ByteUtil.negate(bytes[i]);
        }
        return result;
    }

    public static void negate(byte[] bytes, int byteIndex) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex);
        bytes[byteIndex] = ByteUtil.negate(bytes[byteIndex]);
    }

    public static byte negateBit(byte b, int index) throws IllegalArgumentException {
        return ByteUtil.negateBits(b, new int[]{index});
    }

    public static void negateBit(byte[] bytes, int byteIndex, int index) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex);
        bytes[byteIndex] = ByteUtil.negateBit(bytes[byteIndex], index);
    }

    public static byte negateBits(byte b, byte mask) {
        byte result = (byte)(b & ~mask);
        byte tmp = (byte)(b & mask);
        tmp = ByteUtil.negate(tmp);
        tmp = (byte)(tmp & mask);
        result = (byte)(result | tmp);
        return result;
    }

    public static byte negateBits(byte b, int[] indices) throws IllegalArgumentException {
        if (indices == null || indices.length == 0) {
            return b;
        }
        byte mask = ByteUtil.createBitMask(indices);
        return ByteUtil.negateBits(b, mask);
    }

    public static void negateBits(byte[] bytes, int byteIndex, byte mask) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex);
        bytes[byteIndex] = ByteUtil.negateBits(bytes[byteIndex], mask);
    }

    public static void negateBits(byte[] bytes, int byteIndex, int[] indices) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex);
        if (indices == null || indices.length == 0) {
            return;
        }
        bytes[byteIndex] = ByteUtil.negateBits(bytes[byteIndex], indices);
    }

    public static void negateInternal(byte[] bytes) throws IllegalArgumentException {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = ByteUtil.negate(bytes[i]);
        }
    }

    public static void replace(byte[] bytes, byte[] replace) {
        ByteUtil.replace(bytes, replace, 0);
    }

    public static void replace(byte[] bytes, byte[] replace, int index) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, index);
        if (replace != null && replace.length + index > bytes.length) {
            throw new IllegalArgumentException("insert not possible, destination too small for insert");
        }
        if (replace == null || replace.length == 0) {
            return;
        }
        System.arraycopy(replace, 0, bytes, index, replace.length);
    }

    public static byte[] resize(byte[] bytes, int size) throws IllegalArgumentException {
        if (bytes == null) {
            throw new IllegalArgumentException("byte[]-array not permitted as null for resize");
        }
        if (size < 0) {
            throw new IllegalArgumentException("size not permitted less than 0");
        }
        if (size == 0) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        if (size < bytes.length) {
            return ByteUtil.subbytes(bytes, 0, size);
        }
        byte[] result = new byte[size];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        ByteUtil.fill(result, (byte)0, bytes.length);
        return result;
    }

    public static byte[] rotate(byte[] bytes, int shift) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        int lShift = shift;
        if (lShift < 0) {
            while ((lShift += bytes.length) < 0) {
                LOG.debug((Object)"");
            }
        }
        if ((lShift %= bytes.length) == 0) {
            return ByteUtil.copy(bytes);
        }
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = bytes[(i + lShift) % bytes.length];
        }
        return result;
    }

    public static void rotateInternal(byte[] bytes, int shift) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        int lShift = shift;
        if (lShift < 0) {
            while ((lShift += bytes.length) < 0) {
                LOG.debug((Object)"");
            }
        }
        if ((lShift %= bytes.length) == 0) {
            return;
        }
        byte[] result = ByteUtil.copy(bytes);
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = result[(i + lShift) % result.length];
        }
    }

    public static byte setBit(byte b, int index) throws IllegalArgumentException {
        return ByteUtil.setBits(b, new int[]{index});
    }

    public static void setBit(byte[] bytes, int byteIndex, int index) throws IllegalArgumentException {
        ByteUtil.setBits(bytes, byteIndex, new int[]{index});
    }

    public static byte setBits(byte b, byte mask) {
        return (byte)(b | mask);
    }

    public static byte setBits(byte b, int[] indices) throws IllegalArgumentException {
        if (indices == null || indices.length == 0) {
            return b;
        }
        byte mask = ByteUtil.createBitMask(indices);
        return ByteUtil.setBits(b, mask);
    }

    public static void setBits(byte[] bytes, int byteIndex, byte mask) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex);
        bytes[byteIndex] = ByteUtil.setBits(bytes[byteIndex], mask);
    }

    public static void setBits(byte[] bytes, int byteIndex, int[] indices) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex);
        if (indices == null || indices.length == 0) {
            return;
        }
        bytes[byteIndex] = ByteUtil.setBits(bytes[byteIndex], indices);
    }

    public static byte[][] split(byte[] bytes, int size) throws IllegalArgumentException {
        if (bytes == null) {
            throw new IllegalArgumentException("byte-array not permitted as null");
        }
        if (bytes.length == 0) {
            throw new IllegalArgumentException("byte-array not permitted as empty array");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size not permitted less than 1");
        }
        if (bytes.length % size != 0) {
            throw new IllegalArgumentException("length of byte-array and split size does not fit");
        }
        byte[][] result = new byte[bytes.length / size][];
        for (int i = 0; i < bytes.length / size; ++i) {
            result[i] = ByteUtil.subbytes(bytes, i * size, (i + 1) * size);
        }
        return result;
    }

    public static byte[][] splitAt(byte[] bytes, int splitIndex) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, splitIndex, false);
        byte[][] result = new byte[2][];
        if (splitIndex == 0) {
            result[0] = Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
            result[1] = ByteUtil.copy(bytes);
        } else if (bytes.length == splitIndex) {
            result[0] = ByteUtil.copy(bytes);
            result[1] = Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        } else {
            result[0] = ByteUtil.subbytes(bytes, 0, splitIndex);
            result[1] = ByteUtil.subbytes(bytes, splitIndex);
        }
        return result;
    }

    public static byte[] subbytes(byte[] bytes, int beginIndex) {
        if (bytes == null) {
            throw new IllegalArgumentException("byte-array not permitted as null");
        }
        return ByteUtil.subbytes(bytes, beginIndex, bytes.length);
    }

    public static byte[] subbytes(byte[] bytes, int beginIndex, int endIndex) {
        if (bytes == null) {
            throw new IllegalArgumentException("byte-array not permitted as null");
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("begin index only permitted greater equals 0");
        }
        if (endIndex < 0) {
            throw new IllegalArgumentException("end index only permitted greater equals 0");
        }
        if (beginIndex > bytes.length) {
            throw new IllegalArgumentException("begin index only permitted less equals length of array");
        }
        if (endIndex > bytes.length) {
            throw new IllegalArgumentException("end index only permitted less equals length of array");
        }
        if (beginIndex == bytes.length && endIndex != bytes.length) {
            throw new IllegalArgumentException("if begin index equals length of array, end index expected equals length of array only permitted");
        }
        if (endIndex < beginIndex) {
            throw new IllegalArgumentException("end index only permitted greater equals begin index");
        }
        if (endIndex == beginIndex) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        ByteBuffer buffer = ByteBuffer.allocate(endIndex - beginIndex);
        buffer.put(bytes, beginIndex, endIndex - beginIndex);
        return buffer.array();
    }

    public static byte xorBit(byte b, int index) throws IllegalArgumentException {
        return ByteUtil.xorBits(b, new int[]{index});
    }

    public static void xorBit(byte[] bytes, int byteIndex, int index) throws IllegalArgumentException {
        ByteUtil.xorBits(bytes, byteIndex, new int[]{index});
    }

    public static byte xorBits(byte b, byte mask) {
        return (byte)(b ^ mask);
    }

    public static byte xorBits(byte b, int[] indices) throws IllegalArgumentException {
        if (indices == null || indices.length == 0) {
            return b;
        }
        byte mask = ByteUtil.createBitMask(indices);
        return ByteUtil.xorBits(b, mask);
    }

    public static byte[] xorBits(byte[] bytes, byte[] mask) throws IllegalArgumentException {
        if (bytes == null) {
            throw new IllegalArgumentException("byte[]-array not permitted as null for xor");
        }
        if (mask == null || mask.length == 0) {
            return ByteUtil.copy(bytes);
        }
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ByteUtil.xorBits(bytes[i], mask[i % mask.length]);
        }
        return result;
    }

    public static void xorBits(byte[] bytes, int byteIndex, byte mask) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex);
        bytes[byteIndex] = ByteUtil.xorBits(bytes[byteIndex], mask);
    }

    public static void xorBits(byte[] bytes, int byteIndex, int[] indices) throws IllegalArgumentException {
        ByteUtil.checkBytesAndByteIndex(bytes, byteIndex);
        if (indices == null || indices.length == 0) {
            return;
        }
        byte mask = ByteUtil.createBitMask(indices);
        bytes[byteIndex] = ByteUtil.xorBits(bytes[byteIndex], mask);
    }

    public static void xorBitsInternal(byte[] bytes, byte[] mask) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        if (mask == null || mask.length == 0) {
            return;
        }
        byte[] result = ByteUtil.copy(bytes);
        for (int i = 0; i < result.length; ++i) {
            bytes[i] = ByteUtil.xorBits(result[i], mask[i % mask.length]);
        }
    }

    public static void and(byte[] bytes, byte[] mask) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        if (mask == null || mask.length == 0) {
            return;
        }
        if (mask.length != bytes.length) {
            return;
        }
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(bytes[i] & mask[i]);
        }
    }

    public static boolean equals(byte[] bytes1, byte[] bytes2) {
        return Arrays.equals(bytes1, bytes2);
    }

    public static ArrayCompareDifference<Byte> firstDifference(byte[] bytes1, byte[] bytes2) {
        ArrayCompareDifference<Byte> result = null;
        if (!ByteUtil.equals(bytes1, bytes2)) {
            if (ArrayUtil.isNullOrEmpty(bytes1) && !ArrayUtil.isNullOrEmpty(bytes2)) {
                result = new ArrayCompareDifference<Byte>(0, null, bytes2[0], Byte.class);
            } else if (!ArrayUtil.isNullOrEmpty(bytes1) && ArrayUtil.isNullOrEmpty(bytes2)) {
                result = new ArrayCompareDifference<Byte>(0, bytes1[0], null, Byte.class);
            } else {
                for (int i = 0; i < Math.max(bytes1.length, bytes2.length); ++i) {
                    if (i >= bytes1.length) {
                        result = new ArrayCompareDifference<Byte>(i, null, bytes2[i], Byte.class);
                        break;
                    }
                    if (i >= bytes2.length) {
                        result = new ArrayCompareDifference<Byte>(i, bytes1[i], null, Byte.class);
                        break;
                    }
                    if (bytes1[i] == bytes2[i]) continue;
                    result = new ArrayCompareDifference<Byte>(i, bytes1[i], bytes2[i], Byte.class);
                    break;
                }
            }
        }
        return result;
    }

    public static List<ArrayCompareDifference<Byte>> compare(byte[] bytes1, byte[] bytes2) {
        ArrayList<ArrayCompareDifference<Byte>> result = new ArrayList<ArrayCompareDifference<Byte>>();
        if (!ByteUtil.equals(bytes1, bytes2)) {
            if (ArrayUtil.isNullOrEmpty(bytes1) && !ArrayUtil.isNullOrEmpty(bytes2)) {
                for (int i = 0; i < bytes2.length; ++i) {
                    result.add(new ArrayCompareDifference<Byte>(i, null, bytes2[i], Byte.class));
                }
            } else if (!ArrayUtil.isNullOrEmpty(bytes1) && ArrayUtil.isNullOrEmpty(bytes2)) {
                for (int i = 0; i < bytes1.length; ++i) {
                    result.add(new ArrayCompareDifference<Byte>(i, bytes1[i], null, Byte.class));
                }
            } else {
                for (int i = 0; i < Math.max(bytes1.length, bytes2.length); ++i) {
                    if (i >= bytes1.length) {
                        result.add(new ArrayCompareDifference<Byte>(i, null, bytes2[i], Byte.class));
                        continue;
                    }
                    if (i >= bytes2.length) {
                        result.add(new ArrayCompareDifference<Byte>(i, bytes1[i], null, Byte.class));
                        continue;
                    }
                    if (bytes1[i] == bytes2[i]) continue;
                    result.add(new ArrayCompareDifference<Byte>(i, bytes1[i], bytes2[i], Byte.class));
                }
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public static byte[] removeLeadingZero(byte[] arg) throws IllegalArgumentException {
        if (arg == null || arg.length == 0) {
            throw new IllegalArgumentException("null or empty array not permitted");
        }
        if (arg[0] != 0) {
            return arg;
        }
        return ByteUtil.subbytes(arg, 1);
    }

    public static byte[] addLeadingZero(byte[] arg) {
        if (arg == null || arg.length == 0) {
            throw new IllegalArgumentException("null or empty array not permitted");
        }
        if (arg[0] == 0) {
            return arg;
        }
        return ByteUtil.combine(new byte[]{0}, arg);
    }

    public static byte[] trimByteArray(byte[] tmp, int trimLen) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(tmp, "byte array to trim");
        byte[] lTmp = tmp;
        if (lTmp.length > trimLen + 1) {
            throw new IllegalArgumentException("removing more than one zero not supported");
        }
        if (lTmp.length > trimLen) {
            lTmp = ByteUtil.removeLeadingZero(lTmp);
        } else if (lTmp.length < trimLen) {
            byte[] f = new byte[trimLen - lTmp.length];
            ByteUtil.fill(f, (byte)0);
            lTmp = ByteUtil.combine(f, lTmp);
        }
        return lTmp;
    }

    public static byte[] cutByteArray(byte[] array, int length) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException("array not permitted as null");
        }
        if (length < 0) {
            throw new IllegalArgumentException("negative array length not permitted");
        }
        if (length > array.length) {
            throw new IllegalArgumentException("array length not permitted, greater length of array");
        }
        if (length == array.length) {
            return array;
        }
        if (length == 0) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        byte[] tmpBuffer = new byte[length];
        System.arraycopy(array, 0, tmpBuffer, 0, length);
        return tmpBuffer;
    }

    public static byte[] cutByteArrayFromEnd(byte[] array, int length) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException("array not permitted as null");
        }
        if (length < 0) {
            throw new IllegalArgumentException("negative array length not permitted");
        }
        if (length > array.length) {
            throw new IllegalArgumentException("array length not permitted, greater length of array");
        }
        if (length == array.length) {
            return array;
        }
        if (length == 0) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        byte[] tmp = new byte[length];
        System.arraycopy(array, length, tmp, 0, array.length - length);
        return tmp;
    }
}

