/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.StringRepresentable;
import java.util.ArrayList;
import java.util.Arrays;

public class ByteMatcher
implements StringRepresentable {
    private byte[][] matches = null;
    private byte[] significantBitsMask = null;
    private int length = 0;

    public ByteMatcher(byte[] matches) throws IllegalArgumentException {
        this(new byte[][]{matches}, null);
    }

    public ByteMatcher(byte[][] matches) throws IllegalArgumentException {
        this(matches, null);
    }

    public ByteMatcher(byte[] matches, byte[] significantBitsMask) throws IllegalArgumentException {
        this(new byte[][]{matches}, significantBitsMask);
    }

    public ByteMatcher(byte[][] matches, byte[] significantBitsMask) throws IllegalArgumentException {
        if (matches == null) {
            throw new IllegalArgumentException("matches not permitted as null");
        }
        if (matches.length == 0) {
            throw new IllegalArgumentException("matches not permitted as empty array");
        }
        if (significantBitsMask != null && significantBitsMask.length == 0) {
            throw new IllegalArgumentException("when specified empty mask for significant bits not permitted as empty array");
        }
        this.length = 0;
        ArrayList<byte[]> listMatches = new ArrayList<byte[]>();
        for (int i = 0; i < matches.length; ++i) {
            AssertUtil.notNullOrEmpty(matches[i], "matches entry");
            if (this.length == 0) {
                this.length = matches[i].length;
            }
            if (this.length != matches[i].length) {
                throw new IllegalArgumentException("entries with different length in matches not permitted");
            }
            listMatches.add(ByteUtil.copy(matches[i]));
        }
        this.matches = (byte[][])listMatches.toArray((T[])new byte[0][0]);
        if (significantBitsMask != null && significantBitsMask.length != this.length) {
            throw new IllegalArgumentException("significant bit mask with different length as entries of  matches not permitted");
        }
        this.significantBitsMask = significantBitsMask != null ? ByteUtil.copy(significantBitsMask) : null;
    }

    public boolean match(byte[] bytes) {
        if (ArrayUtil.isNullOrEmpty(bytes)) {
            return false;
        }
        boolean result = false;
        byte[] tmp = null;
        tmp = bytes.length > this.length ? ByteUtil.subbytes(bytes, 0, this.length) : ByteUtil.copy(bytes);
        if (tmp != null && this.length == tmp.length) {
            if (this.significantBitsMask != null) {
                ByteUtil.and(tmp, this.significantBitsMask);
            }
            byte[] search = tmp;
            for (int i = 0; i < this.matches.length; ++i) {
                if (!Arrays.equals(search, this.matches[i])) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString() + "\n");
        buffer.append("Matches:\n");
        for (byte[] m : this.matches) {
            buffer.append("   " + HexUtil.hexify(m) + "\n");
        }
        buffer.append("Significant Bit Mask:\n");
        buffer.append("   " + HexUtil.hexify(this.significantBitsMask) + "\n");
        return buffer.toString();
    }
}

