/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.CharUtil;

public final class BCDUtil {
    public static final int BCD_NIBBLE_MAXIMUM = 9;
    public static final char BCD_NIBBLE_ASCII_MAXIMUM = "9".toCharArray()[0];
    public static final char BCD_NIBBLE_ASCII_MINIMUM = "0".toCharArray()[0];
    public static final byte BYTE_ASCII_ZERO = "0".getBytes()[0];

    private BCDUtil() {
    }

    public static String convert(byte[] bcdBytes) throws IllegalArgumentException {
        if (ArrayUtil.isNullOrEmpty(bcdBytes)) {
            return "";
        }
        Object result = "";
        for (int i = 0; i < bcdBytes.length; ++i) {
            byte fb = (byte)(bcdBytes[i] >>> 4 & 0xF);
            byte sb = (byte)(bcdBytes[i] & 0xF);
            if (fb > 9) {
                throw new IllegalArgumentException("illegal byte value for BCD at index " + i + " (second nibble)");
            }
            if (sb > 9) {
                throw new IllegalArgumentException("illegal byte value for BCD at index " + i + " (lower nibble)");
            }
            fb = (byte)(fb | BYTE_ASCII_ZERO);
            sb = (byte)(sb | BYTE_ASCII_ZERO);
            result = (String)result + String.valueOf(CharUtil.convert(fb));
            result = (String)result + String.valueOf(CharUtil.convert(sb));
        }
        return result;
    }

    public static byte[] convert(String bcdString) throws IllegalArgumentException {
        return ByteUtil.convertBCD(bcdString);
    }
}

