/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.ClassUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.NumInterval;
import de.bos_bremen.common.Numbers;
import de.bos_bremen.common.ObjectUtil;
import de.bos_bremen.common.StringUtil;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AssertUtil {
    public static final String MESSAGE_CHECK_FAILED_ARRAY_NULL = "%1s not permitted as null";
    public static final String MESSAGE_CHECK_FAILED_ARRAY_NOT_NULL = "%1s only permitted as null";
    public static final String MESSAGE_CHECK_FAILED_ARRAY_NULL_OR_EMPTY = "%1s not permitted as null or empty array";
    public static final String MESSAGE_CHECK_FAILED_ARRAY_NOT_NULL_OR_EMPTY = "%1s only permitted as null or empty array";
    public static final String MESSAGE_CHECK_FAILED_ARRAY_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE = "%1s not permitted as null or empty array or contain null";
    public static final String MESSAGE_CHECK_FAILED_ARRAY_NOT_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE = "%1s only permitted as null or empty array or contain null";
    public static final String MESSAGE_CHECK_FAILED_OBJECT_NULL = "%1s not permitted as null";
    public static final String MESSAGE_CHECK_FAILED_OBJECT_NOT_NULL = "%1s only permitted as null";
    public static final String MESSAGE_CHECK_FAILED_TRUE = "%1s not permitted to be false";
    public static final String MESSAGE_CHECK_FAILED_FALSE = "%1s not permitted to be true";
    public static final String MESSAGE_CHECK_FAILED_EQUALS = "%1s expected to be equal, %2s <> %3s, expected: %4s";
    public static final String MESSAGE_CHECK_FAILED_NOT_EQUALS = "%1s not expected to be equal, not expected: %2s == %3s";
    public static final String MESSAGE_CHECK_FAILED_COLLECTION_NULL = "Collection%1sis not permitted as null";
    public static final String MESSAGE_CHECK_FAILED_COLLECTION_NOT_NULL = "Collection%1sis only permitted as null";
    public static final String MESSAGE_CHECK_FAILED_COLLECTION_NULL_OR_EMPTY = "Collection%1sis not permitted as null or empty Collection";
    public static final String MESSAGE_CHECK_FAILED_COLLECTION_NOT_NULL_OR_EMPTY = "Collection%1sis only permitted as null or empty Collection";
    public static final String MESSAGE_CHECK_FAILED_COLLECTION_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE = "Collection%1sis not permitted as null or empty Collection or contain null";
    public static final String MESSAGE_CHECK_FAILED_COLLECTION_NOT_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE = "Collection%1sis only permitted as null or empty Collection or contain null";
    public static final String MESSAGE_CHECK_FAILED_LIST_NULL = "List%1sis not permitted as null";
    public static final String MESSAGE_CHECK_FAILED_LIST_NOT_NULL = "List%1sis only permitted as null";
    public static final String MESSAGE_CHECK_FAILED_LIST_NULL_OR_EMPTY = "List%1sis not permitted as null or empty List";
    public static final String MESSAGE_CHECK_FAILED_LIST_NOT_NULL_OR_EMPTY = "List%1sis only permitted as null or empty List";
    public static final String MESSAGE_CHECK_FAILED_LIST_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE = "List%1sis not permitted as null or empty List or contain null";
    public static final String MESSAGE_CHECK_FAILED_LIST_NOT_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE = "List%1sis only permitted as null or empty List or contain null";
    public static final String MESSAGE_CHECK_FAILED_MAP_NULL = "Map%1sis not permitted as null";
    public static final String MESSAGE_CHECK_FAILED_MAP_NOT_NULL = "Map%1sis only permitted as null";
    public static final String MESSAGE_CHECK_FAILED_MAP_NULL_OR_EMPTY = "Map%1sis not permitted as null or empty Map";
    public static final String MESSAGE_CHECK_FAILED_MAP_NOT_NULL_OR_EMPTY = "Map%1sis only permitted as null or empty Map";
    public static final String MESSAGE_CHECK_FAILED_MAP_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE = "Map%1sis not permitted as null or empty Map or contain null";
    public static final String MESSAGE_CHECK_FAILED_MAP_NOT_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE = "Map%1sis only permitted as null or empty Map or containing null";
    public static final String MESSAGE_CHECK_FAILED_SET_NULL = "Set%1sis not permitted as null";
    public static final String MESSAGE_CHECK_FAILED_SET_NOT_NULL = "Set%1sis only permitted as null";
    public static final String MESSAGE_CHECK_FAILED_SET_NULL_OR_EMPTY = "Set%1sis not permitted as null or empty Set";
    public static final String MESSAGE_CHECK_FAILED_SET_NOT_NULL_OR_EMPTY = "Set%1sis only permitted as null or empty Set";
    public static final String MESSAGE_CHECK_FAILED_SET_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE = "Set%1sis not permitted as null or empty Set or contain null";
    public static final String MESSAGE_CHECK_FAILED_SET_NOT_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE = "Set%1sis only permitted as null or empty Set or contain null";
    public static final String MESSAGE_CHECK_FAILED_STRING_NULL = "%1s not permitted as null";
    public static final String MESSAGE_CHECK_FAILED_STRING_NOT_NULL = "%1s only permitted as null";
    public static final String MESSAGE_CHECK_FAILED_STRING_NULL_OR_EMPTY = "%1s not permitted as null or empty String";
    public static final String MESSAGE_CHECK_FAILED_STRING_NOT_NULL_OR_EMPTY = "%1s only permitted as null or empty String";
    public static final String MESSAGE_CHECK_FAILED_NEGATIVE = "%1s expected to be negative, expected: value < 0, found: %2s >= 0";
    public static final String MESSAGE_CHECK_FAILED_ZERO_OR_NEGATIVE = "%1s expected to be zero or negative, expected:value <= 0, found: %2s > 0";
    public static final String MESSAGE_CHECK_FAILED_ZERO = "%1s expected to be zero, expected: value = 0, found: %2s <> 0";
    public static final String MESSAGE_CHECK_FAILED_NOT_ZERO = "%1s not expected to be zero, expected: value <> 0, found: %2s = 0";
    public static final String MESSAGE_CHECK_FAILED_ZERO_OR_POSITIVE = "%1s expected to be zero or positive, expected: value >= 0, found: %2s < 0";
    public static final String MESSAGE_CHECK_FAILED_POSITIVE = "%1s expected to be positive, expected: value > 0, found: %2s <= 0";
    public static final String MESSAGE_CHECK_FAILED_NUM_LESS = "%1s not as expected, expected relation '<', found: %2s >= %3s";
    public static final String MESSAGE_CHECK_FAILED_NUM_LESS_EQUALS = "%1s not as expected, expected relation '<=', found: %2s > %3s";
    public static final String MESSAGE_CHECK_FAILED_NUM_EQUALS = "%1s not as expected, expected relation '=', found: %2s <> %3s";
    public static final String MESSAGE_CHECK_FAILED_NUM_NOT_EQUALS = "%1s not as expected, expected relation '<>', found: %2s = %3s";
    public static final String MESSAGE_CHECK_FAILED_NUM_GREATER_EQUALS = "%1s not as expected, expected relation '>=', found: %2s < %3s";
    public static final String MESSAGE_CHECK_FAILED_NUM_GREATER = "%1s not as expected, expected relation '>', found: %2s <= %3s";
    public static final String MESSAGE_CHECK_FAILED_NUM_INSIDE = "%1s %2s expected to be inside of interval %3s";
    public static final String MESSAGE_CHECK_FAILED_NUM_OUTSIDE = "%1s %2s expected to be outside of interval %3s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL = "%1sClass is not permitted as null";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NOT_NULL = "%1sClass is only permitted as null, class: %2s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_INTERFACE = "%1sClass is not permitted as null and only permitted as an Interface, class: %2s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL_INTERFACE = "%1sClass is not permitted as null or as an Interface, class: %2s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_CLASS_OBJECT = "%1sClass is not permitted as null and only permitted as an Object Class, class: %2s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_CLASS_PRIMITIVE = "%1sClass is not permitted as null and only permitted as a primitive Class, class: %2s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL_CLASS_PRIMITIVE = "%1sClass is not permitted as null or a primitive Class, class: %2s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL_ARRAY_NOT_INTERFACE = "%1sClass is not permitted as null or an array Class and only permitted as an Interface, class: %2s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL_ARRAY_INTERFACE = "%1sClass is not permitted as null, an array Class or as an Interface, class: %2s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL_ARRAY_NOT_CLASS_OBJECT = "%1sClass is not permitted as null or an array Class and only permitted as an Object Class, class: %2s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL_ARRAY_NOT_CLASS_PRIMITIVE = "%1sClass is not permitted as null or an array Class and only permitted as a primitive Class, class: %2s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL_ARRAY_CLASS_PRIMITIVE = "%1sClass is not permitted as null, an array Class or a primitive Class, class: %2s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_ARRAY_NOT_INTERFACE = "%1sClass is not permitted as null and only permitted as an array Class and an Interface, class: %2s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_ARRAY_INTERFACE = "%1sClass is not permitted as null and only permitted as an array Class and not an Interface, class: %2s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_ARRAY_NOT_CLASS_OBJECT = "%1sClass is not permitted as null and only permitted as an array Class and an Object Class, class: %2s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_ARRAY_NOT_CLASS_PRIMITIVE = "%1sClass is not permitted as null and only permitted as an array Class and a primitive Class, class: %2s";
    public static final String MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_ARRAY_CLASS_PRIMITIVE = "%1sClass is not permitted as null and only permitted as an array Class and not a primitive Class, class: %2s";

    private AssertUtil() {
    }

    public static boolean[] notNull(boolean[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s not permitted as null", AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static byte[] notNull(byte[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s not permitted as null", AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static char[] notNull(char[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s not permitted as null", AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static void notNull(Collection<?> collection, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNull(collection)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_COLLECTION_NULL, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static double[] notNull(double[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s not permitted as null", AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static float[] notNull(float[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s not permitted as null", AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static int[] notNull(int[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s not permitted as null", AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static void notNull(List<?> list, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNull(list)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_LIST_NULL, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static long[] notNull(long[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s not permitted as null", AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static void notNull(Map<?, ?> map, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNull(map)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_MAP_NULL, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static Object[] notNull(Object[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s not permitted as null", AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static void notNull(Set<?> set, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNull(set)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_SET_NULL, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static short[] notNull(short[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s not permitted as null", AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static String notNull(String s, String message) throws IllegalArgumentException {
        if (StringUtil.isNull(s)) {
            throw new IllegalArgumentException(StringUtil.format("%1s not permitted as null", message != null ? message : "String"));
        }
        return s;
    }

    public static boolean[] notNullOrEmpty(boolean[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static byte[] notNullOrEmpty(byte[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static char[] notNullOrEmpty(char[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static void notNullOrEmpty(Collection<?> collection, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNullOrEmpty(collection)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_COLLECTION_NULL_OR_EMPTY, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static double[] notNullOrEmpty(double[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static float[] notNullOrEmpty(float[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static int[] notNullOrEmpty(int[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static void notNullOrEmpty(List<?> list, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNullOrEmpty(list)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_LIST_NULL_OR_EMPTY, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static long[] notNullOrEmpty(long[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static void notNullOrEmpty(Map<?, ?> map, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNullOrEmpty(map)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_MAP_NULL_OR_EMPTY, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static Object[] notNullOrEmpty(Object[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static void notNullOrEmpty(Set<?> set, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNullOrEmpty(set)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
    }

    public static short[] notNullOrEmpty(short[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static String notNullOrEmpty(String s, String message) throws IllegalArgumentException {
        if (StringUtil.isNullOrEmpty(s)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_STRING_NULL_OR_EMPTY, message != null ? message : "String"));
        }
        return s;
    }

    public static void notNullOrEmptyOrContainsNull(Collection<?> collection, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNullOrEmptyOrContainsNull(collection)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_COLLECTION_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static void notNullOrEmptyOrContainsNull(List<?> list, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNullOrEmptyOrContainsNull(list)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_LIST_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static void notNullOrEmptyOrContainsNull(Map<?, ?> map, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNullOrEmptyOrContainsNull(map)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_MAP_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static void notNullOrEmptyOrContainsNull(Object[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNullOrEmptyOrContainsNull(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE, AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void notNullOrEmptyOrContainsNull(Set<?> set, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNullOrEmptyOrContainsNull(set)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_SET_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static void notNull(Object object, String message) throws IllegalArgumentException {
        if (ObjectUtil.isNull(object)) {
            throw new IllegalArgumentException(StringUtil.format("%1s not permitted as null", AssertUtil.makeMessage(message, "Object")));
        }
    }

    public static <T> T notNullReturn(T object, String message) throws IllegalArgumentException {
        if (ObjectUtil.isNull(object)) {
            throw new IllegalArgumentException(StringUtil.format("%1s not permitted as null", AssertUtil.makeMessage(message, "Object")));
        }
        return object;
    }

    public static <T> Collection<T> notNullReturnCollection(Collection<T> collection, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNull(collection)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_COLLECTION_NULL, AssertUtil.makeSpaceMessageSpace(message)));
        }
        return collection;
    }

    public static <T> List<T> notNullReturnList(List<T> list, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNull(list)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_LIST_NULL, AssertUtil.makeSpaceMessageSpace(message)));
        }
        return list;
    }

    public static <T> Set<T> notNullReturnSet(Set<T> set, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNull(set)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_SET_NULL, AssertUtil.makeSpaceMessageSpace(message)));
        }
        return set;
    }

    public static <K, V> Map<K, V> notNullReturnMap(Map<K, V> map, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNull(map)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_MAP_NULL, AssertUtil.makeSpaceMessageSpace(message)));
        }
        return map;
    }

    public static <T> T[] notNullReturn(T[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s not permitted as null", AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static <T> T[] notNullOrEmptyReturn(T[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.isNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
        return array;
    }

    public static <T> Collection<T> notNullOrEmptyReturnCollection(Collection<T> collection, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNullOrEmpty(collection)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_COLLECTION_NULL_OR_EMPTY, AssertUtil.makeSpaceMessageSpace(message)));
        }
        return collection;
    }

    public static <T> List<T> notNullOrEmptyReturnList(List<T> list, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNullOrEmpty(list)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_LIST_NULL_OR_EMPTY, AssertUtil.makeSpaceMessageSpace(message)));
        }
        return list;
    }

    public static <T> Set<T> notNullOrEmptyReturnSet(Set<T> set, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNullOrEmpty(set)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_SET_NULL_OR_EMPTY, AssertUtil.makeSpaceMessageSpace(message)));
        }
        return set;
    }

    public static <K, V> Map<K, V> notNullOrEmptyReturnMap(Map<K, V> map, String message) throws IllegalArgumentException {
        if (CollectionUtil.isNullOrEmpty(map)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_MAP_NULL_OR_EMPTY, AssertUtil.makeSpaceMessageSpace(message)));
        }
        return map;
    }

    public static void isNull(Object object, String message) throws IllegalArgumentException {
        if (!ObjectUtil.isNull(object)) {
            throw new IllegalArgumentException(StringUtil.format("%1s only permitted as null", AssertUtil.makeMessage(message, "Object")));
        }
    }

    public static void isTrue(boolean value, String message) throws IllegalArgumentException {
        if (!value) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_TRUE, AssertUtil.makeMessage(message, "value")));
        }
    }

    public static void isFalse(boolean value, String message) throws IllegalArgumentException {
        if (value) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_FALSE, AssertUtil.makeMessage(message, "value")));
        }
    }

    public static void equals(short value1, short value2, String message) throws IllegalArgumentException {
        if (value1 != value2) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_EQUALS, message != null ? message : "values", value1, value2, value1));
        }
    }

    public static void equals(int value1, int value2, String message) throws IllegalArgumentException {
        if (value1 != value2) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_EQUALS, message != null ? message : "values", value1, value2, value1));
        }
    }

    public static void equals(long value1, long value2, String message) throws IllegalArgumentException {
        if (value1 != value2) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_EQUALS, message != null ? message : "values", value1, value2, value1));
        }
    }

    public static void equals(double value1, double value2, String message) throws IllegalArgumentException {
        if (value1 != value2) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_EQUALS, message != null ? message : "values", value1, value2, value1));
        }
    }

    public static void equals(float value1, float value2, String message) throws IllegalArgumentException {
        if (value1 != value2) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_EQUALS, message != null ? message : "values", Float.valueOf(value1), Float.valueOf(value2), Float.valueOf(value1)));
        }
    }

    public static void equals(byte value1, byte value2, String message) throws IllegalArgumentException {
        if (value1 != value2) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_EQUALS, message != null ? message : "values", value1, value2, value1));
        }
    }

    public static void equals(boolean value1, boolean value2, String message) throws IllegalArgumentException {
        if (value1 != value2) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_EQUALS, message != null ? message : "values", value1, value2, value1));
        }
    }

    public static void equals(char value1, char value2, String message) throws IllegalArgumentException {
        if (value1 != value2) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_EQUALS, message != null ? message : "values", Character.valueOf(value1), Character.valueOf(value2), Character.valueOf(value1)));
        }
    }

    public static void equals(Integer value1, Integer value2, String message) throws IllegalArgumentException {
        AssertUtil.equalsInt(value1, value2, message);
    }

    public static void equals(Long value1, Long value2, String message) throws IllegalArgumentException {
        AssertUtil.equalsInt(value1, value2, message);
    }

    public static void equals(Short value1, Short value2, String message) throws IllegalArgumentException {
        AssertUtil.equalsInt(value1, value2, message);
    }

    public static void equals(Double value1, Double value2, String message) throws IllegalArgumentException {
        AssertUtil.equalsInt(value1, value2, message);
    }

    public static void equals(Float value1, Float value2, String message) throws IllegalArgumentException {
        AssertUtil.equalsInt(value1, value2, message);
    }

    public static void equals(Byte value1, Byte value2, String message) throws IllegalArgumentException {
        AssertUtil.equalsInt(value1, value2, message);
    }

    public static void equals(Boolean value1, Boolean value2, String message) throws IllegalArgumentException {
        AssertUtil.equalsInt(value1, value2, message);
    }

    public static void equals(Character value1, Character value2, String message) throws IllegalArgumentException {
        AssertUtil.equalsInt(value1, value2, message);
    }

    public static void equals(BigInteger value1, BigInteger value2, String message) throws IllegalArgumentException {
        AssertUtil.equalsInt(value1, value2, message);
    }

    public static void equals(Object value1, Object value2, String message) throws IllegalArgumentException {
        AssertUtil.equalsInt(value1, value2, message);
    }

    public static void equals(String value1, String value2, String message) throws IllegalArgumentException {
        AssertUtil.equalsInt(value1, value2, message);
    }

    public static void notEquals(Object value1, Object value2, String message) throws IllegalArgumentException {
        AssertUtil.notEqualsInt(value1, value2, message);
    }

    public static void notEquals(String value1, String value2, String message) throws IllegalArgumentException {
        AssertUtil.notEqualsInt(value1, value2, message);
    }

    private static void equalsInt(Object value1, Object value2, String message) throws IllegalArgumentException {
        if (ObjectUtil.notEquals(value1, value2)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_EQUALS, message != null ? message : "values", value1, value2, value1));
        }
    }

    private static void notEqualsInt(Object value1, Object value2, String message) throws IllegalArgumentException {
        if (ObjectUtil.isEquals(value1, value2)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NOT_EQUALS, message != null ? message : "values", value1, value2, value1));
        }
    }

    public static <T extends Number> void negative(T value, String message) throws IllegalArgumentException {
        if (!Numbers.isNegative(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NEGATIVE, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void zeroOrNegative(T value, String message) throws IllegalArgumentException {
        if (!Numbers.isZeroOrNegative(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ZERO_OR_NEGATIVE, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void zero(T value, String message) throws IllegalArgumentException {
        if (!Numbers.isZero(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ZERO, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void notZero(T value, String message) throws IllegalArgumentException {
        if (!Numbers.notZero(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NOT_ZERO, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void zeroOrPositive(T value, String message) throws IllegalArgumentException {
        if (!Numbers.isZeroOrPositive(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ZERO_OR_POSITIVE, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void positive(T value, String message) throws IllegalArgumentException {
        if (!Numbers.isPositive(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_POSITIVE, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void less(T a, T b, String message) throws IllegalArgumentException {
        if (!Numbers.isLess(a, b)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NUM_LESS, message != null ? message : "values", a, b));
        }
    }

    public static <T extends Number> void lessEquals(T a, T b, String message) throws IllegalArgumentException {
        if (!Numbers.isLessEquals(a, b)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NUM_LESS_EQUALS, message != null ? message : "values", a, b));
        }
    }

    public static <T extends Number> void equals(T a, T b, String message) throws IllegalArgumentException {
        if (!Numbers.isEquals(a, b)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NUM_EQUALS, message != null ? message : "values", a, b));
        }
    }

    public static <T extends Number> void notEquals(T a, T b, String message) throws IllegalArgumentException {
        if (!Numbers.notEquals(a, b)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NUM_NOT_EQUALS, message != null ? message : "values", a, b));
        }
    }

    public static <T extends Number> void greaterEquals(T a, T b, String message) throws IllegalArgumentException {
        if (!Numbers.isGreaterEquals(a, b)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NUM_GREATER_EQUALS, message != null ? message : "values", a, b));
        }
    }

    public static <T extends Number> void greater(T a, T b, String message) throws IllegalArgumentException {
        if (!Numbers.isGreater(a, b)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NUM_GREATER, message != null ? message : "values", a, b));
        }
    }

    public static <T extends Number> void negativeInfinity(T value, String message) throws IllegalArgumentException {
        if (!Numbers.isNegativeInfinity(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NOT_ZERO, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void notNegativeInfinity(T value, String message) throws IllegalArgumentException {
        if (!Numbers.notNegativeInfinity(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NOT_ZERO, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void positiveInfinity(T value, String message) throws IllegalArgumentException {
        if (!Numbers.isPositiveInfinity(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NOT_ZERO, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void notPositiveInfinity(T value, String message) throws IllegalArgumentException {
        if (!Numbers.notPositiveInfinity(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NOT_ZERO, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void min(T value, String message) throws IllegalArgumentException {
        if (!Numbers.isMin(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NOT_ZERO, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void notMin(T value, String message) throws IllegalArgumentException {
        if (!Numbers.notMin(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NOT_ZERO, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void max(T value, String message) throws IllegalArgumentException {
        if (!Numbers.isMax(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NOT_ZERO, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void notMax(T value, String message) throws IllegalArgumentException {
        if (!Numbers.notMax(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NOT_ZERO, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void naN(T value, String message) throws IllegalArgumentException {
        if (!Numbers.isNaN(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NOT_ZERO, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void notNaN(T value, String message) throws IllegalArgumentException {
        if (!Numbers.notNaN(value)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NOT_ZERO, AssertUtil.makeMessage(message, "value"), value));
        }
    }

    public static <T extends Number> void inside(T value, NumInterval<T> interval, String message) {
        if (!Numbers.isInside(value, interval)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NUM_INSIDE, AssertUtil.makeMessage(message, "value"), value, interval != null ? interval.toSimpleString() : null));
        }
    }

    public static <T extends Number> void outside(T value, NumInterval<T> interval, String message) throws IllegalArgumentException {
        if (!Numbers.isOutside(value, interval)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_NUM_OUTSIDE, AssertUtil.makeMessage(message, "value"), value, interval != null ? interval.toSimpleString() : null));
        }
    }

    public static void isNull(boolean[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s only permitted as null", AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNull(byte[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s only permitted as null", AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNull(char[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s only permitted as null", AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNull(Collection<?> collection, String message) throws IllegalArgumentException {
        if (CollectionUtil.notNull(collection)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_COLLECTION_NOT_NULL, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static void isNull(double[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s only permitted as null", AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNull(float[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s only permitted as null", AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNull(int[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s only permitted as null", AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNull(List<?> list, String message) throws IllegalArgumentException {
        if (CollectionUtil.notNull(list)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_LIST_NOT_NULL, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static void isNull(long[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s only permitted as null", AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNull(Map<?, ?> map, String message) throws IllegalArgumentException {
        if (CollectionUtil.notNull(map)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_MAP_NOT_NULL, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static void isNull(Object[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s only permitted as null", AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNull(Set<?> set, String message) throws IllegalArgumentException {
        if (CollectionUtil.notNull(set)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_SET_NOT_NULL, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static void isNull(short[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNull(array)) {
            throw new IllegalArgumentException(StringUtil.format("%1s only permitted as null", AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNull(String s, String message) throws IllegalArgumentException {
        if (StringUtil.notNull(s)) {
            throw new IllegalArgumentException(StringUtil.format("%1s only permitted as null", message != null ? message : "String"));
        }
    }

    public static void isNullOrEmpty(boolean[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NOT_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNullOrEmpty(byte[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NOT_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNullOrEmpty(char[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NOT_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNullOrEmpty(Collection<?> collection, String message) throws IllegalArgumentException {
        if (CollectionUtil.notNullOrEmpty(collection)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_COLLECTION_NOT_NULL_OR_EMPTY, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static void isNullOrEmpty(double[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NOT_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNullOrEmpty(float[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NOT_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNullOrEmpty(int[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NOT_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNullOrEmpty(List<?> list, String message) throws IllegalArgumentException {
        if (CollectionUtil.notNullOrEmpty(list)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_LIST_NOT_NULL_OR_EMPTY, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static void isNullOrEmpty(long[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NOT_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNullOrEmpty(Map<?, ?> map, String message) throws IllegalArgumentException {
        if (CollectionUtil.notNullOrEmpty(map)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_MAP_NOT_NULL_OR_EMPTY, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static void isNullOrEmpty(Object[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NOT_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNullOrEmpty(Set<?> set, String message) throws IllegalArgumentException {
        if (CollectionUtil.notNullOrEmpty(set)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NOT_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNullOrEmpty(short[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNullOrEmpty(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NOT_NULL_OR_EMPTY, AssertUtil.makeMessage(message, "array")));
        }
    }

    public static void isNullOrEmpty(String s, String message) throws IllegalArgumentException {
        if (StringUtil.isNullOrEmpty(s)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_STRING_NULL_OR_EMPTY, message != null ? message : "String"));
        }
    }

    public static void isNullOrEmptyOrContainsNull(Collection<?> collection, String message) throws IllegalArgumentException {
        if (CollectionUtil.notNullOrEmptyOrContainsNull(collection)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_COLLECTION_NOT_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static void isNullOrEmptyOrContainsNull(List<?> list, String message) throws IllegalArgumentException {
        if (CollectionUtil.notNullOrEmptyOrContainsNull(list)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_LIST_NOT_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static void isNullOrEmptyOrContainsNull(Map<?, ?> map, String message) throws IllegalArgumentException {
        if (CollectionUtil.notNullOrEmptyOrContainsNull(map)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_MAP_NOT_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    public static void isNullOrEmptyOrContainsNull(Object[] array, String message) throws IllegalArgumentException {
        if (ArrayUtil.notNullOrEmptyOrContainsNull(array)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_ARRAY_NOT_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE, AssertUtil.makeMessage(message, "array")));
        }
    }

    private static String makeMessage(String message, String defaultName) {
        return message != null ? message : defaultName;
    }

    public static void isNullOrEmptyOrContainsNull(Set<?> set, String message) throws IllegalArgumentException {
        if (CollectionUtil.notNullOrEmptyOrContainsNull(set)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_SET_NOT_NULL_OR_EMPTY_OR_CONTAINS_NULL_VALUE, AssertUtil.makeSpaceMessageSpace(message)));
        }
    }

    private static String makeSpaceMessageSpace(String message) {
        return StringUtil.notNullOrEmpty(message) ? " " + message + " " : " ";
    }

    private static String makeMessageSpace(String message) {
        return StringUtil.notNullOrEmpty(message) ? message + " " : "";
    }

    public static void notNull(Class<?> c, String message) throws IllegalArgumentException {
        if (ClassUtil.isNull(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL, AssertUtil.makeMessageSpace(message)));
        }
    }

    public static void isNull(Class<?> c, String message) throws IllegalArgumentException {
        if (ClassUtil.notNull(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NOT_NULL, AssertUtil.makeMessageSpace(message), c));
        }
    }

    public static void notNullInterface(Class<?> c, String message) throws IllegalArgumentException {
        if (!ClassUtil.notNullInterface(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_INTERFACE, AssertUtil.makeMessageSpace(message), c));
        }
    }

    public static void notNullNotInterface(Class<?> c, String message) throws IllegalArgumentException {
        if (!ClassUtil.notNullNotInterface(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL_INTERFACE, AssertUtil.makeMessageSpace(message), c));
        }
    }

    public static void notNullClassObject(Class<?> c, String message) throws IllegalArgumentException {
        if (!ClassUtil.notNullClassObject(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_CLASS_OBJECT, AssertUtil.makeMessageSpace(message), c));
        }
    }

    public static void notNullClassPrimitive(Class<?> c, String message) throws IllegalArgumentException {
        if (!ClassUtil.notNullClassPrimitive(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_CLASS_PRIMITIVE, AssertUtil.makeMessageSpace(message), c));
        }
    }

    public static void notNullNotClassPrimitive(Class<?> c, String message) throws IllegalArgumentException {
        if (!ClassUtil.notNullNotClassPrimitive(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL_CLASS_PRIMITIVE, AssertUtil.makeMessageSpace(message), c));
        }
    }

    public static void notNullNotArrayInterface(Class<?> c, String message) throws IllegalArgumentException {
        if (!ClassUtil.notNullNotArrayInterface(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL_ARRAY_NOT_INTERFACE, AssertUtil.makeMessageSpace(message), c));
        }
    }

    public static void notNullNotArrayNotInterface(Class<?> c, String message) throws IllegalArgumentException {
        if (!ClassUtil.notNullNotArrayNotInterface(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL_ARRAY_INTERFACE, AssertUtil.makeMessageSpace(message), c));
        }
    }

    public static void notNullNotArrayClassObject(Class<?> c, String message) throws IllegalArgumentException {
        if (!ClassUtil.notNullNotArrayClassObject(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL_ARRAY_NOT_CLASS_OBJECT, AssertUtil.makeMessageSpace(message), c));
        }
    }

    public static void notNullNotArrayClassPrimitive(Class<?> c, String message) throws IllegalArgumentException {
        if (!ClassUtil.notNullNotArrayClassPrimitive(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL_ARRAY_NOT_CLASS_PRIMITIVE, AssertUtil.makeMessageSpace(message), c));
        }
    }

    public static void notNullNotArrayNotClassPrimitive(Class<?> c, String message) throws IllegalArgumentException {
        if (!ClassUtil.notNullNotArrayNotClassPrimitive(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL_ARRAY_CLASS_PRIMITIVE, AssertUtil.makeMessageSpace(message), c));
        }
    }

    public static void notNullArrayInterface(Class<?> c, String message) throws IllegalArgumentException {
        if (!ClassUtil.notNullArrayInterface(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_ARRAY_NOT_INTERFACE, AssertUtil.makeMessageSpace(message), c));
        }
    }

    public static void notNullArrayNotInterface(Class<?> c, String message) throws IllegalArgumentException {
        if (!ClassUtil.notNullArrayNotInterface(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_ARRAY_INTERFACE, AssertUtil.makeMessageSpace(message), c));
        }
    }

    public static void notNullArrayClassObject(Class<?> c, String message) throws IllegalArgumentException {
        if (!ClassUtil.notNullArrayClassObject(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_ARRAY_NOT_CLASS_OBJECT, AssertUtil.makeMessageSpace(message), c));
        }
    }

    public static void notNullArrayClassPrimitive(Class<?> c, String message) throws IllegalArgumentException {
        if (!ClassUtil.notNullArrayClassPrimitive(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_ARRAY_NOT_CLASS_PRIMITIVE, AssertUtil.makeMessageSpace(message), c));
        }
    }

    public static void notNullArrayNotClassPrimitive(Class<?> c, String message) throws IllegalArgumentException {
        if (!ClassUtil.notNullArrayNotClassPrimitive(c)) {
            throw new IllegalArgumentException(StringUtil.format(MESSAGE_CHECK_FAILED_CLASS_NULL_NOT_ARRAY_CLASS_PRIMITIVE, AssertUtil.makeMessageSpace(message), c));
        }
    }
}

