/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.Numbers;
import de.bos_bremen.common.constants.Constants;
import java.lang.reflect.Array;
import java.util.ArrayList;

public final class ArrayUtil {
    public static final String MESSAGE_FAILED_CONVERSION_NOT_POSSIBLE_ARRAY_CONTAINS_NULL = "no conversion possible array contains null";
    public static final String MESSAGE_FAILED_ARRAY_NULL = "array not permitted as null";

    private ArrayUtil() {
    }

    public static <T> T[] combine(Class<T> typeClass, T[] ... objectArrays) {
        if (objectArrays == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        if (objectArrays.length > 0) {
            for (T[] objectArray : objectArrays) {
                if (objectArray == null || objectArray.length <= 0) continue;
                for (T object : objectArray) {
                    result.add(object);
                }
            }
        }
        return result.toArray((Object[])Array.newInstance(typeClass, 0));
    }

    public static Object[] combine(Object[] ... objectArrays) {
        return ArrayUtil.combine(Object.class, objectArrays);
    }

    public static Object[] copy(Object[] objects) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return Constants.EMPTY_OBJECT_ARRAY;
        }
        Object[] result = new Object[objects.length];
        System.arraycopy(objects, 0, result, 0, objects.length);
        return result;
    }

    public static boolean[] copy(boolean[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_PRIMITIVE_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static byte[] copy(byte[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        byte[] result = new byte[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static char[] copy(char[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_PRIMITIVE_CHARACTER_ARRAY;
        }
        char[] result = new char[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static short[] copy(short[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_PRIMITIVE_SHORT_ARRAY;
        }
        short[] result = new short[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static int[] copy(int[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_PRIMITIVE_INTEGER_ARRAY;
        }
        int[] result = new int[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static long[] copy(long[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_PRIMITIVE_LONG_ARRAY;
        }
        long[] result = new long[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static float[] copy(float[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_PRIMITIVE_FLOAT_ARRAY;
        }
        float[] result = new float[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static double[] copy(double[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_PRIMITIVE_DOUBLE_ARRAY;
        }
        double[] result = new double[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static Boolean[] copy(Boolean[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_BOOLEAN_ARRAY;
        }
        Boolean[] result = new Boolean[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static Byte[] copy(Byte[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_BYTE_ARRAY;
        }
        Byte[] result = new Byte[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static Character[] copy(Character[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_CHARACTER_ARRAY;
        }
        Character[] result = new Character[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static Short[] copy(Short[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_SHORT_ARRAY;
        }
        Short[] result = new Short[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static Integer[] copy(Integer[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_INTEGER_ARRAY;
        }
        Integer[] result = new Integer[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static Long[] copy(Long[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_LONG_ARRAY;
        }
        Long[] result = new Long[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static Float[] copy(Float[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_FLOAT_ARRAY;
        }
        Float[] result = new Float[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static Double[] copy(Double[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return Constants.EMPTY_DOUBLE_ARRAY;
        }
        Double[] result = new Double[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    public static boolean containsNull(Object[] array) {
        if (array == null || ArrayUtil.isEmpty(array)) {
            return false;
        }
        for (Object tmp : array) {
            if (tmp != null) continue;
            return true;
        }
        return false;
    }

    public static boolean notContainsNull(Object[] array) {
        return !ArrayUtil.containsNull(array);
    }

    public static boolean isEmpty(byte[] array) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_ARRAY_NULL);
        }
        return array.length == 0;
    }

    public static boolean notEmpty(byte[] array) throws IllegalArgumentException {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isEmpty(boolean[] array) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_ARRAY_NULL);
        }
        return array.length == 0;
    }

    public static boolean notEmpty(boolean[] array) throws IllegalArgumentException {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isEmpty(char[] array) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_ARRAY_NULL);
        }
        return array.length == 0;
    }

    public static boolean notEmpty(char[] array) throws IllegalArgumentException {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isEmpty(double[] array) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_ARRAY_NULL);
        }
        return array.length == 0;
    }

    public static boolean notEmpty(double[] array) throws IllegalArgumentException {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isEmpty(float[] array) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_ARRAY_NULL);
        }
        return array.length == 0;
    }

    public static boolean notEmpty(float[] array) throws IllegalArgumentException {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isEmpty(int[] array) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_ARRAY_NULL);
        }
        return array.length == 0;
    }

    public static boolean notEmpty(int[] array) throws IllegalArgumentException {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isEmpty(long[] array) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_ARRAY_NULL);
        }
        return array.length == 0;
    }

    public static boolean notEmpty(long[] array) throws IllegalArgumentException {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isEmpty(Object[] array) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_ARRAY_NULL);
        }
        return array.length == 0;
    }

    public static boolean notEmpty(Object[] array) throws IllegalArgumentException {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isEmpty(short[] array) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException(MESSAGE_FAILED_ARRAY_NULL);
        }
        return array.length == 0;
    }

    public static boolean notEmpty(short[] array) throws IllegalArgumentException {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isNull(byte[] array) {
        return array == null;
    }

    public static boolean notNull(byte[] array) {
        return !ArrayUtil.isNull(array);
    }

    public static boolean isNull(boolean[] array) {
        return array == null;
    }

    public static boolean notNull(boolean[] array) {
        return !ArrayUtil.isNull(array);
    }

    public static boolean isNull(char[] array) {
        return array == null;
    }

    public static boolean notNull(char[] array) {
        return !ArrayUtil.isNull(array);
    }

    public static boolean isNull(double[] array) {
        return array == null;
    }

    public static boolean notNull(double[] array) {
        return !ArrayUtil.isNull(array);
    }

    public static boolean isNull(float[] array) {
        return array == null;
    }

    public static boolean notNull(float[] array) {
        return !ArrayUtil.isNull(array);
    }

    public static boolean isNull(int[] array) {
        return array == null;
    }

    public static boolean notNull(int[] array) {
        return !ArrayUtil.isNull(array);
    }

    public static boolean isNull(long[] array) {
        return array == null;
    }

    public static boolean notNull(long[] array) {
        return !ArrayUtil.isNull(array);
    }

    public static boolean isNull(Object[] array) {
        return array == null;
    }

    public static boolean notNull(Object[] array) {
        return !ArrayUtil.isNull(array);
    }

    public static boolean isNull(short[] array) {
        return array == null;
    }

    public static boolean notNull(short[] array) {
        return !ArrayUtil.isNull(array);
    }

    public static boolean isNullOrEmpty(boolean[] array) {
        return ArrayUtil.isNull(array) || ArrayUtil.isEmpty(array);
    }

    public static boolean notNullOrEmpty(boolean[] array) {
        return !ArrayUtil.isNullOrEmpty(array);
    }

    public static boolean isNullOrEmpty(byte[] array) {
        return ArrayUtil.isNull(array) || ArrayUtil.isEmpty(array);
    }

    public static boolean notNullOrEmpty(byte[] array) {
        return !ArrayUtil.isNullOrEmpty(array);
    }

    public static boolean isNullOrEmpty(char[] array) {
        return ArrayUtil.isNull(array) || ArrayUtil.isEmpty(array);
    }

    public static boolean notNullOrEmpty(char[] array) {
        return !ArrayUtil.isNullOrEmpty(array);
    }

    public static boolean isNullOrEmpty(double[] array) {
        return ArrayUtil.isNull(array) || ArrayUtil.isEmpty(array);
    }

    public static boolean notNullOrEmpty(double[] array) {
        return !ArrayUtil.isNullOrEmpty(array);
    }

    public static boolean isNullOrEmpty(float[] array) {
        return ArrayUtil.isNull(array) || ArrayUtil.isEmpty(array);
    }

    public static boolean notNullOrEmpty(float[] array) {
        return !ArrayUtil.isNullOrEmpty(array);
    }

    public static boolean isNullOrEmpty(int[] array) {
        return ArrayUtil.isNull(array) || ArrayUtil.isEmpty(array);
    }

    public static boolean notNullOrEmpty(int[] array) {
        return !ArrayUtil.isNullOrEmpty(array);
    }

    public static boolean isNullOrEmpty(long[] array) {
        return ArrayUtil.isNull(array) || ArrayUtil.isEmpty(array);
    }

    public static boolean notNullOrEmpty(long[] array) {
        return !ArrayUtil.isNullOrEmpty(array);
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return ArrayUtil.isNull(array) || ArrayUtil.isEmpty(array);
    }

    public static boolean notNullOrEmpty(Object[] array) {
        return !ArrayUtil.isNullOrEmpty(array);
    }

    public static boolean isNullOrEmpty(short[] array) {
        return ArrayUtil.isNull(array) || ArrayUtil.isEmpty(array);
    }

    public static boolean notNullOrEmpty(short[] array) {
        return !ArrayUtil.isNullOrEmpty(array);
    }

    public static boolean isNullOrEmptyOrContainsNull(Object[] array) {
        return ArrayUtil.isNull(array) || ArrayUtil.isEmpty(array) || ArrayUtil.containsNull(array);
    }

    public static boolean notNullOrEmptyOrContainsNull(Object[] array) {
        return !ArrayUtil.isNullOrEmptyOrContainsNull(array);
    }

    public static Double[] to(double[] array) {
        if (ArrayUtil.isNull(array)) {
            return null;
        }
        Double[] result = new Double[array.length];
        if (ArrayUtil.isEmpty(array)) {
            return result;
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] to(Double[] array) throws IllegalArgumentException {
        if (ArrayUtil.isNull((Object[])array)) {
            return null;
        }
        double[] result = new double[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return result;
        }
        if (ArrayUtil.containsNull(array)) {
            throw new IllegalArgumentException(MESSAGE_FAILED_CONVERSION_NOT_POSSIBLE_ARRAY_CONTAINS_NULL);
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Float[] to(float[] array) {
        if (ArrayUtil.isNull(array)) {
            return null;
        }
        Float[] result = new Float[array.length];
        if (ArrayUtil.isEmpty(array)) {
            return result;
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    public static float[] to(Float[] array) {
        if (ArrayUtil.isNull((Object[])array)) {
            return null;
        }
        float[] result = new float[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return result;
        }
        if (ArrayUtil.containsNull(array)) {
            throw new IllegalArgumentException(MESSAGE_FAILED_CONVERSION_NOT_POSSIBLE_ARRAY_CONTAINS_NULL);
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].floatValue();
        }
        return result;
    }

    public static Short[] to(short[] array) {
        if (ArrayUtil.isNull(array)) {
            return null;
        }
        Short[] result = new Short[array.length];
        if (ArrayUtil.isEmpty(array)) {
            return result;
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static short[] to(Short[] array) {
        if (ArrayUtil.isNull((Object[])array)) {
            return null;
        }
        short[] result = new short[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return result;
        }
        if (ArrayUtil.containsNull(array)) {
            throw new IllegalArgumentException(MESSAGE_FAILED_CONVERSION_NOT_POSSIBLE_ARRAY_CONTAINS_NULL);
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Integer[] to(int[] array) {
        if (ArrayUtil.isNull(array)) {
            return null;
        }
        Integer[] result = new Integer[array.length];
        if (ArrayUtil.isEmpty(array)) {
            return result;
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static int[] to(Integer[] array) {
        if (ArrayUtil.isNull((Object[])array)) {
            return null;
        }
        int[] result = new int[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return result;
        }
        if (ArrayUtil.containsNull(array)) {
            throw new IllegalArgumentException(MESSAGE_FAILED_CONVERSION_NOT_POSSIBLE_ARRAY_CONTAINS_NULL);
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Long[] to(long[] array) {
        if (ArrayUtil.isNull(array)) {
            return null;
        }
        Long[] result = new Long[array.length];
        if (ArrayUtil.isEmpty(array)) {
            return result;
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static long[] to(Long[] array) {
        if (ArrayUtil.isNull((Object[])array)) {
            return null;
        }
        long[] result = new long[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return result;
        }
        if (ArrayUtil.containsNull(array)) {
            throw new IllegalArgumentException(MESSAGE_FAILED_CONVERSION_NOT_POSSIBLE_ARRAY_CONTAINS_NULL);
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Boolean[] to(boolean[] array) {
        if (ArrayUtil.isNull(array)) {
            return null;
        }
        Boolean[] result = new Boolean[array.length];
        if (ArrayUtil.isEmpty(array)) {
            return result;
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static boolean[] to(Boolean[] array) {
        if (ArrayUtil.isNull((Object[])array)) {
            return null;
        }
        boolean[] result = new boolean[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return result;
        }
        if (ArrayUtil.containsNull(array)) {
            throw new IllegalArgumentException(MESSAGE_FAILED_CONVERSION_NOT_POSSIBLE_ARRAY_CONTAINS_NULL);
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Character[] to(char[] array) {
        if (ArrayUtil.isNull(array)) {
            return null;
        }
        Character[] result = new Character[array.length];
        if (ArrayUtil.isEmpty(array)) {
            return result;
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = Character.valueOf(array[i]);
        }
        return result;
    }

    public static char[] to(Character[] array) {
        if (ArrayUtil.isNull((Object[])array)) {
            return null;
        }
        char[] result = new char[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return result;
        }
        if (ArrayUtil.containsNull(array)) {
            throw new IllegalArgumentException(MESSAGE_FAILED_CONVERSION_NOT_POSSIBLE_ARRAY_CONTAINS_NULL);
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].charValue();
        }
        return result;
    }

    public static Byte[] to(byte[] array) {
        if (ArrayUtil.isNull(array)) {
            return null;
        }
        Byte[] result = new Byte[array.length];
        if (ArrayUtil.isEmpty(array)) {
            return result;
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] to(Byte[] array) {
        if (ArrayUtil.isNull((Object[])array)) {
            return null;
        }
        byte[] result = new byte[array.length];
        if (ArrayUtil.isEmpty((Object[])array)) {
            return result;
        }
        if (ArrayUtil.containsNull(array)) {
            throw new IllegalArgumentException(MESSAGE_FAILED_CONVERSION_NOT_POSSIBLE_ARRAY_CONTAINS_NULL);
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static <T> T[] getEmptyArray(Class<T> clazz, Class<T[]> arrayClass) {
        return ArrayUtil.getArray(clazz, arrayClass, 0);
    }

    public static <T> T[] getArray(Class<T> clazz, Class<T[]> arrayClass, int size) {
        try {
            Object array = Array.newInstance(clazz, size);
            if (arrayClass == null) {
                return (Object[])array;
            }
            return arrayClass.cast(array);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T[] getEmptyArray(Class<T> clazz) {
        T[] result = ArrayUtil.getArray(clazz, null, 0);
        return result;
    }

    public static <T> T[] getArray(Class<T> clazz, int size) {
        T[] result = ArrayUtil.getArray(clazz, null, size);
        return result;
    }

    public static Class<?>[] addClass(Class<?>[] classes, Class<?>[] newClasses) {
        int lengthClasses = classes != null ? classes.length : 0;
        int lengthNewClasses = newClasses != null ? newClasses.length : 0;
        Class[] result = new Class[lengthClasses + lengthNewClasses];
        if (classes != null) {
            System.arraycopy(classes, 0, result, 0, lengthClasses);
        }
        if (newClasses != null) {
            System.arraycopy(newClasses, 0, result, lengthClasses, lengthNewClasses);
        }
        return result;
    }

    public static boolean contains(byte[] complete, byte[] part) throws IllegalArgumentException {
        AssertUtil.notNull(complete, "complete array");
        AssertUtil.notNull(part, "part array");
        if (Numbers.isLess(complete.length, part.length)) {
            throw new IllegalArgumentException("part must not be longer than complete");
        }
        for (int i = 0; i <= complete.length - part.length; ++i) {
            byte[] testPart = ByteUtil.subbytes(complete, i, part.length + i);
            if (!ByteUtil.equals(testPart, part)) continue;
            return true;
        }
        return false;
    }
}

