/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.impl;

import de.bos_bremen.basecard.terminal.pcsc.PCSCTerminal;
import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.java.pcsc.impl.DebugJPCSC;
import de.bos_bremen.jni.pcsc.PCSCException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WindowsPCSCTransactionManagementRunnable
implements Runnable {
    private long lastTerminalAccessTime = System.currentTimeMillis();
    private static final long DELAY = 1500L;
    private static Map<String, WindowsPCSCTransactionManagementRunnable> cache = new HashMap<String, WindowsPCSCTransactionManagementRunnable>();
    private static final Logger LOG = Logger.getLogger(WindowsPCSCTransactionManagementRunnable.class);
    private PCSCTerminal terminal;
    private final int slot;
    private Object wait = new Object();
    private RunState INIT = new RunState(){

        @Override
        public void run() {
            LOG.debug((Object)("STATE-INIT-" + WindowsPCSCTransactionManagementRunnable.this.getTerminalName()));
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public String toString() {
            return "STATE-INIT";
        }

        @Override
        public boolean isShutdown() {
            return false;
        }
    };
    private RunState DEACTIVATED = new RunState(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = WindowsPCSCTransactionManagementRunnable.this.wait;
            synchronized (object) {
                try {
                    WindowsPCSCTransactionManagementRunnable.this.wait.wait(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (WindowsPCSCTransactionManagementRunnable.this.currentState != this) {
                return;
            }
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public String toString() {
            return "STATE-DEACTIVATED-" + WindowsPCSCTransactionManagementRunnable.this.getTerminalName();
        }
    };
    private RunState ACTIVATED = new RunState(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = WindowsPCSCTransactionManagementRunnable.this.wait;
            synchronized (object) {
                try {
                    WindowsPCSCTransactionManagementRunnable.this.wait.wait(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (WindowsPCSCTransactionManagementRunnable.this.currentState != this) {
                return;
            }
            if (System.currentTimeMillis() - WindowsPCSCTransactionManagementRunnable.this.lastTerminalAccessTime >= 2000L) {
                try {
                    WindowsPCSCTransactionManagementRunnable.this.terminal.getStatus();
                }
                catch (Exception e) {
                    WindowsPCSCTransactionManagementRunnable windowsPCSCTransactionManagementRunnable = WindowsPCSCTransactionManagementRunnable.this;
                    synchronized (windowsPCSCTransactionManagementRunnable) {
                        WindowsPCSCTransactionManagementRunnable.this.currentState = WindowsPCSCTransactionManagementRunnable.this.DEACTIVATED;
                    }
                }
            }
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public String toString() {
            return "STATE-ACTIVATED-" + WindowsPCSCTransactionManagementRunnable.this.getTerminalName();
        }
    };
    private RunState SHUTDOWN = new RunState(){

        @Override
        public void run() {
            LOG.debug((Object)"STATE-SHUTDOWN");
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public boolean isShutdown() {
            return true;
        }

        @Override
        public String toString() {
            return "STATE-SHUTDOWN-" + WindowsPCSCTransactionManagementRunnable.this.terminal.getName();
        }
    };
    private RunState currentState = this.INIT;
    private String terminalName;

    public void updateAccessTime() {
        this.lastTerminalAccessTime = System.currentTimeMillis();
    }

    public static boolean isKeepAliveRequired() {
        return SystemEnum.getCurrentSystem().getGroup() == SystemEnum.SystemGroup.WINDOWS && DebugJPCSC.isPcscTransactionKeepAliveEnabled();
    }

    public static synchronized void removeKeyAliveRunnable(String terminalName) {
        WindowsPCSCTransactionManagementRunnable windowsPCSCTransactionManagementRunnable = cache.get(terminalName);
        if (windowsPCSCTransactionManagementRunnable != null) {
            windowsPCSCTransactionManagementRunnable.setActive(false);
            cache.remove(terminalName);
        }
    }

    static synchronized WindowsPCSCTransactionManagementRunnable createKeepAliveRunnable(PCSCTerminal terminal) {
        String terminalName = terminal.getName();
        WindowsPCSCTransactionManagementRunnable pcscTransactionKeepAliveRunnable = cache.get(terminalName);
        if (pcscTransactionKeepAliveRunnable != null) {
            return pcscTransactionKeepAliveRunnable;
        }
        boolean notRequired = !WindowsPCSCTransactionManagementRunnable.isKeepAliveRequired();
        pcscTransactionKeepAliveRunnable = new WindowsPCSCTransactionManagementRunnable(terminal, 0, notRequired);
        cache.put(terminalName, pcscTransactionKeepAliveRunnable);
        String msg = "Creating PC/SC transaction management thread required by new Windows versions for " + terminalName + ": ";
        LOG.debug((Object)(msg + "starting"));
        new Thread((Runnable)pcscTransactionKeepAliveRunnable, "pcscTransactionManagementThread-" + terminal.getName()).start();
        LOG.debug((Object)(msg + "started"));
        return pcscTransactionKeepAliveRunnable;
    }

    public String getTerminalName() {
        return this.terminalName;
    }

    public WindowsPCSCTransactionManagementRunnable(PCSCTerminal terminal, int slot, boolean neverRun) {
        this.terminal = terminal;
        this.terminalName = terminal.getName();
        this.slot = slot;
        this.currentState = neverRun ? this.SHUTDOWN : this.DEACTIVATED;
    }

    public void shutdown() {
        try {
            this.changeState(this.SHUTDOWN);
        }
        finally {
            cache.clear();
            this.terminal = null;
            this.wait = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.SHUTDOWN != this.currentState) {
            Object object = this.wait;
            synchronized (object) {
                try {
                    this.currentState.run();
                    if (this.wait != null) {
                        this.wait.wait(1500L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        LOG.debug((Object)"leaving runnable");
    }

    public void setActive(boolean active) {
        this.changeState(active ? this.ACTIVATED : this.DEACTIVATED);
    }

    void getStatus() throws PCSCException, IllegalStateException {
        this.terminal.getStatus();
    }

    boolean isShutdown() {
        return this.currentState.isShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void changeState(RunState newState) {
        if (this.currentState == newState) {
            return;
        }
        if (this.wait == null) {
            return;
        }
        Object object = this.wait;
        synchronized (object) {
            RunState oldState = this.currentState;
            this.currentState = newState;
            LOG.debug((Object)("current state changed: " + oldState + " -> " + this.currentState));
            this.wait.notifyAll();
        }
    }

    private static interface RunState
    extends Runnable {
        public boolean isActive();

        public boolean isShutdown();

        public String toString();
    }
}

