/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.impl;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.HexUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class PaceInputData {
    private static final Logger LOG = Logger.getLogger(PaceInputData.class);
    private byte[] encoded = null;

    public PaceInputData(byte pinID, byte[] chat, byte[] pin, byte[] certificateDescription) {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            baos.write(pinID);
            if (!ArrayUtil.isNullOrEmpty(chat)) {
                baos.write(chat.length);
                baos.write(chat);
            } else {
                baos.write(0);
            }
            if (!ArrayUtil.isNullOrEmpty(pin)) {
                baos.write(pin.length);
                baos.write(pin);
            } else {
                baos.write(0);
            }
            if (!ArrayUtil.isNullOrEmpty(certificateDescription)) {
                if (certificateDescription.length < 256) {
                    baos.write(certificateDescription.length);
                    baos.write(0);
                } else {
                    baos.write(certificateDescription.length % 256);
                    baos.write((byte)(certificateDescription.length / 256));
                }
                baos.write(certificateDescription);
            } else {
                baos.write(0);
                baos.write(0);
            }
            baos.flush();
            baos.close();
            byte[] tmp = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            baos.write(HexUtil.parse("02"));
            baos.write(tmp.length % 256);
            baos.write((byte)(tmp.length / 256));
            baos.write(tmp);
            baos.flush();
            baos.close();
        }
        catch (IOException e) {
            LOG.debug((Object)"error using ByteArrayOutputStream", (Throwable)e);
        }
        this.encoded = baos.toByteArray();
    }

    public byte[] getEncoded() {
        return this.encoded;
    }
}

