/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.impl;

import de.bos_bremen.basecard.Command;
import de.bos_bremen.basecard.Response;
import de.bos_bremen.basecard.common.dialog.BDialogMode;
import de.bos_bremen.basecard.common.dialog.BEnhancedTerminalDialog;
import de.bos_bremen.basecard.common.dialog.BTerminalDialog;
import de.bos_bremen.basecard.common.pin.PinVerifyParameters;
import de.bos_bremen.basecard.terminal.BTerminalException;
import de.bos_bremen.basecard.terminal.TerminalParameters;
import de.bos_bremen.basecard.terminal.impl.AbstractBTerminalImpl;
import de.bos_bremen.basecard.terminal.pcsc.PCSCTerminal;
import de.bos_bremen.basecard.terminal.pcsc.PaceCapabilities;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Constants;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Features;
import de.bos_bremen.basecard.terminal.pcsc.handler.Pcsc20PinStructureHandler;
import de.bos_bremen.basecard.terminal.pcsc.handler.impl.Pcsc20PinStructureHandlerFactory;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.AbstractPinStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PinModifyStructure;
import de.bos_bremen.basecard.terminal.pcsc.impl.WindowsPCSCTransactionManagementRunnable;
import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.java.JUnoNotFoundException;
import de.bos_bremen.java.pcsc.EnhancedJPCSCReaderState;
import de.bos_bremen.java.pcsc.JPCSC;
import de.bos_bremen.java.pcsc.JPCSCReaderState;
import de.bos_bremen.java.pcsc.Protocol;
import de.bos_bremen.java.pcsc.impl.EnhancedJPCSCReaderStateImpl;
import de.bos_bremen.java.pcsc.impl.JPCSCFactoryImpl;
import de.bos_bremen.jni.pcsc.PCSCException;
import de.bos_bremen.jni.pcsc.PCSCReaderState;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;

public class JPCSCTerminalImpl
extends AbstractBTerminalImpl
implements PCSCTerminal,
Pcsc20Constants {
    private static final Logger LOG = Logger.getLogger(JPCSCTerminalImpl.class);
    private static JPCSC jpcsc = null;
    private static long contextHandle = 0L;
    private static int connectionCount = 0;
    private static List<String> existingTerminalNames = new ArrayList<String>();
    private long cardHandle = 0L;
    private String name = null;
    private boolean transactionLocked = false;
    private boolean tpduUsesISO = true;
    private EnhancedJPCSCReaderState readerState = null;
    private Pcsc20PinStructureHandler structureHandler = null;
    private Pcsc20Features features = null;
    private WindowsPCSCTransactionManagementRunnable transactionKeepAliveRunnable;
    public static final int GET_KEY_PRESSED_DELAY = 50;
    private static final int TIMEOUT_KEY_COUNT_FACTOR = 12;
    private static final int MILLISECONDS_FACTOR = 1000;
    private static final Log LOGGER = LogFactory.getLog(JPCSCTerminalImpl.class);

    @Override
    public String getName() {
        return this.name;
    }

    public JPCSCTerminalImpl(String name) throws JUnoNotFoundException, IllegalArgumentException {
        super(null);
        if (name == null) {
            throw new IllegalArgumentException("null name not permitted");
        }
        this.initJPCSC(name);
        this.name = name;
        this.readerState = new EnhancedJPCSCReaderStateImpl(name, 0, 0, 0, null, 0);
        try {
            String s = System.getProperty("Uses_Standard_ISO_TPDU", "");
            this.tpduUsesISO = !"false".equals(s);
        }
        catch (Exception e) {
            this.tpduUsesISO = true;
        }
        this.createPcsc20Features();
        this.transactionKeepAliveRunnable = WindowsPCSCTransactionManagementRunnable.createKeepAliveRunnable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJPCSC(String name) {
        Class<JPCSCTerminalImpl> clazz = JPCSCTerminalImpl.class;
        synchronized (JPCSCTerminalImpl.class) {
            if (jpcsc == null) {
                jpcsc = (JPCSC)JPCSCFactoryImpl.getFactory().getImplementation(SystemEnum.getCurrentSystem().ordinal());
            }
            if (existingTerminalNames.contains(name)) {
                throw new IllegalArgumentException("terminal instance for " + name + " already existing");
            }
            existingTerminalNames.add(name);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long establishContext() throws PCSCException {
        Class<JPCSCTerminalImpl> clazz = JPCSCTerminalImpl.class;
        synchronized (JPCSCTerminalImpl.class) {
            if (contextHandle == 0L) {
                contextHandle = jpcsc.establishContext(0, null, null);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return contextHandle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseContext() throws PCSCException, IllegalStateException {
        Class<JPCSCTerminalImpl> clazz = JPCSCTerminalImpl.class;
        synchronized (JPCSCTerminalImpl.class) {
            if (jpcsc != null) {
                JPCSCTerminalImpl.checkContextEstablished();
                if (connectionCount > 1 || connectionCount == 1 && this.cardHandle == 0L) {
                    throw new IllegalStateException("there are still some active connections in this context");
                }
                JPCSCTerminalImpl.releaseContextShutdown();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.cardHandle = 0L;
            this.transactionLocked = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseContextShutdown() throws PCSCException, IllegalStateException {
        Class<JPCSCTerminalImpl> clazz = JPCSCTerminalImpl.class;
        synchronized (JPCSCTerminalImpl.class) {
            if (jpcsc != null) {
                JPCSCTerminalImpl.checkContextEstablished();
                try {
                    jpcsc.releaseContext(contextHandle);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                contextHandle = 0L;
                connectionCount = 0;
                jpcsc = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PCSCReaderState getStatus() throws PCSCException, IllegalStateException {
        if (this.readerState instanceof EnhancedJPCSCReaderState) {
            JPCSCTerminalImpl.checkContextEstablished();
            JPCSCTerminalImpl jPCSCTerminalImpl = this;
            synchronized (jPCSCTerminalImpl) {
                jpcsc.status(this.cardHandle, this.readerState);
            }
            return this.readerState;
        }
        return null;
    }

    @Override
    public PCSCReaderState getStatusChange() throws PCSCException, IllegalStateException {
        return this.getStatusChange(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PCSCReaderState getStatusChange(int timeout) throws PCSCException, IllegalStateException, IllegalArgumentException {
        JPCSCTerminalImpl.checkContextEstablished();
        try {
            jpcsc.getStatusChange(contextHandle, timeout, new JPCSCReaderState[]{this.readerState});
            return this.readerState;
        }
        catch (PCSCException e) {
            if (this.transactionKeepAliveRunnable.isShutdown()) return this.readerState;
            try {
                LOG.error((Object)"try reestablishing context...");
                long lContextHandle = jpcsc.establishContext(0, null, null);
                jpcsc.getStatusChange(lContextHandle, timeout, new JPCSCReaderState[]{this.readerState});
                Class<JPCSCTerminalImpl> clazz = JPCSCTerminalImpl.class;
                synchronized (JPCSCTerminalImpl.class) {
                    contextHandle = lContextHandle;
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    this.createPcsc20Features();
                    LOG.error((Object)"reestablising new context ... successful");
                    return this.readerState;
                }
            }
            catch (PCSCException ex) {
                LOG.error((Object)"reestablising new context ... failed");
                throw e;
            }
        }
    }

    @Override
    public long connect(boolean exclusive) throws PCSCException, IllegalStateException {
        return this.connect(exclusive, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long connect(boolean exclusive, Protocol protocol) throws PCSCException, IllegalStateException {
        JPCSCTerminalImpl jPCSCTerminalImpl = this;
        synchronized (jPCSCTerminalImpl) {
            if (this.isConnected()) {
                throw new IllegalStateException("terminal already connected");
            }
            Protocol prot = protocol == null ? new Protocol(3) : protocol;
            int requestedShareMode = exclusive ? 1 : 2;
            Class<JPCSCTerminalImpl> clazz = JPCSCTerminalImpl.class;
            synchronized (JPCSCTerminalImpl.class) {
                JPCSCTerminalImpl.checkContextEstablished();
                this.cardHandle = jpcsc.connect(contextHandle, this.name, requestedShareMode, prot);
                ++connectionCount;
                // ** MonitorExit[var6_6] (shouldn't be in output)
                this.readerState.setProtocol(prot);
                this.readerState.setSharingMode(requestedShareMode);
            }
        }
        return this.cardHandle;
    }

    @Override
    public synchronized void disconnect(int disposition) throws PCSCException, IllegalStateException {
        this.checkConnectionEstablished();
        this.setKeepAliveRunnableDeactivated();
        jpcsc.disconnect(this.cardHandle, disposition);
        --connectionCount;
        this.cardHandle = 0L;
        this.readerState.setProtocolValue(0);
        this.transactionLocked = false;
    }

    @Override
    public boolean isConnected() {
        return this.cardHandle != 0L;
    }

    @Override
    public boolean beginTransaction() throws IllegalStateException {
        return this.beginTransaction(10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean beginTransaction(int timeout) throws IllegalStateException {
        JPCSCTerminalImpl jPCSCTerminalImpl = this;
        synchronized (jPCSCTerminalImpl) {
            if (this.transactionLocked) {
                throw new IllegalStateException("terminal already locked");
            }
            this.checkConnectionEstablished();
            try {
                jpcsc.beginTransaction(this.cardHandle, timeout);
                this.transactionLocked = true;
                this.setKeepAliveRunnableActive();
            }
            catch (PCSCException e) {
                this.setKeepAliveRunnableDeactivated();
                if (e.getCode() == -2146434968L) {
                    try {
                        jpcsc.reconnect(this.cardHandle, this.readerState.getSharingMode(), this.readerState.getProtocol(), 0);
                    }
                    catch (PCSCException e1) {
                        throw new IllegalStateException("state of card not recoverable, reconnect failed, giving up");
                    }
                    catch (IllegalArgumentException e1) {
                        LOG.debug((Object)"", (Throwable)e1);
                    }
                }
                this.transactionLocked = false;
            }
        }
        return this.transactionLocked;
    }

    private void setKeepAliveRunnableActive() {
        this.transactionKeepAliveRunnable.setActive(true);
    }

    @Override
    public synchronized boolean endTransaction() throws IllegalStateException {
        if (!this.transactionLocked) {
            throw new IllegalStateException("no transaction lock existing");
        }
        try {
            this.setKeepAliveRunnableDeactivated();
            jpcsc.endTransaction(this.cardHandle, 0);
            this.transactionLocked = false;
            return true;
        }
        catch (PCSCException e) {
            if (e.getCode() == -2146434967L || e.getCode() == -2146434968L) {
                this.transactionLocked = false;
                return true;
            }
            return false;
        }
    }

    private void setKeepAliveRunnableDeactivated() {
        this.transactionKeepAliveRunnable.setActive(false);
    }

    @Override
    public boolean isTransactionLocked() {
        return this.transactionLocked;
    }

    @Override
    public byte[] transmit(byte[] command) throws PCSCException, IllegalStateException, IllegalArgumentException {
        return this.transmit(command, 2048);
    }

    @Override
    public synchronized byte[] transmit(byte[] command, int responseBufferSize) throws PCSCException, IllegalStateException, IllegalArgumentException {
        this.transactionKeepAliveRunnable.updateAccessTime();
        this.checkConnectionEstablished();
        if (this.readerState.getProtocolValue() == 2) {
            return jpcsc.transmit(this.cardHandle, this.readerState.getProtocol(), command, responseBufferSize);
        }
        return this.t0Transmit(command, responseBufferSize);
    }

    @Override
    public synchronized byte[] sendTerminalCommand(int controlCode, byte[] cmd) throws PCSCException, IllegalStateException {
        return this.sendTerminalCommand(controlCode, cmd, 2048);
    }

    @Override
    public synchronized byte[] sendTerminalCommand(int controlCode, byte[] cmd, int responseBufferSize) throws PCSCException, IllegalStateException, IllegalArgumentException {
        this.checkConnectionEstablished();
        this.transactionKeepAliveRunnable.updateAccessTime();
        return jpcsc.control(this.cardHandle, controlCode, cmd, responseBufferSize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] t0Transmit(byte[] command, int resultBufferSize) throws PCSCException, IllegalArgumentException {
        byte[] lCommand = command;
        byte[] responseData = null;
        int lenbuf = lCommand.length;
        int le = 0;
        if (lenbuf > 4) {
            le = lCommand[4];
            if ((le = JPCSCTerminalImpl.convertByte(le)) == 0) {
                le = 256;
            }
        }
        int caseAPDU = 0;
        if (lenbuf == 4) {
            caseAPDU = 1;
        } else if (lenbuf == 5) {
            caseAPDU = 2;
            le = lCommand[4];
        } else if (le + 5 == lenbuf) {
            caseAPDU = 3;
        } else if (le + 5 + 1 == lenbuf) {
            caseAPDU = 4;
            le = JPCSCTerminalImpl.convertByte(lCommand[lCommand.length - 1]);
            byte[] sendBuffer = new byte[lCommand.length - 1];
            System.arraycopy(lCommand, 0, sendBuffer, 0, sendBuffer.length);
            lCommand = sendBuffer;
        } else {
            BigInteger leExtended;
            if (lCommand[4] != 0) throw new IllegalArgumentException("Did not recognize the APDU command");
            if (lenbuf == 7) {
                leExtended = new BigInteger(new byte[]{lCommand[4], lCommand[5], lCommand[6]});
                caseAPDU = 2;
                le = leExtended.intValue();
            } else {
                leExtended = new BigInteger(new byte[]{lCommand[4], lCommand[5], lCommand[6]});
                if (leExtended.intValue() + 3 + 4 == lenbuf) {
                    caseAPDU = 3;
                    le = leExtended.intValue();
                } else {
                    if (leExtended.intValue() + 3 + 4 + 2 != lenbuf) throw new IllegalArgumentException("Did not recognize the APDU command");
                    caseAPDU = 4;
                    le = leExtended.intValue();
                }
            }
        }
        this.transactionKeepAliveRunnable.updateAccessTime();
        responseData = jpcsc.transmit(this.cardHandle, this.readerState.getProtocol(), lCommand, resultBufferSize);
        JPCSCTerminalImpl.checkNonNullResponse(responseData);
        switch (caseAPDU) {
            case 2: {
                int l;
                if (responseData[responseData.length - 2] != 108) return responseData;
                int k = JPCSCTerminalImpl.convertByte(responseData[responseData.length - 1]);
                if (k == 0) {
                    k = 256;
                }
                if ((l = JPCSCTerminalImpl.convertByte(le)) == 0) {
                    l = 256;
                }
                lCommand[4] = responseData[responseData.length - 1];
                responseData = jpcsc.transmit(this.cardHandle, this.readerState.getProtocol(), lCommand, resultBufferSize);
                JPCSCTerminalImpl.checkNonNullResponse(responseData);
                if (l >= k) return responseData;
                byte[] abyte3 = new byte[l + 2];
                System.arraycopy(responseData, 0, abyte3, 0, l);
                System.arraycopy(responseData, responseData.length - 2, abyte3, l, 2);
                responseData = new byte[abyte3.length];
                System.arraycopy(abyte3, 0, responseData, 0, abyte3.length);
                return responseData;
            }
            case 4: {
                StringBuffer sb = new StringBuffer("Case 4  + ISO TPDU support :  ");
                sb.append(this.tpduUsesISO);
                sb.append("  status returned by the card ");
                sb.append(responseData[responseData.length - 2]);
                if (responseData[responseData.length - 2] != 97 && (responseData[responseData.length - 2] != -112 || !this.tpduUsesISO) && responseData[responseData.length - 2] != -97 || responseData.length > 2 && responseData[responseData.length - 2] == -112) return responseData;
                byte[] abyte2 = new byte[5];
                abyte2[0] = lCommand[0];
                abyte2[1] = -64;
                abyte2[2] = 0;
                abyte2[3] = 0;
                int i1 = JPCSCTerminalImpl.convertByte(le);
                if (le == 0) {
                    i1 = 256;
                }
                abyte2[4] = (byte)le;
                if (responseData[responseData.length - 2] != -112 && JPCSCTerminalImpl.convertByte(responseData[responseData.length - 1]) < i1) {
                    abyte2[4] = responseData[responseData.length - 1];
                }
                responseData = jpcsc.transmit(this.cardHandle, this.readerState.getProtocol(), abyte2, resultBufferSize);
                JPCSCTerminalImpl.checkNonNullResponse(responseData);
                if (responseData[responseData.length - 2] != 108) return responseData;
                int j1 = JPCSCTerminalImpl.convertByte(responseData[responseData.length - 1]);
                i1 = JPCSCTerminalImpl.convertByte(le);
                if (i1 == 0) {
                    i1 = 256;
                }
                abyte2[4] = responseData[responseData.length - 1];
                responseData = jpcsc.transmit(this.cardHandle, this.readerState.getProtocol(), abyte2, resultBufferSize);
                JPCSCTerminalImpl.checkNonNullResponse(responseData);
                if (i1 >= j1) return responseData;
                byte[] abyte4 = new byte[le + 2];
                System.arraycopy(responseData, 0, abyte4, 0, i1);
                System.arraycopy(responseData, responseData.length - 2, abyte4, i1, 2);
                responseData = new byte[abyte4.length];
                System.arraycopy(abyte4, abyte4.length, responseData, responseData.length - 2, abyte4.length);
                return responseData;
            }
        }
        return responseData;
    }

    private static int convertByte(int value) {
        int result = value & 0x7F;
        if ((value & 0x80) == 128) {
            result += 128;
        }
        return result;
    }

    private static void checkNonNullResponse(byte[] bytes) throws IllegalArgumentException {
        if (bytes == null) {
            throw new IllegalArgumentException("No response from reader");
        }
    }

    private static void checkContextEstablished() throws IllegalStateException {
        if (contextHandle == 0L) {
            throw new IllegalStateException("no context established");
        }
    }

    private void checkConnectionEstablished() throws IllegalStateException {
        if (this.cardHandle == 0L) {
            throw new IllegalStateException("no connection established");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        if (this.transactionLocked) {
            this.endTransaction();
        }
        WindowsPCSCTransactionManagementRunnable.removeKeyAliveRunnable(this.name);
        this.transactionKeepAliveRunnable.shutdown();
        this.transactionKeepAliveRunnable = null;
        if (this.isConnected()) {
            try {
                this.disconnect(0);
            }
            catch (PCSCException pCSCException) {
                // empty catch block
            }
        }
        Class<JPCSCTerminalImpl> clazz = JPCSCTerminalImpl.class;
        synchronized (JPCSCTerminalImpl.class) {
            existingTerminalNames.remove(this.name);
            if (existingTerminalNames.isEmpty()) {
                try {
                    this.releaseContext();
                }
                catch (Exception e) {
                    LOG.error((Object)("error releasing PC/SC context:" + e.getMessage()), (Throwable)e);
                }
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            this.name = null;
            return;
        }
    }

    @Override
    public Response processCommand(int slot, Command cardCommand, TerminalParameters terminalParameters) throws BTerminalException, IllegalArgumentException {
        if (terminalParameters == null) {
            throw new IllegalArgumentException("terminalParameters must not be null");
        }
        if (terminalParameters.getPinParameters() == null) {
            throw new IllegalArgumentException("pinParameters (in terminalParameters) must not be null");
        }
        if (terminalParameters.getDialog() == null) {
            throw new IllegalArgumentException("dialog (in terminalParameters) must not be null");
        }
        PinVerifyParameters pvp = terminalParameters.getPinParameters();
        if (cardCommand != null) {
            if (pvp.getTemplate() != null && !ByteUtil.equals(pvp.getTemplate(), cardCommand.getBytes())) {
                throw new IllegalArgumentException("inconsistency: cardCommand and template in terminalParameters differ");
            }
            pvp.setTemplate(cardCommand.getBytes());
        }
        if (this.structureHandler == null) {
            this.structureHandler = Pcsc20PinStructureHandlerFactory.getHandler(this.name);
        }
        AbstractPinStructure aps = this.structureHandler.buildPinOperationStructure(pvp);
        byte[] res = null;
        try {
            res = this.sendPinTerminalCmd(aps, terminalParameters.getDialog());
        }
        catch (PCSCException e) {
            throw new BTerminalException(e);
        }
        return this.convert(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] sendPinTerminalCmd(AbstractPinStructure aps, BTerminalDialog chvDialog) throws PCSCException, IllegalArgumentException, IllegalStateException {
        if (aps == null) {
            throw new IllegalArgumentException("pin structure instance required, must not be null");
        }
        if (chvDialog == null) {
            throw new IllegalArgumentException("dialog instance required, must not be null");
        }
        if (this.features == null) {
            this.createPcsc20Features();
        }
        boolean verify = true;
        if (aps instanceof PinModifyStructure) {
            verify = false;
        }
        LOGGER.debug((Object)("PV/PM CMD : " + HexUtil.hexify(aps.getEncoded())));
        Object monitor = null;
        boolean useDirect = this.features.usePCSCVerifyModifyDirect(this.name, verify);
        try {
            monitor = chvDialog.showReaderMessage();
            if (!useDirect && !verify && this.features.isFeatureSupported(3)) {
                int okCountMax = 3;
                int codeStart = this.features.getModifyPINStart().valueAsNumber();
                int codeFinish = this.features.getModifyPINFinish().valueAsNumber();
                String descShort = "PM";
                String descStart = "perform modification - modify pin start";
                String descFinish = "perform modification - modify pin finish";
                byte[] byArray = this.doVerifyOrModifyStartFinish(aps, chvDialog, monitor, okCountMax, codeStart, codeFinish, descShort, descStart, descFinish);
                return byArray;
            }
            if (!useDirect && verify && this.features.isFeatureSupported(1)) {
                int okCountMax = 1;
                int codeStart = this.features.getVerifyPINStart().valueAsNumber();
                int codeFinish = this.features.getVerifyPINFinish().valueAsNumber();
                String descShort = "PV";
                String descStart = "perform verification - verify pin start";
                String descFinish = "perform verification - verify pin finish";
                byte[] byArray = this.doVerifyOrModifyStartFinish(aps, chvDialog, monitor, okCountMax, codeStart, codeFinish, descShort, descStart, descFinish);
                return byArray;
            }
            if (!verify && this.features.isFeatureSupported(7)) {
                LOGGER.debug((Object)("PM CMD [perform modification - modify pin direct]: " + HexUtil.hexify(aps.getEncoded())));
                byte[] rc = this.sendTerminalCommand(this.features.getModifyPINDirect().valueAsNumber(), aps.getEncoded());
                LOGGER.debug((Object)("PM RES [perform modification - modify pin direct]: " + HexUtil.hexify(rc)));
                LOGGER.debug((Object)("RES: " + HexUtil.hexify(rc)));
                byte[] byArray = rc;
                return byArray;
            }
            if (verify && this.features.isFeatureSupported(6)) {
                LOGGER.debug((Object)("PV CMD [perform verification - verify pin direct]: " + HexUtil.hexify(aps.getEncoded())));
                byte[] rc = this.sendTerminalCommand(this.features.getVerifyPINDirect().valueAsNumber(), aps.getEncoded());
                LOGGER.debug((Object)("PV RES [perform verification - verify pin direct]: " + HexUtil.hexify(rc)));
                byte[] byArray = rc;
                return byArray;
            }
        }
        finally {
            if (monitor != null) {
                chvDialog.hideReaderMessage(monitor);
            }
        }
        throw new IllegalArgumentException("illegal execution");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doVerifyOrModifyStartFinish(AbstractPinStructure aps, BTerminalDialog chvDialog, Object monitor, int okCountMax, int codeStart, int codeFinish, String descShort, String descStart, String descFinish) throws PCSCException {
        int okCount = 0;
        BEnhancedTerminalDialog tmpDialog = null;
        if (BEnhancedTerminalDialog.class.isInstance(chvDialog) && (tmpDialog = (BEnhancedTerminalDialog)chvDialog).getMode() == BDialogMode.CARD_INIT_2) {
            okCount = 1;
        }
        byte[] rc = null;
        Object m = new Object();
        long time = JPCSCTerminalImpl.calculateTimeout(aps.getEncoded()) * (long)(okCountMax - okCount);
        byte result = 0;
        int display = 0;
        if (this.features.isFeatureSupported(10)) {
            LOGGER.debug((Object)"CMD: [get ifd pin properties]");
            rc = this.sendTerminalCommand(this.features.getIFDPINProperties().valueAsNumber(), new byte[0]);
            LOGGER.debug((Object)("RES [get ifd pin properties]: " + HexUtil.hexify(rc)));
        }
        LOGGER.debug((Object)(descShort + " CMD [" + descStart + "]: " + HexUtil.hexify(aps.getEncoded())));
        this.transactionKeepAliveRunnable.updateAccessTime();
        rc = this.sendTerminalCommand(codeStart, aps.getEncoded());
        LOGGER.debug((Object)(descShort + " RES [" + descStart + "]: " + HexUtil.hexify(rc)));
        long start = System.currentTimeMillis();
        long now = System.currentTimeMillis();
        Object object = m;
        synchronized (object) {
            try {
                while ((now = System.currentTimeMillis()) - start <= time && this.isConnected()) {
                    try {
                        m.wait(50L);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                    rc = this.sendTerminalCommand(this.features.getGetKeyPressed().valueAsNumber(), new byte[0]);
                    if (ArrayUtil.isNullOrEmpty(rc)) break;
                    try {
                        m.wait(50L);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                    result = rc[0];
                    if (result == 0) continue;
                    if (result == 43) {
                        ++display;
                    } else if (result == 13) {
                        if (++okCount == okCountMax) break;
                        if (tmpDialog != null) {
                            tmpDialog.displayMessage(monitor, okCount);
                        }
                        display = 0;
                    } else {
                        if (result == 27) break;
                        if (result == 8) {
                            if (display == 0) continue;
                            --display;
                        } else {
                            if (result != 10) {
                                if (result == 64) {
                                    LOGGER.debug((Object)"error indicated by terminal...");
                                } else {
                                    LOGGER.debug((Object)("unknown return of reader: " + HexUtil.hexify(rc)));
                                }
                                break;
                            }
                            display = 0;
                        }
                    }
                    chvDialog.pseudoDisplay(display);
                }
            }
            catch (PCSCException e) {
                LOGGER.debug((Object)("communication with terminal failed: " + e.getMessage()));
            }
        }
        LOGGER.debug((Object)(descShort + " CMD: [" + descFinish + "]"));
        rc = this.sendTerminalCommand(codeFinish, new byte[0]);
        LOGGER.debug((Object)(descShort + " RES [" + descFinish + "]: " + HexUtil.hexify(rc)));
        return rc;
    }

    private static long calculateTimeout(byte[] cmd) {
        int delayKey;
        int delayInput = cmd[0];
        if (delayInput < 0) {
            delayInput += 256;
        }
        if ((delayKey = cmd[1]) < 0) {
            delayKey += 256;
        }
        return delayInput * 1000 + 12 * delayKey * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPcsc20Features() {
        block26: {
            Pcsc20Features result = null;
            long context = 0L;
            try {
                context = this.establishContext();
            }
            catch (PCSCException e) {
                return;
            }
            Protocol prot = new Protocol(3);
            long handle = 0L;
            try {
                try {
                    handle = jpcsc.connect(context, this.name, 3, prot);
                }
                catch (PCSCException e) {
                    try {
                        handle = jpcsc.connect(context, this.name, 2, prot);
                    }
                    catch (PCSCException e2) {
                        if (handle != 0L) {
                            try {
                                jpcsc.disconnect(handle, 0);
                            }
                            catch (PCSCException e22) {
                                LOG.debug((Object)"disconnection failed", (Throwable)e22);
                            }
                        }
                        return;
                    }
                }
                byte[] tmpResult = null;
                List<Integer> ioFeatureRequestControlCodes = Pcsc20Features.getCM_IOCTL_GET_FEATURE_REQUEST();
                if (ioFeatureRequestControlCodes == null) break block26;
                int tmp = -1;
                for (int i = 0; i < ioFeatureRequestControlCodes.size(); ++i) {
                    tmp = ioFeatureRequestControlCodes.get(i);
                    try {
                        LOGGER.debug((Object)("getFeatures - requesting features: " + (tmp == 3224864 ? "windows" : "linux/pcsc-lite")));
                        tmpResult = jpcsc.control(handle, tmp, null, 2048);
                        LOGGER.debug((Object)("getFeatures - response: " + HexUtil.hexify(tmpResult)));
                    }
                    catch (PCSCException e) {
                        tmpResult = null;
                    }
                    LOGGER.debug((Object)"getFeatures requested - analyze result");
                    if (tmpResult != null && tmpResult.length >= 0) {
                        LOGGER.debug((Object)("getFeatures - using response: " + HexUtil.hexify(tmpResult)));
                        break;
                    }
                    LOGGER.debug((Object)"getFeatures - loop and try next request code");
                }
                if (tmpResult != null) {
                    result = new Pcsc20Features(tmpResult);
                    if (result.isFeatureSupported(32)) {
                        try {
                            byte[] paceCapabilities = jpcsc.control(handle, result.getExecutePACE().valueAsNumber(), HexUtil.parse("010000"), 2048);
                            result.setPaceCapabilities(new PaceCapabilities(paceCapabilities));
                        }
                        catch (PCSCException e) {
                            result.setPaceCapabilities(null);
                        }
                    }
                    this.features = result;
                    break block26;
                }
                this.features = result = Pcsc20Features.NO_FEATURES_CREATED_WHEN_CARD_INSERTED;
            }
            finally {
                if (handle != 0L) {
                    try {
                        jpcsc.disconnect(handle, 0);
                    }
                    catch (PCSCException e2) {
                        LOG.debug((Object)"disconnection failed", (Throwable)e2);
                    }
                }
            }
        }
    }

    @Override
    public Pcsc20Features getFeatures() {
        if (this.features == null) {
            this.createPcsc20Features();
        }
        return this.features;
    }

    @Override
    public long getCurrentContextHandle() {
        return contextHandle;
    }

    public static long getSystemContextHandle() {
        return contextHandle;
    }
}

