/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields;

import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructureDefinition;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields.AbstractDoubleByteField;
import java.util.List;

public class PINMaxExtraDigitField
extends AbstractDoubleByteField {
    public static final String DEFAULT_NAME = "PINMaxExtraDigit";
    public static final String DEFAULT_DESCRIPTION = "XXYY, where XX is minimum PIN size in digits, YY is maximum";
    public static final int DEFAULT_POSITION = 6;
    public static final PcscStructureDefinition DEFAULT_STRUCTURE = new PcscStructureDefinition(PINMaxExtraDigitField.class, 6);
    private static final int IDX_MINIMUM = 1;
    private static final int IDX_MAXIMUM = 0;

    public PINMaxExtraDigitField(PcscStructure parent, int position) throws InstantiationException, IllegalAccessException {
        super(parent, DEFAULT_NAME, DEFAULT_DESCRIPTION, position);
    }

    public void setMinimum(PinEncoder encoder, int minimum) throws IllegalArgumentException {
        if (minimum < 0) {
            throw new IllegalArgumentException("minimum of digits expected to be greater equals than 0");
        }
        if (encoder == PinEncoder.ENCODER_T50 ? minimum < 4 : (encoder == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK || encoder == PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK || encoder == PinEncoder.ENCODER_BCD) && minimum < 4) {
            throw new IllegalArgumentException("minimum of digits expected to be greater equals than 4");
        }
        super.setByte(1, (byte)minimum);
    }

    public int getMinimum() {
        return 0xFFFFFFFF & super.getByte(1);
    }

    public void setMaximum(PinEncoder encoder, int maximum) {
        if (maximum < 0) {
            throw new IllegalArgumentException("maximum of digits expected to be greater equals than 0");
        }
        if (encoder == PinEncoder.ENCODER_T50) {
            if (maximum > 255) {
                throw new IllegalArgumentException("maximum of digits expected to be less equals than 255");
            }
        } else if ((encoder == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK || encoder == PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK || encoder == PinEncoder.ENCODER_BCD) && maximum > 12) {
            throw new IllegalArgumentException("maximum of digits expected to be less equals than 12");
        }
        super.setByte(0, (byte)maximum);
    }

    public int getMaximum() {
        return 0xFFFFFFFF & super.getByte(0);
    }

    @Override
    public String toString() {
        return super.toString() + "Minimum: " + this.getMinimum() + "\nMaximimum: " + this.getMaximum() + "\n";
    }

    @Override
    public boolean intValid() {
        return true;
    }

    @Override
    public List<String> intGetSkippedStructureNameList() {
        return EMPTY_STRING_LIST;
    }
}

