/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields;

import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructureDefinition;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields.AbstractSingleByteField;
import java.util.List;

public class PINLengthFormatField
extends AbstractSingleByteField {
    public static final String DEFAULT_NAME = "PINLengthFormat";
    public static final String DEFAULT_DESCRIPTION = "bits 7-5: RFU, bit 4: set if system units are bytes, clear if system units are bits, bits 3-0: indicate PIN length position in system units, maximum is 15";
    public static final int DEFAULT_PIN_LENGTH_FORMAT_POSITION = 5;
    public static final PcscStructureDefinition DEFAULT_STRUCTURE = new PcscStructureDefinition(PINLengthFormatField.class, 5);
    public static final byte BIT_MASK_SYSTEM_UNITS = 16;
    public static final byte BIT_MASK_PIN_LENGTH_POSITION = 15;
    public static final int PIN_LENGTH_POSITION_MAXIMUM = 15;
    private static final boolean ENABLED_SYSTEM_UNITS_BITS = false;
    private static final boolean ENABLED_SYSTEM_UNITS_BYTES = true;

    public PINLengthFormatField(PcscStructure parent, int position) throws IllegalArgumentException {
        super(parent, DEFAULT_NAME, DEFAULT_DESCRIPTION, position);
    }

    public void setSystemUnits(int systemUnits) throws IllegalArgumentException {
        PcscStructure.Util.checkArgument(SYSTEM_UNIT_VALUES, systemUnits);
        switch (systemUnits) {
            case 0: {
                super.setBitMask((byte)16, false);
                break;
            }
            case 1: {
                super.setBitMask((byte)16, true);
                break;
            }
        }
    }

    public int getSystemUnits() {
        boolean enabled = this.isBitMaskSet((byte)16);
        int result = -1;
        result = true == enabled ? 1 : 0;
        return result;
    }

    public void setPinLengthPosition(int position) throws IllegalArgumentException {
        if (position < 0) {
            throw new IllegalArgumentException("position of PIN expected greater equals than 0");
        }
        if (position > 15) {
            throw new IllegalArgumentException("position of PIN expected less equals than 15, but " + position);
        }
        this.iValue = (byte)(this.iValue | position);
    }

    public int getPinLengthPosition() {
        int value = this.iValue & 0xF;
        return value;
    }

    @Override
    public final void setByte(byte value) {
        throw new IllegalArgumentException("use setSystemUnits()/setPinLengthPosition() instead of setValue()");
    }

    @Override
    public void setBitMask(byte mask, boolean setOrClear) {
        throw new IllegalArgumentException("use setSystemUnits()/setPinLengthPosition() instead of setBitMask()");
    }

    @Override
    public boolean intValid() {
        return true;
    }

    @Override
    public List<String> intGetSkippedStructureNameList() {
        return EMPTY_STRING_LIST;
    }

    @Override
    public String toString() {
        return super.toString() + "bits: " + PcscStructure.Util.toBitString(this.iValue) + "\nsystem units: " + (this.getSystemUnits() == 1 ? "bytes" : "bits") + "\nposition of PIN length: " + this.getPinLengthPosition() + "\n";
    }
}

