/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields;

import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructureDefinition;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields.AbstractSingleByteField;
import java.util.List;

public class PINBlockStringField
extends AbstractSingleByteField {
    public static final String DEFAULT_NAME = "PINBlockString";
    public static final String DEFAULT_DESCRIPTION = "bits 7-4 bits size of PIN length in APDU, bits 3-0 PIN block size after justification and formatting";
    public static final int DEFAULT_POSITION = 4;
    public static final PcscStructureDefinition DEFAULT_STRUCTURE = new PcscStructureDefinition(PINBlockStringField.class, 4);
    public static final int PIN_BLOCK_SIZE_MAXIMUM = 15;
    public static final byte BIT_MASK_PIN_BLOCK_SIZE = 15;
    public static final byte BIT_MASK_PIN_LENGTH_BIT_SIZE = -16;
    public static final int PIN_LENGTH_BIT_SIZE_MAXIMUM = 15;
    private static final int SHIFT_PIN_LENGTH_BIT_SIZE = 4;

    public PINBlockStringField(PcscStructure parent, int position) throws IllegalArgumentException {
        super(parent, DEFAULT_NAME, DEFAULT_DESCRIPTION, position);
    }

    public void setBitSizeOfPINLength(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("bit size of PIN Length expected greater equals than 0");
        }
        if (size > 15) {
            throw new IllegalArgumentException("bit size of PIN length expected less equals than 15, but " + size);
        }
        this.iValue = (byte)(this.iValue | size << 4);
    }

    public int getBitSizeOfPINLength() {
        int value = this.iValue & 0xFFFFFFF0;
        return value >>= 4;
    }

    public void setByteSizeOfPINBlock(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("byte size of PIN block expected greater equals than 0");
        }
        if (size > 15) {
            throw new IllegalArgumentException("byte size of PIN block expected less equals than 15, but " + size);
        }
        this.iValue = (byte)(this.iValue | size);
    }

    public int getByteSizeOfPINBlock() {
        int value = this.iValue & 0xF;
        return value;
    }

    @Override
    public final void setByte(byte value) {
        throw new IllegalArgumentException("use setBitSizeOfPINLength()/setByteSizeOfPINBlock() instead of setValue()");
    }

    @Override
    public void setBitMask(byte mask, boolean setOrClear) {
        throw new IllegalArgumentException("use setBitSizeOfPINLength()/setByteSizeOfPINBlock() instead of setBitMask()");
    }

    @Override
    public boolean intValid() {
        return true;
    }

    @Override
    public List<String> intGetSkippedStructureNameList() {
        return EMPTY_STRING_LIST;
    }

    @Override
    public String toString() {
        return super.toString() + "bit size of PIN length: " + this.getByteSizeOfPINBlock() + "\nbyte size of PIN block: " + this.getByteSizeOfPINBlock() + "\n";
    }
}

