/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.basecard.terminal.pcsc.handler.structures.fields;

import de.bos_bremen.basecard.terminal.pcsc.handler.structures.AbstractPcscStructure;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PcscStructure;
import de.bos_bremen.common.system.LanguageEnum;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class MessagesField
extends AbstractPcscStructure {
    public static final String DEFAULT_NAME = "MessagesField";
    public static final String DEFAULT_DESCRIPTION = "messages (number of messages to display for PIN verification/modification, language for messages, message index for verification or message indices, at least 2, for modification";
    public static final int DEFAULT_MESSAGE_FIELD_POSITION = 7;
    public static final int MESSAGE_IDX_PIN_INSERTION_PROMPT = 1;
    public static final int MESSAGE_IDX_PIN_MODIFICATION_PROMPT = 2;
    public static final int MESSAGE_IDX_NEW_PIN_CONFIRMATION_PROMPT = 3;
    public static final int NO_MESSAGES = 0;
    public static final int[] NO_MESSAGE_INDICES = new int[0];
    public static final int DEFAULT_MESSAGES_NUMBER_CCID_DEFAULT_MESSAGES = -1;
    public static final int DEFAULT_MESSAGES_NUMBER = 0;
    public static final int IDX_NUMBER_OF_MESSAGES = 0;
    public static final int IDX_LANGUAGE_START = 1;
    public static final int IDX_LANGUAGE_END = 2;
    public static final int IDX_MESSAGES_START = 3;
    private static final byte[] DEFAULT_VALUE = new byte[]{0};
    private byte[] value = DEFAULT_VALUE;
    private List<Integer> admittedNumberOfMessagesList = new ArrayList<Integer>();

    public MessagesField(PcscStructure parent, int position, List<Integer> admittedNumberOfMessagesList) throws IllegalArgumentException {
        super(parent, DEFAULT_NAME, DEFAULT_DESCRIPTION, position, EMPTY_CHILD_STRUCTURE_DEFINITION_LIST);
        if (admittedNumberOfMessagesList == null) {
            throw new IllegalArgumentException("List of admitted numbers for messages not admitted as null");
        }
        if (admittedNumberOfMessagesList.size() == 0) {
            throw new IllegalArgumentException("List of admitted numbers of messages not admitted to empty");
        }
        this.admittedNumberOfMessagesList = admittedNumberOfMessagesList;
    }

    @Override
    public final void intDestroy() {
        this.value = DEFAULT_VALUE;
    }

    @Override
    public final byte[] intGetEncoded() {
        return this.value;
    }

    public final int getNumberOfMessages() {
        return this.value[0] == -1 ? 0 : this.value[0];
    }

    public final int getLanguageID() {
        if (this.getNumberOfMessages() == 0) {
            return 65535;
        }
        ByteBuffer tmp = ByteBuffer.wrap(this.value, 1, 2);
        short id = tmp.getShort();
        return id;
    }

    public final LanguageEnum getLanguage() {
        int id = this.getLanguageID();
        return LanguageEnum.getByID(id);
    }

    public final void useNoMessages() {
        this.value = DEFAULT_VALUE;
    }

    public final void useCCIDDefaultMessages(LanguageEnum language, int[] msgIDs) {
        this.setMessages(language.getID(), msgIDs, true);
    }

    public final boolean areNoMessagesUsed() {
        return this.value[0] == 0;
    }

    public final boolean areCCIDDefaultMessagesUsed() {
        return this.value[0] == -1;
    }

    public final void setMessages(LanguageEnum language, int[] messageIndices) {
        if (language == null) {
            throw new IllegalArgumentException("language not specified");
        }
        if ((messageIndices == null || messageIndices.length == 0) && language == LanguageEnum.UNKNOWN) {
            throw new IllegalArgumentException("messages indices set, but language not specified");
        }
        this.setMessages(language.getID(), messageIndices, false);
    }

    public final void setMessages(int languageID, int[] messageIndices, boolean useDefaultMsg) {
        if (messageIndices == null || messageIndices.length == 0) {
            this.value = DEFAULT_VALUE;
        } else {
            if (languageID == LanguageEnum.UNKNOWN.getID()) {
                throw new IllegalArgumentException("messages indices set, but language not specified");
            }
            if (this.admittedNumberOfMessagesList.indexOf(messageIndices.length) < 0) {
                throw new IllegalArgumentException("illegal number of messages only 0 and " + this.admittedNumberOfMessagesList + " messages admitted");
            }
            this.value = new byte[3 + messageIndices.length];
            this.value[0] = (byte)(useDefaultMsg ? -1 : (byte)messageIndices.length);
            this.value[1] = (byte)(languageID % 256);
            this.value[2] = (byte)(languageID % 65536 / 256);
            for (int i = 0; i < messageIndices.length; ++i) {
                this.value[3 + i] = (byte)messageIndices[i];
            }
        }
    }

    public final int[] getMessageIndices() {
        if (this.areNoMessagesUsed() || this.areCCIDDefaultMessagesUsed()) {
            return NO_MESSAGE_INDICES;
        }
        int n = this.getNumberOfMessages();
        int[] result = new int[n];
        for (int i = 0; i < n; ++i) {
            result[i] = this.value[3 + i] & 0xFF;
        }
        return result;
    }

    public final List<Integer> getMessageIndicesList() {
        int[] tmp = this.getMessageIndices();
        List<Integer> result = PcscStructure.Util.createUnmodifiableList(Integer.class, tmp);
        return result;
    }

    @Override
    public String toString() {
        int n = this.getNumberOfMessages();
        int lid = this.getLanguageID();
        List<Integer> mil = this.getMessageIndicesList();
        return super.toString() + "number of messages: " + n + (this.areCCIDDefaultMessagesUsed() ? " - CCID defaults used" : "") + (String)(lid != LanguageEnum.UNKNOWN.getID() ? "\nlanguage: " + LanguageEnum.getByID(lid).getName() : "") + (String)(mil != null && mil.size() > 0 ? "\nindices of messages: " + mil : "") + "\n";
    }
}

